! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Sparse Stoichiometric Data Structures File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : saprc99_StoichiomSP.f90
! Time                 : Mon Feb 27 18:13:19 2017
! Working directory    : /home/jlinford/workspace/kppa/verify/ec_saprc99/kpp
! Equation file        : saprc99.kpp
! Output root filename : saprc99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE saprc99_StoichiomSP

  USE saprc99_Precision
  PUBLIC
  SAVE


! Row-compressed sparse data for the Jacobian of reaction products JVRP

  INTEGER, PARAMETER, DIMENSION(212) :: CROW_JVRP = (/ &
       1,  2,  3,  5,  7,  9, 11, 13, 15, 17, 18, 20, & ! index 1 - 12
      21, 22, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, & ! index 13 - 24
      36, 38, 40, 42, 43, 45, 47, 49, 51, 52, 53, 55, & ! index 25 - 36
      57, 58, 59, 61, 62, 63, 65, 67, 69, 70, 72, 74, & ! index 37 - 48
      76, 77, 78, 80, 82, 84, 86, 87, 89, 91, 93, 95, & ! index 49 - 60
      97, 98,100,102,104,106,108,110,111,113,114,116, & ! index 61 - 72
     118,120,122,124,126,128,129,131,132,134,136,138, & ! index 73 - 84
     140,142,144,146,148,149,151,152,154,156,158,160, & ! index 85 - 96
     162,164,166,168,170,171,173,174,176,178,180,182, & ! index 97 - 108
     184,186,188,190,192,194,195,197,198,200,202,203, & ! index 109 - 120
     205,207,208,209,210,212,214,215,217,219,221,222, & ! index 121 - 132
     224,226,227,229,231,232,234,235,237,239,240,242, & ! index 133 - 144
     243,244,245,247,249,250,252,254,255,257,259,261, & ! index 145 - 156
     263,265,267,268,270,272,274,276,278,279,281,283, & ! index 157 - 168
     285,286,288,290,292,293,295,296,298,299,301,303, & ! index 169 - 180
     305,306,308,309,310,312,314,316,318,320,322,324, & ! index 181 - 192
     326,328,330,332,334,336,338,340,342,344,346,348, & ! index 193 - 204
     350,352,354,356,358,360,362,364 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_JVRP_0 = (/ &
      70, 58, 58, 62, 58, 69, 58, 70, 58, 70, 62, 69, & ! index 1 - 12
      62, 70, 69, 71, 69, 70, 71, 18, 18, 70, 71, 71, & ! index 13 - 24
      71, 62, 62, 10, 10, 69, 74, 19, 19, 19, 74, 70, & ! index 25 - 36
      74, 71, 74, 43, 74, 43, 40, 74, 62, 74, 63, 69, & ! index 37 - 48
      63, 70, 25, 25, 25, 74, 62, 63, 63, 63, 63, 71, & ! index 49 - 60
      71, 17, 17, 74, 63, 74,  9, 74, 74, 66, 69, 63, & ! index 61 - 72
      66, 66, 71, 66, 66, 68, 69, 63, 68, 68, 71, 66, & ! index 73 - 84
      68, 68, 48, 69, 48, 63, 48, 71, 48, 66, 48, 68, & ! index 85 - 96
      48, 64, 69, 63, 64, 64, 66, 64, 71, 64, 68, 48, & ! index 97 - 108
      64, 64, 70, 72, 13, 69, 72, 63, 72, 71, 72, 66, & ! index 109 - 120
      72, 68, 72, 48, 72, 64, 72, 72, 70, 73, 14, 69, & ! index 121 - 132
      73, 63, 73, 71, 73, 66, 73, 68, 73, 48, 73, 64, & ! index 133 - 144
      73, 72, 73, 73, 67, 70, 15, 67, 69, 63, 67, 67, & ! index 145 - 156
      71, 66, 67, 67, 68, 48, 67, 64, 67, 67, 72, 67, & ! index 157 - 168
      73, 67, 65, 70, 16, 65, 69, 63, 65, 65, 71, 65, & ! index 169 - 180
      66, 65, 68, 48, 65, 64, 65, 65, 72, 65, 73, 65, & ! index 181 - 192
      67, 65, 22, 70, 22, 46, 70, 46, 63, 46, 28, 70, & ! index 193 - 204
      28, 63, 28, 56, 56, 56, 74, 56, 63, 27, 27, 69, & ! index 205 - 216
      56, 71, 55, 74, 55, 55, 71, 59, 74, 59, 59, 71, & ! index 217 - 228
      42, 74, 42, 60, 74, 60, 29, 74, 26, 74, 26, 37, & ! index 229 - 240
      74, 37, 45, 45, 45, 74, 45, 71, 41, 41, 74, 41, & ! index 241 - 252
      71, 12, 39, 74, 39, 71, 34, 74, 34, 71, 36, 71, & ! index 253 - 264
      38, 74, 38, 38, 71, 50, 74, 50, 62, 50, 71, 50, & ! index 265 - 276
      58, 50, 54, 74, 54, 62, 54, 58, 54, 52, 74, 52, & ! index 277 - 288
      62, 52, 71, 52, 61, 74, 61, 57, 74, 57, 35, 74, & ! index 289 - 300
      35, 62, 32, 74, 32, 33, 74, 33, 74, 44, 74, 44, & ! index 301 - 312
      62, 44, 71, 44, 58, 47, 74, 47, 62, 47, 71, 47, & ! index 313 - 324
      58, 49, 74, 49, 62, 49, 71, 49, 58, 11, 74, 20, & ! index 325 - 336
      74, 21, 74, 30, 74, 23, 74, 31, 74, 24, 74, 51, & ! index 337 - 348
      74, 51, 62, 51, 71, 51, 58, 53, 74, 53, 62, 53 /)
  INTEGER, PARAMETER, DIMENSION(3) :: ICOL_JVRP_1 = (/ &
      71, 53, 58 /)
  INTEGER, PARAMETER, DIMENSION(363) :: ICOL_JVRP = (/&
    ICOL_JVRP_0, ICOL_JVRP_1 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_JVRP_0 = (/ &
       1,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, & ! index 1 - 12
       8,  8,  9,  9, 10, 11, 11, 12, 13, 14, 14, 15, & ! index 13 - 24
      16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 24, 25, & ! index 25 - 36
      25, 26, 26, 27, 27, 28, 29, 29, 30, 30, 31, 31, & ! index 37 - 48
      32, 32, 33, 34, 35, 35, 36, 36, 37, 38, 39, 39, & ! index 49 - 60
      40, 41, 42, 42, 43, 43, 44, 44, 45, 46, 46, 47, & ! index 61 - 72
      47, 48, 48, 49, 50, 51, 51, 52, 52, 53, 53, 54, & ! index 73 - 84
      54, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, & ! index 85 - 96
      61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 67, & ! index 97 - 108
      67, 68, 69, 69, 70, 71, 71, 72, 72, 73, 73, 74, & ! index 109 - 120
      74, 75, 75, 76, 76, 77, 77, 78, 79, 79, 80, 81, & ! index 121 - 132
      81, 82, 82, 83, 83, 84, 84, 85, 85, 86, 86, 87, & ! index 133 - 144
      87, 88, 88, 89, 90, 90, 91, 92, 92, 93, 93, 94, & ! index 145 - 156
      94, 95, 95, 96, 96, 97, 97, 98, 98, 99, 99,100, & ! index 157 - 168
     100,101,102,102,103,104,104,105,105,106,106,107, & ! index 169 - 180
     107,108,108,109,109,110,110,111,111,112,112,113, & ! index 181 - 192
     113,114,115,115,116,117,117,118,118,119,120,120, & ! index 193 - 204
     121,121,122,123,124,125,125,126,126,127,128,128, & ! index 205 - 216
     129,129,130,130,131,132,132,133,133,134,135,135, & ! index 217 - 228
     136,136,137,138,138,139,140,140,141,141,142,143, & ! index 229 - 240
     143,144,145,146,147,147,148,148,149,150,150,151, & ! index 241 - 252
     151,152,153,153,154,154,155,155,156,156,157,157, & ! index 253 - 264
     158,158,159,160,160,161,161,162,162,163,163,164, & ! index 265 - 276
     164,165,166,166,167,167,168,168,169,170,170,171, & ! index 277 - 288
     171,172,172,173,174,174,175,176,176,177,178,178, & ! index 289 - 300
     179,179,180,180,181,182,182,183,184,185,185,186, & ! index 301 - 312
     186,187,187,188,188,189,189,190,190,191,191,192, & ! index 313 - 324
     192,193,193,194,194,195,195,196,196,197,197,198, & ! index 325 - 336
     198,199,199,200,200,201,201,202,202,203,203,204, & ! index 337 - 348
     204,205,205,206,206,207,207,208,208,209,209,210 /)
  INTEGER, PARAMETER, DIMENSION(3) :: IROW_JVRP_1 = (/ &
     210,211,211 /)
  INTEGER, PARAMETER, DIMENSION(363) :: IROW_JVRP = (/&
    IROW_JVRP_0, IROW_JVRP_1 /)



!  Stoichiometric Matrix in Compressed Column Sparse Format


  INTEGER, PARAMETER, DIMENSION(212) :: CCOL_STOICM = (/ &
       1,  4,  6,  8, 11, 14, 17, 20, 23, 26, 28, 31, & ! index 1 - 12
      34, 36, 38, 40, 43, 45, 47, 49, 51, 54, 57, 60, & ! index 13 - 24
      63, 66, 70, 73, 76, 79, 82, 86, 89, 92, 97,100, & ! index 25 - 36
     103,105,107,112,114,116,119,121,125,127,132,135, & ! index 37 - 48
     140,143,146,150,153,157,162,164,167,168,171,172, & ! index 49 - 60
     173,173,176,179,186,191,196,197,201,204,207,211, & ! index 61 - 72
     216,220,224,227,228,232,234,237,240,245,250,255, & ! index 73 - 84
     259,262,263,267,272,275,278,281,286,291,296,300, & ! index 85 - 96
     303,304,308,313,319,322,325,328,333,338,343,347, & ! index 97 - 108
     350,351,354,357,363,369,372,375,378,381,384,386, & ! index 109 - 120
     390,393,395,398,400,404,407,410,415,420,423,427, & ! index 121 - 132
     431,438,443,447,452,455,465,469,473,477,481,485, & ! index 133 - 144
     489,492,495,500,506,510,514,519,521,526,530,535, & ! index 145 - 156
     539,543,546,548,552,560,570,576,579,587,596,606, & ! index 157 - 168
     610,615,628,642,653,661,672,681,694,706,711,717, & ! index 169 - 180
     722,730,735,743,745,750,757,761,770,779,793,800, & ! index 181 - 192
     808,816,834,842,846,850,861,872,886,897,911,924, & ! index 193 - 204
     934,950,959,964,977,1000,1015,1025 /)

  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_0 = (/ &
      58, 69, 70, 58, 62, 58, 62, 58, 69, 70, 58, 69, & ! index 1 - 12
      70, 58, 70, 71, 62, 69, 70, 62, 70, 71, 69, 70, & ! index 13 - 24
      71, 69, 70, 18, 70, 71, 18, 70, 71, 18, 43, 69, & ! index 25 - 36
      71, 69, 71, 58, 70, 71, 58, 62, 10, 62, 10, 74, & ! index 37 - 48
      10, 58, 19, 69, 74, 19, 69, 74, 19, 63, 70, 19, & ! index 49 - 60
      70, 74, 43, 70, 74, 63, 70, 71, 74, 43, 71, 74, & ! index 61 - 72
      43, 70, 74, 40, 63, 74, 62, 63, 74, 63, 69, 70, & ! index 73 - 84
      74, 25, 63, 70, 25, 63, 70, 25, 63, 70, 71, 74, & ! index 85 - 96
      25, 70, 74, 62, 63, 74, 17, 63, 17, 63, 43, 63, & ! index 97 - 108
      70, 71, 74, 70, 71, 17, 74, 17, 63, 74, 63, 74, & ! index 109 - 120
       1,  9, 63, 74, 63, 74, 56, 63, 66, 69, 70, 26, & ! index 121 - 132
      63, 66, 56, 63, 66, 70, 71, 29, 56, 66, 56, 63, & ! index 133 - 144
      66, 63, 68, 69, 70, 37, 63, 68, 63, 68, 70, 71, & ! index 145 - 156
      29, 56, 63, 66, 68, 63, 68, 48, 69, 70, 48, 48, & ! index 157 - 168
      70, 71, 48, 48, 57, 64, 69, 37, 63, 64, 29, 56, & ! index 169 - 180
      60, 61, 63, 64, 66, 60, 63, 64, 70, 71, 60, 61, & ! index 181 - 192
      63, 64, 68, 48, 60, 61, 63, 64, 13, 70, 72, 13, & ! index 193 - 204
      70, 72, 66, 69, 70, 72,  3,  5, 62, 63, 72, 66, & ! index 205 - 216
      70, 71, 72,  3, 56, 66, 72,  3, 68, 72, 48,  3, & ! index 217 - 228
      61, 64, 72, 66, 72, 14, 70, 73, 14, 70, 73, 55, & ! index 229 - 240
      68, 69, 70, 73,  4,  6, 62, 63, 73, 55, 68, 70, & ! index 241 - 252
      71, 73,  4, 56, 66, 73,  4, 68, 73, 48,  4, 61, & ! index 253 - 264
      64, 73, 55, 66, 68, 72, 73, 55, 68, 73, 15, 67, & ! index 265 - 276
      70, 15, 67, 70, 46, 48, 67, 69, 70,  4,  6, 62, & ! index 277 - 288
      63, 67, 46, 48, 67, 70, 71,  4, 56, 66, 67,  4, & ! index 289 - 300
      67, 68, 48,  4, 61, 64, 67, 46, 48, 66, 67, 72, & ! index 301 - 312
      46, 48, 55, 67, 68, 73, 46, 48, 67, 16, 65, 70, & ! index 313 - 324
      16, 65, 70, 56, 65, 69, 70, 72,  4,  6, 62, 63, & ! index 325 - 336
      65, 56, 65, 70, 71, 72,  4, 56, 65, 66,  4, 65, & ! index 337 - 348
      68, 48,  4, 64, 65, 56, 65, 66, 55, 56, 65, 68 /)
  INTEGER, PARAMETER, DIMENSION(360) :: IROW_STOICM_1 = (/ &
      72, 73, 46, 48, 56, 65, 67, 72, 56, 65, 72, 22, & ! index 361 - 372
      57, 70, 22, 42, 66, 36, 46, 70, 39, 46, 63, 39, & ! index 373 - 384
      46,  7,  8, 28, 70, 28, 36, 63, 28, 36, 40, 56, & ! index 385 - 396
      63, 40, 56, 40, 56, 63, 74, 27, 56, 63, 27, 56, & ! index 397 - 408
      63,  2, 27, 63, 69, 70, 40, 43, 56, 63, 71, 55, & ! index 409 - 420
      72, 74, 40, 55, 63, 66, 43, 55, 71, 72, 40, 55, & ! index 421 - 432
      59, 64, 68, 73, 74, 40, 55, 59, 63, 68, 43, 59, & ! index 433 - 444
      71, 73, 42, 48, 56, 72, 74, 42, 66, 72, 48, 55, & ! index 445 - 456
      56, 59, 60, 64, 68, 72, 73, 74, 55, 60, 68, 72, & ! index 457 - 468
      29, 56, 63, 74, 26, 56, 66, 74, 26, 56, 63, 74, & ! index 469 - 480
      37, 59, 68, 74, 37, 59, 63, 74, 40, 45, 63, 40, & ! index 481 - 492
      45, 56, 40, 45, 63, 73, 74, 40, 43, 45, 63, 71, & ! index 493 - 504
      73, 40, 41, 63, 72, 40, 41, 72, 74, 40, 41, 43, & ! index 505 - 516
      71, 72, 12, 72, 39, 45, 46, 68, 74, 39, 43, 46, & ! index 517 - 528
      71, 34, 41, 46, 68, 74, 34, 43, 46, 71, 28, 36, & ! index 529 - 540
      43, 71, 38, 67, 74,  8, 38, 38, 43, 67, 71, 40, & ! index 541 - 552
      41, 50, 56, 60, 65, 68, 74,  2, 40, 41, 50, 56, & ! index 553 - 564
      62, 63, 68, 73, 74, 40, 43, 50, 65, 68, 71, 50, & ! index 565 - 576
      58, 59, 40, 50, 56, 63, 65, 68, 72, 74, 41, 48, & ! index 577 - 588
      54, 56, 59, 64, 68, 72, 74,  2, 40, 41, 54, 56, & ! index 589 - 600
      62, 63, 68, 73, 74, 54, 58, 59, 60, 40, 54, 61, & ! index 601 - 612
      65, 66, 40, 41, 45, 52, 55, 56, 59, 60, 61, 64, & ! index 613 - 624
      65, 68, 74,  2,  4, 40, 41, 45, 52, 55, 56, 60, & ! index 625 - 636
      62, 63, 68, 73, 74, 40, 41, 43, 52, 56, 57, 59, & ! index 637 - 648
      64, 65, 68, 71, 40, 52, 55, 56, 60, 63, 72, 73, & ! index 649 - 660
      55, 56, 59, 60, 61, 63, 64, 68, 72, 73, 74, 48, & ! index 661 - 672
      55, 56, 59, 61, 64, 68, 72, 73, 42, 48, 55, 56, & ! index 673 - 684
      57, 59, 60, 61, 63, 64, 68, 70, 74, 42, 48, 55, & ! index 685 - 696
      56, 57, 59, 60, 61, 63, 64, 68, 70, 35, 40, 59, & ! index 697 - 708
      68, 74, 35, 40, 45, 62, 63, 74, 32, 48, 59, 72 /)
  INTEGER, PARAMETER, DIMENSION(304) :: IROW_STOICM_2 = (/ &
      74, 32, 40, 41, 45, 48, 63, 68, 72, 33, 48, 59, & ! index 721 - 732
      72, 74, 33, 40, 41, 45, 48, 63, 68, 72, 66, 74, & ! index 733 - 744
      44, 55, 56, 68, 74,  2, 40, 44, 56, 62, 63, 74, & ! index 745 - 756
      44, 59, 68, 71, 40, 44, 45, 55, 56, 58, 63, 66, & ! index 757 - 768
      68, 47, 48, 50, 52, 54, 56, 64, 68, 74,  2,  4, & ! index 769 - 780
      40, 47, 48, 50, 54, 56, 61, 62, 64, 65, 68, 74, & ! index 781 - 792
      47, 48, 52, 64, 68, 70, 71, 47, 48, 56, 58, 61, & ! index 793 - 804
      64, 65, 66, 48, 49, 56, 59, 61, 64, 68, 74,  2, & ! index 805 - 816
       4, 12, 40, 42, 45, 48, 49, 56, 59, 61, 62, 63, & ! index 817 - 828
      64, 68, 72, 73, 74, 48, 49, 57, 59, 64, 68, 70, & ! index 829 - 840
      71, 49, 58, 59, 61, 11, 55, 68, 74,  2, 20, 40, & ! index 841 - 852
      42, 45, 56, 59, 63, 64, 68, 74, 21, 22, 42, 48, & ! index 853 - 864
      55, 56, 59, 60, 64, 68, 74, 30, 40, 42, 48, 55, & ! index 865 - 876
      56, 59, 60, 61, 64, 66, 68, 72, 74, 23, 42, 48, & ! index 877 - 888
      55, 56, 59, 60, 61, 64, 68, 74, 31, 32, 33, 34, & ! index 889 - 900
      35, 38, 39, 41, 45, 61, 63, 64, 68, 74, 12, 24, & ! index 901 - 912
      32, 33, 34, 35, 38, 41, 45, 63, 64, 68, 74, 42, & ! index 913 - 924
      48, 51, 55, 56, 59, 61, 64, 68, 74,  2,  3,  4, & ! index 925 - 936
      40, 42, 51, 55, 56, 59, 61, 62, 63, 64, 66, 68, & ! index 937 - 948
      74, 42, 48, 51, 55, 57, 59, 64, 68, 71, 51, 58, & ! index 949 - 960
      59, 60, 61, 38, 42, 48, 50, 52, 53, 55, 56, 59, & ! index 961 - 972
      60, 64, 68, 74,  2,  3,  4, 38, 40, 42, 48, 50, & ! index 973 - 984
      53, 54, 55, 56, 59, 60, 61, 62, 63, 64, 66, 68, & ! index 985 - 996
      72, 73, 74, 38, 42, 48, 53, 54, 55, 56, 57, 59, & ! index 997 - 1008
      60, 64, 66, 68, 70, 71, 40, 50, 53, 58, 59, 60, & ! index 1009 - 1020
      61, 63, 64, 68 /)
  INTEGER, PARAMETER, DIMENSION(1024) :: IROW_STOICM = (/&
    IROW_STOICM_0, IROW_STOICM_1, IROW_STOICM_2 /)

  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_0 = (/ &
       1,  1,  1,  2,  2,  3,  3,  4,  4,  4,  5,  5, & ! index 1 - 12
       5,  6,  6,  6,  7,  7,  7,  8,  8,  8,  9,  9, & ! index 13 - 24
       9, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 14, & ! index 25 - 36
      14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, & ! index 37 - 48
      20, 20, 21, 21, 21, 22, 22, 22, 23, 23, 23, 24, & ! index 49 - 60
      24, 24, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, & ! index 61 - 72
      28, 28, 28, 29, 29, 29, 30, 30, 30, 31, 31, 31, & ! index 73 - 84
      31, 32, 32, 32, 33, 33, 33, 34, 34, 34, 34, 34, & ! index 85 - 96
      35, 35, 35, 36, 36, 36, 37, 37, 38, 38, 39, 39, & ! index 97 - 108
      39, 39, 39, 40, 40, 41, 41, 42, 42, 42, 43, 43, & ! index 109 - 120
      44, 44, 44, 44, 45, 45, 46, 46, 46, 46, 46, 47, & ! index 121 - 132
      47, 47, 48, 48, 48, 48, 48, 49, 49, 49, 50, 50, & ! index 133 - 144
      50, 51, 51, 51, 51, 52, 52, 52, 53, 53, 53, 53, & ! index 145 - 156
      54, 54, 54, 54, 54, 55, 55, 56, 56, 56, 57, 58, & ! index 157 - 168
      58, 58, 59, 60, 62, 62, 62, 63, 63, 63, 64, 64, & ! index 169 - 180
      64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 66, 66, & ! index 181 - 192
      66, 66, 66, 67, 68, 68, 68, 68, 69, 69, 69, 70, & ! index 193 - 204
      70, 70, 71, 71, 71, 71, 72, 72, 72, 72, 72, 73, & ! index 205 - 216
      73, 73, 73, 74, 74, 74, 74, 75, 75, 75, 76, 77, & ! index 217 - 228
      77, 77, 77, 78, 78, 79, 79, 79, 80, 80, 80, 81, & ! index 229 - 240
      81, 81, 81, 81, 82, 82, 82, 82, 82, 83, 83, 83, & ! index 241 - 252
      83, 83, 84, 84, 84, 84, 85, 85, 85, 86, 87, 87, & ! index 253 - 264
      87, 87, 88, 88, 88, 88, 88, 89, 89, 89, 90, 90, & ! index 265 - 276
      90, 91, 91, 91, 92, 92, 92, 92, 92, 93, 93, 93, & ! index 277 - 288
      93, 93, 94, 94, 94, 94, 94, 95, 95, 95, 95, 96, & ! index 289 - 300
      96, 96, 97, 98, 98, 98, 98, 99, 99, 99, 99, 99, & ! index 301 - 312
     100,100,100,100,100,100,101,101,101,102,102,102, & ! index 313 - 324
     103,103,103,104,104,104,104,104,105,105,105,105, & ! index 325 - 336
     105,106,106,106,106,106,107,107,107,107,108,108, & ! index 337 - 348
     108,109,110,110,110,111,111,111,112,112,112,112 /)
  INTEGER, PARAMETER, DIMENSION(360) :: ICOL_STOICM_1 = (/ &
     112,112,113,113,113,113,113,113,114,114,114,115, & ! index 361 - 372
     115,115,116,116,116,117,117,117,118,118,118,119, & ! index 373 - 384
     119,120,120,120,120,121,121,121,122,122,123,123, & ! index 385 - 396
     123,124,124,125,125,125,125,126,126,126,127,127, & ! index 397 - 408
     127,128,128,128,128,128,129,129,129,129,129,130, & ! index 409 - 420
     130,130,131,131,131,131,132,132,132,132,133,133, & ! index 421 - 432
     133,133,133,133,133,134,134,134,134,134,135,135, & ! index 433 - 444
     135,135,136,136,136,136,136,137,137,137,138,138, & ! index 445 - 456
     138,138,138,138,138,138,138,138,139,139,139,139, & ! index 457 - 468
     140,140,140,140,141,141,141,141,142,142,142,142, & ! index 469 - 480
     143,143,143,143,144,144,144,144,145,145,145,146, & ! index 481 - 492
     146,146,147,147,147,147,147,148,148,148,148,148, & ! index 493 - 504
     148,149,149,149,149,150,150,150,150,151,151,151, & ! index 505 - 516
     151,151,152,152,153,153,153,153,153,154,154,154, & ! index 517 - 528
     154,155,155,155,155,155,156,156,156,156,157,157, & ! index 529 - 540
     157,157,158,158,158,159,159,160,160,160,160,161, & ! index 541 - 552
     161,161,161,161,161,161,161,162,162,162,162,162, & ! index 553 - 564
     162,162,162,162,162,163,163,163,163,163,163,164, & ! index 565 - 576
     164,164,165,165,165,165,165,165,165,165,166,166, & ! index 577 - 588
     166,166,166,166,166,166,166,167,167,167,167,167, & ! index 589 - 600
     167,167,167,167,167,168,168,168,168,169,169,169, & ! index 601 - 612
     169,169,170,170,170,170,170,170,170,170,170,170, & ! index 613 - 624
     170,170,170,171,171,171,171,171,171,171,171,171, & ! index 625 - 636
     171,171,171,171,171,172,172,172,172,172,172,172, & ! index 637 - 648
     172,172,172,172,173,173,173,173,173,173,173,173, & ! index 649 - 660
     174,174,174,174,174,174,174,174,174,174,174,175, & ! index 661 - 672
     175,175,175,175,175,175,175,175,176,176,176,176, & ! index 673 - 684
     176,176,176,176,176,176,176,176,176,177,177,177, & ! index 685 - 696
     177,177,177,177,177,177,177,177,177,178,178,178, & ! index 697 - 708
     178,178,179,179,179,179,179,179,180,180,180,180 /)
  INTEGER, PARAMETER, DIMENSION(304) :: ICOL_STOICM_2 = (/ &
     180,181,181,181,181,181,181,181,181,182,182,182, & ! index 721 - 732
     182,182,183,183,183,183,183,183,183,183,184,184, & ! index 733 - 744
     185,185,185,185,185,186,186,186,186,186,186,186, & ! index 745 - 756
     187,187,187,187,188,188,188,188,188,188,188,188, & ! index 757 - 768
     188,189,189,189,189,189,189,189,189,189,190,190, & ! index 769 - 780
     190,190,190,190,190,190,190,190,190,190,190,190, & ! index 781 - 792
     191,191,191,191,191,191,191,192,192,192,192,192, & ! index 793 - 804
     192,192,192,193,193,193,193,193,193,193,193,194, & ! index 805 - 816
     194,194,194,194,194,194,194,194,194,194,194,194, & ! index 817 - 828
     194,194,194,194,194,195,195,195,195,195,195,195, & ! index 829 - 840
     195,196,196,196,196,197,197,197,197,198,198,198, & ! index 841 - 852
     198,198,198,198,198,198,198,198,199,199,199,199, & ! index 853 - 864
     199,199,199,199,199,199,199,200,200,200,200,200, & ! index 865 - 876
     200,200,200,200,200,200,200,200,200,201,201,201, & ! index 877 - 888
     201,201,201,201,201,201,201,201,202,202,202,202, & ! index 889 - 900
     202,202,202,202,202,202,202,202,202,202,203,203, & ! index 901 - 912
     203,203,203,203,203,203,203,203,203,203,203,204, & ! index 913 - 924
     204,204,204,204,204,204,204,204,204,205,205,205, & ! index 925 - 936
     205,205,205,205,205,205,205,205,205,205,205,205, & ! index 937 - 948
     205,206,206,206,206,206,206,206,206,206,207,207, & ! index 949 - 960
     207,207,207,208,208,208,208,208,208,208,208,208, & ! index 961 - 972
     208,208,208,208,209,209,209,209,209,209,209,209, & ! index 973 - 984
     209,209,209,209,209,209,209,209,209,209,209,209, & ! index 985 - 996
     209,209,209,210,210,210,210,210,210,210,210,210, & ! index 997 - 1008
     210,210,210,210,210,210,211,211,211,211,211,211, & ! index 1009 - 1020
     211,211,211,211 /)
  INTEGER, PARAMETER, DIMENSION(1024) :: ICOL_STOICM = (/&
    ICOL_STOICM_0, ICOL_STOICM_1, ICOL_STOICM_2 /)

  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_0 = (/ &
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 1 - 5
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 6 - 10
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 11 - 15
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 16 - 20
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, & ! index 21 - 25
       -2.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 26 - 30
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, & ! index 31 - 35
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 36 - 40
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 41 - 45
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 46 - 50
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 51 - 55
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 56 - 60
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 61 - 65
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 66 - 70
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 71 - 75
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 76 - 80
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 81 - 85
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 86 - 90
       1.000000e+00_dp,  -1.000000e+00_dp,  6.100000e-01_dp,  6.100000e-01_dp,  3.900000e-01_dp, & ! index 91 - 95
       3.900000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 96 - 100
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, & ! index 101 - 105
       -2.000000e+00_dp,  2.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-01_dp,  -1.000000e+00_dp, & ! index 106 - 110
       8.000000e-01_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, & ! index 111 - 115
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 116 - 120
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 121 - 125
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 126 - 130
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 131 - 135
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 136 - 140
       1.000000e+00_dp,  -2.000000e+00_dp,  2.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp, & ! index 141 - 145
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_1 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 151 - 155
       -1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 156 - 160
       -1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 161 - 165
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 166 - 170
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 171 - 175
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp, & ! index 176 - 180
       5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 181 - 185
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 186 - 190
       5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 191 - 195
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -2.000000e+00_dp, & ! index 196 - 200
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 201 - 205
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 206 - 210
       2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 211 - 215
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 216 - 220
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 221 - 225
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 226 - 230
       -1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 231 - 235
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 236 - 240
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.500000e-01_dp, & ! index 241 - 245
       7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 246 - 250
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 251 - 255
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 256 - 260
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 261 - 265
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 266 - 270
       -1.000000e+00_dp,  2.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp,  1.000000e+00_dp, & ! index 271 - 275
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 276 - 280
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 281 - 285
       2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 286 - 290
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 291 - 295
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_2 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 301 - 305
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 306 - 310
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 311 - 315
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp,  2.000000e+00_dp, & ! index 316 - 320
       -2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 321 - 325
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 326 - 330
       1.000000e+00_dp,  1.000000e+00_dp,  2.500000e-01_dp,  7.500000e-01_dp,  2.500000e-01_dp, & ! index 331 - 335
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 336 - 340
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 341 - 345
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 346 - 350
       2.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 351 - 355
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 356 - 360
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 361 - 365
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  -2.000000e+00_dp, & ! index 366 - 370
       2.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 371 - 375
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 376 - 380
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 381 - 385
       2.000000e+00_dp,  6.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 386 - 390
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 391 - 395
       -1.000000e+00_dp,  2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 396 - 400
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 401 - 405
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 406 - 410
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 411 - 415
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 416 - 420
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 421 - 425
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 426 - 430
       3.400000e-02_dp,  3.400000e-02_dp,  -1.000000e+00_dp,  1.000000e-03_dp,  3.400000e-02_dp, & ! index 431 - 435
       9.650000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 436 - 440
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 441 - 445
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_3 = (/ &
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  6.160000e-01_dp, & ! index 451 - 455
       4.820000e-01_dp,  1.150000e-01_dp,  3.700000e-01_dp,  -1.000000e+00_dp,  4.200000e-02_dp, & ! index 456 - 460
       3.700000e-01_dp,  4.920000e-01_dp,  9.600000e-02_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 461 - 465
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp, & ! index 466 - 470
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  3.500000e-01_dp,  6.500000e-01_dp, & ! index 471 - 475
       -6.500000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 476 - 480
       -1.000000e+00_dp,  1.000000e+00_dp,  3.400000e-01_dp,  -3.400000e-01_dp,  -1.000000e+00_dp, & ! index 481 - 485
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  2.000000e+00_dp,  -1.000000e+00_dp, & ! index 486 - 490
       2.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.260000e+00_dp, & ! index 491 - 495
       -1.000000e+00_dp,  6.300000e-01_dp,  3.700000e-01_dp,  -1.000000e+00_dp,  1.260000e+00_dp, & ! index 496 - 500
       1.000000e+00_dp,  -1.000000e+00_dp,  6.300000e-01_dp,  -1.000000e+00_dp,  3.700000e-01_dp, & ! index 501 - 505
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 506 - 510
       -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 511 - 515
       1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e+00_dp, & ! index 516 - 520
       -1.000000e+00_dp,  2.300000e-01_dp,  2.400000e-01_dp,  7.600000e-01_dp,  -1.000000e+00_dp, & ! index 521 - 525
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 526 - 530
       2.300000e-01_dp,  2.400000e-01_dp,  7.600000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 531 - 535
       1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 536 - 540
       1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 541 - 545
       7.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 546 - 550
       -1.000000e+00_dp,  4.160000e-01_dp,  8.400000e-02_dp,  -1.000000e+00_dp,  8.400000e-02_dp, & ! index 551 - 555
       4.160000e-01_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  3.330000e-01_dp, & ! index 556 - 560
       4.500000e-01_dp,  9.000000e-01_dp,  -1.000000e+00_dp,  2.000000e-01_dp,  -1.000000e+00_dp, & ! index 561 - 565
       8.000000e-03_dp,  1.000000e-01_dp,  1.000000e-01_dp,  2.080000e-01_dp,  5.000000e-01_dp, & ! index 566 - 570
       5.000000e-01_dp,  -1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp, & ! index 571 - 575
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  6.700000e-01_dp,  -1.000000e+00_dp, & ! index 576 - 580
       6.700000e-01_dp,  3.400000e-01_dp,  3.300000e-01_dp,  3.300000e-01_dp,  6.700000e-01_dp, & ! index 581 - 585
       3.300000e-01_dp,  3.000000e-01_dp,  6.750000e-01_dp,  -1.000000e+00_dp,  3.000000e-01_dp, & ! index 586 - 590
       6.750000e-01_dp,  2.500000e-02_dp,  3.000000e-01_dp,  6.750000e-01_dp,  -1.000000e+00_dp, & ! index 591 - 595
       3.510000e-01_dp,  4.750000e-01_dp,  9.500000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_4 = (/ &
       -1.000000e+00_dp,  6.400000e-02_dp,  5.000000e-02_dp,  5.000000e-02_dp,  1.640000e-01_dp, & ! index 601 - 605
       -1.000000e+00_dp,  -1.000000e+00_dp,  4.500000e-01_dp,  5.500000e-01_dp,  7.000000e-01_dp, & ! index 606 - 610
       -1.000000e+00_dp,  7.000000e-01_dp,  3.000000e-01_dp,  3.000000e-01_dp,  3.360000e-01_dp, & ! index 611 - 615
       1.740000e-01_dp,  1.500000e-01_dp,  -1.000000e+00_dp,  1.290000e-01_dp,  5.500000e-02_dp, & ! index 616 - 620
       1.300000e-02_dp,  1.500000e-01_dp,  3.320000e-01_dp,  4.100000e-02_dp,  2.890000e-01_dp, & ! index 621 - 625
       6.700000e-01_dp,  -1.000000e+00_dp,  1.000000e-01_dp,  3.720000e-01_dp,  4.980000e-01_dp, & ! index 626 - 630
       7.420000e-01_dp,  2.300000e-02_dp,  -1.000000e+00_dp,  4.700000e-02_dp,  1.250000e-01_dp, & ! index 631 - 635
       2.100000e-01_dp,  -1.000000e+00_dp,  4.000000e-01_dp,  4.800000e-02_dp,  4.800000e-02_dp, & ! index 636 - 640
       2.850000e-01_dp,  5.720000e-01_dp,  8.000000e-03_dp,  1.500000e-01_dp,  -1.000000e+00_dp, & ! index 641 - 645
       2.270000e-01_dp,  5.720000e-01_dp,  2.180000e-01_dp,  5.100000e-02_dp,  1.500000e-01_dp, & ! index 646 - 650
       7.990000e-01_dp,  -1.000000e+00_dp,  1.233000e+00_dp,  -1.000000e+00_dp,  4.670000e-01_dp, & ! index 651 - 655
       3.000000e-01_dp,  2.330000e-01_dp,  1.233000e+00_dp,  4.670000e-01_dp,  3.000000e-01_dp, & ! index 656 - 660
       8.400000e-02_dp,  2.130000e-01_dp,  5.580000e-01_dp,  1.150000e-01_dp,  -6.710000e-01_dp, & ! index 661 - 665
       3.790000e-01_dp,  7.000000e-02_dp,  4.730000e-01_dp,  2.900000e-02_dp,  4.900000e-02_dp, & ! index 666 - 670
       -1.000000e+00_dp,  5.150000e-01_dp,  2.460000e-01_dp,  5.060000e-01_dp,  7.100000e-01_dp, & ! index 671 - 675
       -1.000000e+00_dp,  4.000000e-02_dp,  9.600000e-01_dp,  6.670000e-01_dp,  3.330000e-01_dp, & ! index 676 - 680
       6.000000e-03_dp,  5.960000e-01_dp,  4.390000e-01_dp,  1.000000e-02_dp,  -6.900000e-01_dp, & ! index 681 - 685
       2.130000e-01_dp,  1.770000e-01_dp,  4.800000e-02_dp,  1.130000e-01_dp,  1.730000e-01_dp, & ! index 686 - 690
       3.760000e-01_dp,  3.380000e-01_dp,  -1.000000e+00_dp,  2.000000e-02_dp,  1.520000e-01_dp, & ! index 691 - 695
       4.310000e-01_dp,  1.340000e-01_dp,  -1.000000e+00_dp,  1.470000e-01_dp,  2.430000e-01_dp, & ! index 696 - 700
       4.350000e-01_dp,  3.410000e-01_dp,  9.500000e-02_dp,  5.640000e-01_dp,  1.000000e+00_dp, & ! index 701 - 705
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 706 - 710
       -1.000000e+00_dp,  1.500000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.500000e+00_dp, & ! index 711 - 715
       5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp, & ! index 716 - 720
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp, & ! index 721 - 725
       1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp,  -1.000000e+00_dp, & ! index 726 - 730
       1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 731 - 735
       1.000000e+00_dp,  5.000000e-01_dp,  5.000000e-01_dp,  1.000000e+00_dp,  5.000000e-01_dp, & ! index 736 - 740
       1.000000e+00_dp,  5.000000e-01_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 741 - 745
       1.950000e-01_dp,  1.610000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  3.700000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(150) :: STOICM_5 = (/ &
       5.000000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.200000e-01_dp, & ! index 751 - 755
       1.200000e-01_dp,  -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp, & ! index 756 - 760
       4.910000e-01_dp,  -1.000000e+00_dp,  9.000000e-03_dp,  2.500000e-01_dp,  1.910000e-01_dp, & ! index 761 - 765
       -1.000000e+00_dp,  5.000000e-01_dp,  3.000000e-01_dp,  2.000000e-01_dp,  -1.000000e+00_dp, & ! index 766 - 770
       7.900000e-02_dp,  2.300000e-01_dp,  3.570000e-01_dp,  3.200000e-01_dp,  6.240000e-01_dp, & ! index 771 - 775
       9.300000e-02_dp,  9.070000e-01_dp,  -1.000000e+00_dp,  2.040000e-01_dp,  1.500000e-01_dp, & ! index 776 - 780
       2.750000e-01_dp,  -1.000000e+00_dp,  1.260000e-01_dp,  3.900000e-01_dp,  1.600000e-01_dp, & ! index 781 - 785
       5.920000e-01_dp,  1.000000e-01_dp,  -1.000000e+00_dp,  8.000000e-03_dp,  1.920000e-01_dp, & ! index 786 - 790
       6.600000e-02_dp,  2.660000e-01_dp,  -1.000000e+00_dp,  1.870000e-01_dp,  9.360000e-01_dp, & ! index 791 - 795
       6.400000e-02_dp,  7.490000e-01_dp,  1.870000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 796 - 800
       2.400000e-01_dp,  2.400000e-01_dp,  -1.000000e+00_dp,  7.500000e-01_dp,  1.000000e-02_dp, & ! index 801 - 805
       2.400000e-01_dp,  2.500000e-01_dp,  5.000000e-01_dp,  -1.000000e+00_dp,  2.760000e-01_dp, & ! index 806 - 810
       4.740000e-01_dp,  2.760000e-01_dp,  2.500000e-01_dp,  7.500000e-01_dp,  -1.000000e+00_dp, & ! index 811 - 815
       1.030000e-01_dp,  1.890000e-01_dp,  3.100000e-02_dp,  1.570000e-01_dp,  1.300000e-01_dp, & ! index 816 - 820
       1.000000e-03_dp,  7.290000e-01_dp,  -1.000000e+00_dp,  2.350000e-01_dp,  2.050000e-01_dp, & ! index 821 - 825
       2.760000e-01_dp,  -1.000000e+00_dp,  3.300000e-02_dp,  1.800000e-01_dp,  3.100000e-02_dp, & ! index 826 - 830
       1.230000e-01_dp,  2.010000e-01_dp,  5.670000e-01_dp,  7.500000e-01_dp,  -1.000000e+00_dp, & ! index 831 - 835
       2.760000e-01_dp,  4.740000e-01_dp,  2.500000e-01_dp,  2.760000e-01_dp,  4.740000e-01_dp, & ! index 836 - 840
       -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  1.470000e-01_dp,  8.530000e-01_dp, & ! index 841 - 845
       -1.000000e+00_dp,  1.000000e+00_dp,  1.000000e+00_dp,  -1.000000e+00_dp,  1.210000e-01_dp, & ! index 846 - 850
       -1.000000e+00_dp,  1.600000e-01_dp,  4.170000e-01_dp,  2.480000e-01_dp,  3.900000e-02_dp, & ! index 851 - 855
       1.550000e-01_dp,  1.210000e-01_dp,  2.100000e-02_dp,  6.120000e-01_dp,  -7.540000e-01_dp, & ! index 856 - 860
       -1.000000e+00_dp,  2.360000e-01_dp,  2.400000e-02_dp,  5.590000e-01_dp,  4.450000e-01_dp, & ! index 861 - 865
       2.600000e-02_dp,  1.220000e-01_dp,  3.320000e-01_dp,  7.000000e-02_dp,  6.950000e-01_dp, & ! index 866 - 870
       -1.000000e+00_dp,  -1.000000e+00_dp,  2.000000e-03_dp,  4.520000e-01_dp,  9.360000e-01_dp, & ! index 871 - 875
       4.550000e-01_dp,  2.400000e-02_dp,  2.440000e-01_dp,  1.100000e-01_dp,  1.250000e-01_dp, & ! index 876 - 880
       1.430000e-01_dp,  1.100000e-02_dp,  8.350000e-01_dp,  1.100000e-02_dp,  -1.000000e+00_dp, & ! index 881 - 885
       -1.000000e+00_dp,  7.200000e-02_dp,  9.480000e-01_dp,  9.900000e-02_dp,  2.600000e-02_dp, & ! index 886 - 890
       2.040000e-01_dp,  8.900000e-02_dp,  4.170000e-01_dp,  3.470000e-01_dp,  6.530000e-01_dp, & ! index 891 - 895
       -1.000000e+00_dp,  -1.000000e+00_dp,  1.080000e-01_dp,  5.100000e-02_dp,  2.070000e-01_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(124) :: STOICM_6 = (/ &
       4.910000e-01_dp,  5.900000e-02_dp,  1.700000e-02_dp,  1.190000e-01_dp,  1.180000e-01_dp, & ! index 901 - 905
       5.500000e-02_dp,  2.240000e-01_dp,  1.100000e-02_dp,  7.650000e-01_dp,  -1.000000e+00_dp, & ! index 906 - 910
       8.700000e-02_dp,  -1.000000e+00_dp,  9.900000e-02_dp,  9.300000e-02_dp,  1.870000e-01_dp, & ! index 911 - 915
       5.610000e-01_dp,  5.000000e-02_dp,  2.870000e-01_dp,  9.700000e-02_dp,  1.870000e-01_dp, & ! index 916 - 920
       9.000000e-03_dp,  8.040000e-01_dp,  -1.000000e+00_dp,  5.000000e-03_dp,  2.050000e-01_dp, & ! index 921 - 925
       -1.000000e+00_dp,  2.940000e-01_dp,  7.320000e-01_dp,  4.970000e-01_dp,  1.190000e-01_dp, & ! index 926 - 930
       9.000000e-02_dp,  9.100000e-01_dp,  -1.000000e+00_dp,  1.850000e-01_dp,  5.000000e-02_dp, & ! index 931 - 935
       1.190000e-01_dp,  3.450000e-01_dp,  1.000000e-03_dp,  -1.000000e+00_dp,  1.540000e-01_dp, & ! index 936 - 940
       5.000000e-01_dp,  3.630000e-01_dp,  2.150000e-01_dp,  -1.000000e+00_dp,  5.600000e-02_dp, & ! index 941 - 945
       1.000000e-03_dp,  7.600000e-02_dp,  2.200000e-02_dp,  1.550000e-01_dp,  2.400000e-02_dp, & ! index 946 - 950
       4.880000e-01_dp,  -1.000000e+00_dp,  9.000000e-03_dp,  5.110000e-01_dp,  3.700000e-02_dp, & ! index 951 - 955
       1.760000e-01_dp,  8.240000e-01_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  -1.000000e+00_dp, & ! index 956 - 960
       4.500000e-01_dp,  4.370000e-01_dp,  1.130000e-01_dp,  6.100000e-02_dp,  1.270000e-01_dp, & ! index 961 - 965
       1.000000e-03_dp,  2.500000e-02_dp,  2.500000e-02_dp,  -1.000000e+00_dp,  7.320000e-01_dp, & ! index 966 - 970
       2.440000e-01_dp,  5.110000e-01_dp,  7.200000e-02_dp,  8.200000e-02_dp,  9.180000e-01_dp, & ! index 971 - 975
       -1.000000e+00_dp,  7.300000e-02_dp,  1.290000e-01_dp,  2.470000e-01_dp,  4.200000e-02_dp, & ! index 976 - 980
       2.650000e-01_dp,  4.500000e-02_dp,  1.370000e-01_dp,  2.600000e-02_dp,  -1.000000e+00_dp, & ! index 981 - 985
       1.900000e-02_dp,  4.560000e-01_dp,  2.690000e-01_dp,  3.050000e-01_dp,  2.600000e-02_dp, & ! index 986 - 990
       4.300000e-02_dp,  -1.000000e+00_dp,  3.000000e-03_dp,  2.000000e-03_dp,  1.970000e-01_dp, & ! index 991 - 995
       3.300000e-02_dp,  1.370000e-01_dp,  6.000000e-03_dp,  3.780000e-01_dp,  1.500000e-02_dp, & ! index 996 - 1000
       1.020000e-01_dp,  7.110000e-01_dp,  -1.000000e+00_dp,  4.800000e-02_dp,  5.070000e-01_dp, & ! index 1001 - 1005
       7.900000e-02_dp,  3.210000e-01_dp,  1.510000e-01_dp,  1.000000e-03_dp,  1.360000e-01_dp, & ! index 1006 - 1010
       3.000000e-02_dp,  4.420000e-01_dp,  3.910000e-01_dp,  -1.000000e+00_dp,  1.200000e-02_dp, & ! index 1011 - 1015
       1.200000e-02_dp,  -1.000000e+00_dp,  -1.000000e+00_dp,  6.900000e-02_dp,  6.590000e-01_dp, & ! index 1016 - 1020
       2.590000e-01_dp,  1.300000e-02_dp,  1.000000e-03_dp,  1.200000e-02_dp /)
  REAL(kind=dp), PARAMETER, DIMENSION(1024) :: STOICM = (/&
    STOICM_0, STOICM_1, STOICM_2, STOICM_3, STOICM_4, &
    STOICM_5, STOICM_6 /)


END MODULE saprc99_StoichiomSP

