! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Stoichiometric Chemical Model File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : saprc99_Stoichiom.f90
! Time                 : Mon Feb 27 18:13:19 2017
! Working directory    : /home/jlinford/workspace/kppa/verify/ec_saprc99/kpp
! Equation file        : saprc99.kpp
! Output root filename : saprc99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE saprc99_Stoichiom

  USE saprc99_Parameters
  USE saprc99_StoichiomSP

  IMPLICIT NONE

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! ReactantProd - Reactant Products in each equation
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      ARP       - Reactant product in each equation
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE ReactantProd ( V, F, ARP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! ARP - Reactant product in each equation
  REAL(kind=dp) :: ARP(NREACT)


! Reactant Products in each equation are useful in the
!     stoichiometric formulation of mass action law
  ARP(1) = V(70)
  ARP(2) = V(58)*F(1)*F(2)
  ARP(3) = V(58)*V(62)
  ARP(4) = V(58)*V(69)*F(1)
  ARP(5) = V(58)*V(70)
  ARP(6) = V(58)*V(70)
  ARP(7) = V(62)*V(69)
  ARP(8) = V(62)*V(70)
  ARP(9) = V(69)*V(71)
  ARP(10) = V(69)*V(69)*F(2)
  ARP(11) = V(70)*V(71)
  ARP(12) = V(18)
  ARP(13) = V(18)*F(3)
  ARP(14) = V(70)*V(71)
  ARP(15) = V(71)
  ARP(16) = V(71)
  ARP(17) = V(62)
  ARP(18) = V(62)
  ARP(19) = V(10)*F(3)
  ARP(20) = V(10)*F(1)
  ARP(21) = V(69)*V(74)
  ARP(22) = V(19)
  ARP(23) = V(19)
  ARP(24) = V(19)*V(74)
  ARP(25) = V(70)*V(74)
  ARP(26) = V(71)*V(74)
  ARP(27) = V(43)*V(74)
  ARP(28) = V(43)
  ARP(29) = V(40)*V(74)
  ARP(30) = V(62)*V(74)
  ARP(31) = V(63)*V(69)
  ARP(32) = V(63)*V(70)
  ARP(33) = V(25)
  ARP(34) = V(25)
  ARP(35) = V(25)*V(74)
  ARP(36) = V(62)*V(63)
  ARP(37) = V(63)*V(63)
  ARP(38) = V(63)*V(63)*F(3)
  ARP(39) = V(63)*V(71)
  ARP(40) = V(71)*V(71)
  ARP(41) = V(17)
  ARP(42) = V(17)*V(74)
  ARP(43) = V(63)*V(74)
  ARP(44) = V(9)*V(74)
  ARP(45) = V(74)*F(4)
  ARP(46) = V(66)*V(69)
  ARP(47) = V(63)*V(66)
  ARP(48) = V(66)*V(71)
  ARP(49) = V(66)*V(66)
  ARP(50) = V(66)*V(66)
  ARP(51) = V(68)*V(69)
  ARP(52) = V(63)*V(68)
  ARP(53) = V(68)*V(71)
  ARP(54) = V(66)*V(68)
  ARP(55) = V(68)*V(68)
  ARP(56) = V(48)*V(69)
  ARP(57) = V(48)*V(63)
  ARP(58) = V(48)*V(71)
  ARP(59) = V(48)*V(66)
  ARP(60) = V(48)*V(68)
  ARP(61) = V(48)*V(48)
  ARP(62) = V(64)*V(69)
  ARP(63) = V(63)*V(64)
  ARP(64) = V(64)*V(66)
  ARP(65) = V(64)*V(71)
  ARP(66) = V(64)*V(68)
  ARP(67) = V(48)*V(64)
  ARP(68) = V(64)*V(64)
  ARP(69) = V(70)*V(72)
  ARP(70) = V(13)
  ARP(71) = V(69)*V(72)
  ARP(72) = V(63)*V(72)
  ARP(73) = V(71)*V(72)
  ARP(74) = V(66)*V(72)
  ARP(75) = V(68)*V(72)
  ARP(76) = V(48)*V(72)
  ARP(77) = V(64)*V(72)
  ARP(78) = V(72)*V(72)
  ARP(79) = V(70)*V(73)
  ARP(80) = V(14)
  ARP(81) = V(69)*V(73)
  ARP(82) = V(63)*V(73)
  ARP(83) = V(71)*V(73)
  ARP(84) = V(66)*V(73)
  ARP(85) = V(68)*V(73)
  ARP(86) = V(48)*V(73)
  ARP(87) = V(64)*V(73)
  ARP(88) = V(72)*V(73)
  ARP(89) = V(73)*V(73)
  ARP(90) = V(67)*V(70)
  ARP(91) = V(15)
  ARP(92) = V(67)*V(69)
  ARP(93) = V(63)*V(67)
  ARP(94) = V(67)*V(71)
  ARP(95) = V(66)*V(67)
  ARP(96) = V(67)*V(68)
  ARP(97) = V(48)*V(67)
  ARP(98) = V(64)*V(67)
  ARP(99) = V(67)*V(72)
  ARP(100) = V(67)*V(73)
  ARP(101) = V(67)*V(67)
  ARP(102) = V(65)*V(70)
  ARP(103) = V(16)
  ARP(104) = V(65)*V(69)
  ARP(105) = V(63)*V(65)
  ARP(106) = V(65)*V(71)
  ARP(107) = V(65)*V(66)
  ARP(108) = V(65)*V(68)
  ARP(109) = V(48)*V(65)
  ARP(110) = V(64)*V(65)
  ARP(111) = V(65)*V(72)
  ARP(112) = V(65)*V(73)
  ARP(113) = V(65)*V(67)
  ARP(114) = V(65)*V(65)
  ARP(115) = V(22)*V(70)
  ARP(116) = V(22)
  ARP(117) = V(46)*V(70)
  ARP(118) = V(46)*V(63)
  ARP(119) = V(46)
  ARP(120) = V(28)*V(70)
  ARP(121) = V(28)*V(63)
  ARP(122) = V(28)
  ARP(123) = V(56)
  ARP(124) = V(56)
  ARP(125) = V(56)*V(74)
  ARP(126) = V(56)*V(63)
  ARP(127) = V(27)
  ARP(128) = V(27)*V(69)
  ARP(129) = V(56)*V(71)
  ARP(130) = V(55)*V(74)
  ARP(131) = V(55)
  ARP(132) = V(55)*V(71)
  ARP(133) = V(59)*V(74)
  ARP(134) = V(59)
  ARP(135) = V(59)*V(71)
  ARP(136) = V(42)*V(74)
  ARP(137) = V(42)
  ARP(138) = V(60)*V(74)
  ARP(139) = V(60)
  ARP(140) = V(29)*V(74)
  ARP(141) = V(26)*V(74)
  ARP(142) = V(26)
  ARP(143) = V(37)*V(74)
  ARP(144) = V(37)
  ARP(145) = V(45)
  ARP(146) = V(45)
  ARP(147) = V(45)*V(74)
  ARP(148) = V(45)*V(71)
  ARP(149) = V(41)
  ARP(150) = V(41)*V(74)
  ARP(151) = V(41)*V(71)
  ARP(152) = V(12)
  ARP(153) = V(39)*V(74)
  ARP(154) = V(39)*V(71)
  ARP(155) = V(34)*V(74)
  ARP(156) = V(34)*V(71)
  ARP(157) = V(36)*V(71)
  ARP(158) = V(38)*V(74)
  ARP(159) = V(38)
  ARP(160) = V(38)*V(71)
  ARP(161) = V(50)*V(74)
  ARP(162) = V(50)*V(62)
  ARP(163) = V(50)*V(71)
  ARP(164) = V(50)*V(58)
  ARP(165) = V(50)
  ARP(166) = V(54)*V(74)
  ARP(167) = V(54)*V(62)
  ARP(168) = V(54)*V(58)
  ARP(169) = V(54)
  ARP(170) = V(52)*V(74)
  ARP(171) = V(52)*V(62)
  ARP(172) = V(52)*V(71)
  ARP(173) = V(52)
  ARP(174) = V(61)*V(74)
  ARP(175) = V(61)
  ARP(176) = V(57)*V(74)
  ARP(177) = V(57)
  ARP(178) = V(35)*V(74)
  ARP(179) = V(35)*V(62)
  ARP(180) = V(32)*V(74)
  ARP(181) = V(32)
  ARP(182) = V(33)*V(74)
  ARP(183) = V(33)
  ARP(184) = V(74)*F(5)
  ARP(185) = V(44)*V(74)
  ARP(186) = V(44)*V(62)
  ARP(187) = V(44)*V(71)
  ARP(188) = V(44)*V(58)
  ARP(189) = V(47)*V(74)
  ARP(190) = V(47)*V(62)
  ARP(191) = V(47)*V(71)
  ARP(192) = V(47)*V(58)
  ARP(193) = V(49)*V(74)
  ARP(194) = V(49)*V(62)
  ARP(195) = V(49)*V(71)
  ARP(196) = V(49)*V(58)
  ARP(197) = V(11)*V(74)
  ARP(198) = V(20)*V(74)
  ARP(199) = V(21)*V(74)
  ARP(200) = V(30)*V(74)
  ARP(201) = V(23)*V(74)
  ARP(202) = V(31)*V(74)
  ARP(203) = V(24)*V(74)
  ARP(204) = V(51)*V(74)
  ARP(205) = V(51)*V(62)
  ARP(206) = V(51)*V(71)
  ARP(207) = V(51)*V(58)
  ARP(208) = V(53)*V(74)
  ARP(209) = V(53)*V(62)
  ARP(210) = V(53)*V(71)
  ARP(211) = V(53)*V(58)
      
END SUBROUTINE ReactantProd

! End of ReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! JacReactantProd - Jacobian of Reactant Products vector
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      JVRP      - d ARP(1:NREACT)/d VAR (1:NVAR)
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE JacReactantProd ( V, F, JVRP )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! JVRP - d ARP(1:NREACT)/d VAR (1:NVAR)
  REAL(kind=dp) :: JVRP(NJVRP)


! Reactant Products in each equation are useful in the
!    stoichiometric formulation of mass action law
! Below we compute the Jacobian of the Reactant Products vector
!    w.r.t. variable species: d ARP(1:NREACT) / d Var(1:NVAR)

! JVRP(1) = dARP(1)/dV(70)
  JVRP(1) = 1
! JVRP(2) = dARP(2)/dV(58)
  JVRP(2) = F(1)*F(2)
! JVRP(3) = dARP(3)/dV(58)
  JVRP(3) = V(62)
! JVRP(4) = dARP(3)/dV(62)
  JVRP(4) = V(58)
! JVRP(5) = dARP(4)/dV(58)
  JVRP(5) = V(69)*F(1)
! JVRP(6) = dARP(4)/dV(69)
  JVRP(6) = V(58)*F(1)
! JVRP(7) = dARP(5)/dV(58)
  JVRP(7) = V(70)
! JVRP(8) = dARP(5)/dV(70)
  JVRP(8) = V(58)
! JVRP(9) = dARP(6)/dV(58)
  JVRP(9) = V(70)
! JVRP(10) = dARP(6)/dV(70)
  JVRP(10) = V(58)
! JVRP(11) = dARP(7)/dV(62)
  JVRP(11) = V(69)
! JVRP(12) = dARP(7)/dV(69)
  JVRP(12) = V(62)
! JVRP(13) = dARP(8)/dV(62)
  JVRP(13) = V(70)
! JVRP(14) = dARP(8)/dV(70)
  JVRP(14) = V(62)
! JVRP(15) = dARP(9)/dV(69)
  JVRP(15) = V(71)
! JVRP(16) = dARP(9)/dV(71)
  JVRP(16) = V(69)
! JVRP(17) = dARP(10)/dV(69)
  JVRP(17) = 2*V(69)*F(2)
! JVRP(18) = dARP(11)/dV(70)
  JVRP(18) = V(71)
! JVRP(19) = dARP(11)/dV(71)
  JVRP(19) = V(70)
! JVRP(20) = dARP(12)/dV(18)
  JVRP(20) = 1
! JVRP(21) = dARP(13)/dV(18)
  JVRP(21) = F(3)
! JVRP(22) = dARP(14)/dV(70)
  JVRP(22) = V(71)
! JVRP(23) = dARP(14)/dV(71)
  JVRP(23) = V(70)
! JVRP(24) = dARP(15)/dV(71)
  JVRP(24) = 1
! JVRP(25) = dARP(16)/dV(71)
  JVRP(25) = 1
! JVRP(26) = dARP(17)/dV(62)
  JVRP(26) = 1
! JVRP(27) = dARP(18)/dV(62)
  JVRP(27) = 1
! JVRP(28) = dARP(19)/dV(10)
  JVRP(28) = F(3)
! JVRP(29) = dARP(20)/dV(10)
  JVRP(29) = F(1)
! JVRP(30) = dARP(21)/dV(69)
  JVRP(30) = V(74)
! JVRP(31) = dARP(21)/dV(74)
  JVRP(31) = V(69)
! JVRP(32) = dARP(22)/dV(19)
  JVRP(32) = 1
! JVRP(33) = dARP(23)/dV(19)
  JVRP(33) = 1
! JVRP(34) = dARP(24)/dV(19)
  JVRP(34) = V(74)
! JVRP(35) = dARP(24)/dV(74)
  JVRP(35) = V(19)
! JVRP(36) = dARP(25)/dV(70)
  JVRP(36) = V(74)
! JVRP(37) = dARP(25)/dV(74)
  JVRP(37) = V(70)
! JVRP(38) = dARP(26)/dV(71)
  JVRP(38) = V(74)
! JVRP(39) = dARP(26)/dV(74)
  JVRP(39) = V(71)
! JVRP(40) = dARP(27)/dV(43)
  JVRP(40) = V(74)
! JVRP(41) = dARP(27)/dV(74)
  JVRP(41) = V(43)
! JVRP(42) = dARP(28)/dV(43)
  JVRP(42) = 1
! JVRP(43) = dARP(29)/dV(40)
  JVRP(43) = V(74)
! JVRP(44) = dARP(29)/dV(74)
  JVRP(44) = V(40)
! JVRP(45) = dARP(30)/dV(62)
  JVRP(45) = V(74)
! JVRP(46) = dARP(30)/dV(74)
  JVRP(46) = V(62)
! JVRP(47) = dARP(31)/dV(63)
  JVRP(47) = V(69)
! JVRP(48) = dARP(31)/dV(69)
  JVRP(48) = V(63)
! JVRP(49) = dARP(32)/dV(63)
  JVRP(49) = V(70)
! JVRP(50) = dARP(32)/dV(70)
  JVRP(50) = V(63)
! JVRP(51) = dARP(33)/dV(25)
  JVRP(51) = 1
! JVRP(52) = dARP(34)/dV(25)
  JVRP(52) = 1
! JVRP(53) = dARP(35)/dV(25)
  JVRP(53) = V(74)
! JVRP(54) = dARP(35)/dV(74)
  JVRP(54) = V(25)
! JVRP(55) = dARP(36)/dV(62)
  JVRP(55) = V(63)
! JVRP(56) = dARP(36)/dV(63)
  JVRP(56) = V(62)
! JVRP(57) = dARP(37)/dV(63)
  JVRP(57) = 2*V(63)
! JVRP(58) = dARP(38)/dV(63)
  JVRP(58) = 2*V(63)*F(3)
! JVRP(59) = dARP(39)/dV(63)
  JVRP(59) = V(71)
! JVRP(60) = dARP(39)/dV(71)
  JVRP(60) = V(63)
! JVRP(61) = dARP(40)/dV(71)
  JVRP(61) = 2*V(71)
! JVRP(62) = dARP(41)/dV(17)
  JVRP(62) = 1
! JVRP(63) = dARP(42)/dV(17)
  JVRP(63) = V(74)
! JVRP(64) = dARP(42)/dV(74)
  JVRP(64) = V(17)
! JVRP(65) = dARP(43)/dV(63)
  JVRP(65) = V(74)
! JVRP(66) = dARP(43)/dV(74)
  JVRP(66) = V(63)
! JVRP(67) = dARP(44)/dV(9)
  JVRP(67) = V(74)
! JVRP(68) = dARP(44)/dV(74)
  JVRP(68) = V(9)
! JVRP(69) = dARP(45)/dV(74)
  JVRP(69) = F(4)
! JVRP(70) = dARP(46)/dV(66)
  JVRP(70) = V(69)
! JVRP(71) = dARP(46)/dV(69)
  JVRP(71) = V(66)
! JVRP(72) = dARP(47)/dV(63)
  JVRP(72) = V(66)
! JVRP(73) = dARP(47)/dV(66)
  JVRP(73) = V(63)
! JVRP(74) = dARP(48)/dV(66)
  JVRP(74) = V(71)
! JVRP(75) = dARP(48)/dV(71)
  JVRP(75) = V(66)
! JVRP(76) = dARP(49)/dV(66)
  JVRP(76) = 2*V(66)
! JVRP(77) = dARP(50)/dV(66)
  JVRP(77) = 2*V(66)
! JVRP(78) = dARP(51)/dV(68)
  JVRP(78) = V(69)
! JVRP(79) = dARP(51)/dV(69)
  JVRP(79) = V(68)
! JVRP(80) = dARP(52)/dV(63)
  JVRP(80) = V(68)
! JVRP(81) = dARP(52)/dV(68)
  JVRP(81) = V(63)
! JVRP(82) = dARP(53)/dV(68)
  JVRP(82) = V(71)
! JVRP(83) = dARP(53)/dV(71)
  JVRP(83) = V(68)
! JVRP(84) = dARP(54)/dV(66)
  JVRP(84) = V(68)
! JVRP(85) = dARP(54)/dV(68)
  JVRP(85) = V(66)
! JVRP(86) = dARP(55)/dV(68)
  JVRP(86) = 2*V(68)
! JVRP(87) = dARP(56)/dV(48)
  JVRP(87) = V(69)
! JVRP(88) = dARP(56)/dV(69)
  JVRP(88) = V(48)
! JVRP(89) = dARP(57)/dV(48)
  JVRP(89) = V(63)
! JVRP(90) = dARP(57)/dV(63)
  JVRP(90) = V(48)
! JVRP(91) = dARP(58)/dV(48)
  JVRP(91) = V(71)
! JVRP(92) = dARP(58)/dV(71)
  JVRP(92) = V(48)
! JVRP(93) = dARP(59)/dV(48)
  JVRP(93) = V(66)
! JVRP(94) = dARP(59)/dV(66)
  JVRP(94) = V(48)
! JVRP(95) = dARP(60)/dV(48)
  JVRP(95) = V(68)
! JVRP(96) = dARP(60)/dV(68)
  JVRP(96) = V(48)
! JVRP(97) = dARP(61)/dV(48)
  JVRP(97) = 2*V(48)
! JVRP(98) = dARP(62)/dV(64)
  JVRP(98) = V(69)
! JVRP(99) = dARP(62)/dV(69)
  JVRP(99) = V(64)
! JVRP(100) = dARP(63)/dV(63)
  JVRP(100) = V(64)
! JVRP(101) = dARP(63)/dV(64)
  JVRP(101) = V(63)
! JVRP(102) = dARP(64)/dV(64)
  JVRP(102) = V(66)
! JVRP(103) = dARP(64)/dV(66)
  JVRP(103) = V(64)
! JVRP(104) = dARP(65)/dV(64)
  JVRP(104) = V(71)
! JVRP(105) = dARP(65)/dV(71)
  JVRP(105) = V(64)
! JVRP(106) = dARP(66)/dV(64)
  JVRP(106) = V(68)
! JVRP(107) = dARP(66)/dV(68)
  JVRP(107) = V(64)
! JVRP(108) = dARP(67)/dV(48)
  JVRP(108) = V(64)
! JVRP(109) = dARP(67)/dV(64)
  JVRP(109) = V(48)
! JVRP(110) = dARP(68)/dV(64)
  JVRP(110) = 2*V(64)
! JVRP(111) = dARP(69)/dV(70)
  JVRP(111) = V(72)
! JVRP(112) = dARP(69)/dV(72)
  JVRP(112) = V(70)
! JVRP(113) = dARP(70)/dV(13)
  JVRP(113) = 1
! JVRP(114) = dARP(71)/dV(69)
  JVRP(114) = V(72)
! JVRP(115) = dARP(71)/dV(72)
  JVRP(115) = V(69)
! JVRP(116) = dARP(72)/dV(63)
  JVRP(116) = V(72)
! JVRP(117) = dARP(72)/dV(72)
  JVRP(117) = V(63)
! JVRP(118) = dARP(73)/dV(71)
  JVRP(118) = V(72)
! JVRP(119) = dARP(73)/dV(72)
  JVRP(119) = V(71)
! JVRP(120) = dARP(74)/dV(66)
  JVRP(120) = V(72)
! JVRP(121) = dARP(74)/dV(72)
  JVRP(121) = V(66)
! JVRP(122) = dARP(75)/dV(68)
  JVRP(122) = V(72)
! JVRP(123) = dARP(75)/dV(72)
  JVRP(123) = V(68)
! JVRP(124) = dARP(76)/dV(48)
  JVRP(124) = V(72)
! JVRP(125) = dARP(76)/dV(72)
  JVRP(125) = V(48)
! JVRP(126) = dARP(77)/dV(64)
  JVRP(126) = V(72)
! JVRP(127) = dARP(77)/dV(72)
  JVRP(127) = V(64)
! JVRP(128) = dARP(78)/dV(72)
  JVRP(128) = 2*V(72)
! JVRP(129) = dARP(79)/dV(70)
  JVRP(129) = V(73)
! JVRP(130) = dARP(79)/dV(73)
  JVRP(130) = V(70)
! JVRP(131) = dARP(80)/dV(14)
  JVRP(131) = 1
! JVRP(132) = dARP(81)/dV(69)
  JVRP(132) = V(73)
! JVRP(133) = dARP(81)/dV(73)
  JVRP(133) = V(69)
! JVRP(134) = dARP(82)/dV(63)
  JVRP(134) = V(73)
! JVRP(135) = dARP(82)/dV(73)
  JVRP(135) = V(63)
! JVRP(136) = dARP(83)/dV(71)
  JVRP(136) = V(73)
! JVRP(137) = dARP(83)/dV(73)
  JVRP(137) = V(71)
! JVRP(138) = dARP(84)/dV(66)
  JVRP(138) = V(73)
! JVRP(139) = dARP(84)/dV(73)
  JVRP(139) = V(66)
! JVRP(140) = dARP(85)/dV(68)
  JVRP(140) = V(73)
! JVRP(141) = dARP(85)/dV(73)
  JVRP(141) = V(68)
! JVRP(142) = dARP(86)/dV(48)
  JVRP(142) = V(73)
! JVRP(143) = dARP(86)/dV(73)
  JVRP(143) = V(48)
! JVRP(144) = dARP(87)/dV(64)
  JVRP(144) = V(73)
! JVRP(145) = dARP(87)/dV(73)
  JVRP(145) = V(64)
! JVRP(146) = dARP(88)/dV(72)
  JVRP(146) = V(73)
! JVRP(147) = dARP(88)/dV(73)
  JVRP(147) = V(72)
! JVRP(148) = dARP(89)/dV(73)
  JVRP(148) = 2*V(73)
! JVRP(149) = dARP(90)/dV(67)
  JVRP(149) = V(70)
! JVRP(150) = dARP(90)/dV(70)
  JVRP(150) = V(67)
! JVRP(151) = dARP(91)/dV(15)
  JVRP(151) = 1
! JVRP(152) = dARP(92)/dV(67)
  JVRP(152) = V(69)
! JVRP(153) = dARP(92)/dV(69)
  JVRP(153) = V(67)
! JVRP(154) = dARP(93)/dV(63)
  JVRP(154) = V(67)
! JVRP(155) = dARP(93)/dV(67)
  JVRP(155) = V(63)
! JVRP(156) = dARP(94)/dV(67)
  JVRP(156) = V(71)
! JVRP(157) = dARP(94)/dV(71)
  JVRP(157) = V(67)
! JVRP(158) = dARP(95)/dV(66)
  JVRP(158) = V(67)
! JVRP(159) = dARP(95)/dV(67)
  JVRP(159) = V(66)
! JVRP(160) = dARP(96)/dV(67)
  JVRP(160) = V(68)
! JVRP(161) = dARP(96)/dV(68)
  JVRP(161) = V(67)
! JVRP(162) = dARP(97)/dV(48)
  JVRP(162) = V(67)
! JVRP(163) = dARP(97)/dV(67)
  JVRP(163) = V(48)
! JVRP(164) = dARP(98)/dV(64)
  JVRP(164) = V(67)
! JVRP(165) = dARP(98)/dV(67)
  JVRP(165) = V(64)
! JVRP(166) = dARP(99)/dV(67)
  JVRP(166) = V(72)
! JVRP(167) = dARP(99)/dV(72)
  JVRP(167) = V(67)
! JVRP(168) = dARP(100)/dV(67)
  JVRP(168) = V(73)
! JVRP(169) = dARP(100)/dV(73)
  JVRP(169) = V(67)
! JVRP(170) = dARP(101)/dV(67)
  JVRP(170) = 2*V(67)
! JVRP(171) = dARP(102)/dV(65)
  JVRP(171) = V(70)
! JVRP(172) = dARP(102)/dV(70)
  JVRP(172) = V(65)
! JVRP(173) = dARP(103)/dV(16)
  JVRP(173) = 1
! JVRP(174) = dARP(104)/dV(65)
  JVRP(174) = V(69)
! JVRP(175) = dARP(104)/dV(69)
  JVRP(175) = V(65)
! JVRP(176) = dARP(105)/dV(63)
  JVRP(176) = V(65)
! JVRP(177) = dARP(105)/dV(65)
  JVRP(177) = V(63)
! JVRP(178) = dARP(106)/dV(65)
  JVRP(178) = V(71)
! JVRP(179) = dARP(106)/dV(71)
  JVRP(179) = V(65)
! JVRP(180) = dARP(107)/dV(65)
  JVRP(180) = V(66)
! JVRP(181) = dARP(107)/dV(66)
  JVRP(181) = V(65)
! JVRP(182) = dARP(108)/dV(65)
  JVRP(182) = V(68)
! JVRP(183) = dARP(108)/dV(68)
  JVRP(183) = V(65)
! JVRP(184) = dARP(109)/dV(48)
  JVRP(184) = V(65)
! JVRP(185) = dARP(109)/dV(65)
  JVRP(185) = V(48)
! JVRP(186) = dARP(110)/dV(64)
  JVRP(186) = V(65)
! JVRP(187) = dARP(110)/dV(65)
  JVRP(187) = V(64)
! JVRP(188) = dARP(111)/dV(65)
  JVRP(188) = V(72)
! JVRP(189) = dARP(111)/dV(72)
  JVRP(189) = V(65)
! JVRP(190) = dARP(112)/dV(65)
  JVRP(190) = V(73)
! JVRP(191) = dARP(112)/dV(73)
  JVRP(191) = V(65)
! JVRP(192) = dARP(113)/dV(65)
  JVRP(192) = V(67)
! JVRP(193) = dARP(113)/dV(67)
  JVRP(193) = V(65)
! JVRP(194) = dARP(114)/dV(65)
  JVRP(194) = 2*V(65)
! JVRP(195) = dARP(115)/dV(22)
  JVRP(195) = V(70)
! JVRP(196) = dARP(115)/dV(70)
  JVRP(196) = V(22)
! JVRP(197) = dARP(116)/dV(22)
  JVRP(197) = 1
! JVRP(198) = dARP(117)/dV(46)
  JVRP(198) = V(70)
! JVRP(199) = dARP(117)/dV(70)
  JVRP(199) = V(46)
! JVRP(200) = dARP(118)/dV(46)
  JVRP(200) = V(63)
! JVRP(201) = dARP(118)/dV(63)
  JVRP(201) = V(46)
! JVRP(202) = dARP(119)/dV(46)
  JVRP(202) = 1
! JVRP(203) = dARP(120)/dV(28)
  JVRP(203) = V(70)
! JVRP(204) = dARP(120)/dV(70)
  JVRP(204) = V(28)
! JVRP(205) = dARP(121)/dV(28)
  JVRP(205) = V(63)
! JVRP(206) = dARP(121)/dV(63)
  JVRP(206) = V(28)
! JVRP(207) = dARP(122)/dV(28)
  JVRP(207) = 1
! JVRP(208) = dARP(123)/dV(56)
  JVRP(208) = 1
! JVRP(209) = dARP(124)/dV(56)
  JVRP(209) = 1
! JVRP(210) = dARP(125)/dV(56)
  JVRP(210) = V(74)
! JVRP(211) = dARP(125)/dV(74)
  JVRP(211) = V(56)
! JVRP(212) = dARP(126)/dV(56)
  JVRP(212) = V(63)
! JVRP(213) = dARP(126)/dV(63)
  JVRP(213) = V(56)
! JVRP(214) = dARP(127)/dV(27)
  JVRP(214) = 1
! JVRP(215) = dARP(128)/dV(27)
  JVRP(215) = V(69)
! JVRP(216) = dARP(128)/dV(69)
  JVRP(216) = V(27)
! JVRP(217) = dARP(129)/dV(56)
  JVRP(217) = V(71)
! JVRP(218) = dARP(129)/dV(71)
  JVRP(218) = V(56)
! JVRP(219) = dARP(130)/dV(55)
  JVRP(219) = V(74)
! JVRP(220) = dARP(130)/dV(74)
  JVRP(220) = V(55)
! JVRP(221) = dARP(131)/dV(55)
  JVRP(221) = 1
! JVRP(222) = dARP(132)/dV(55)
  JVRP(222) = V(71)
! JVRP(223) = dARP(132)/dV(71)
  JVRP(223) = V(55)
! JVRP(224) = dARP(133)/dV(59)
  JVRP(224) = V(74)
! JVRP(225) = dARP(133)/dV(74)
  JVRP(225) = V(59)
! JVRP(226) = dARP(134)/dV(59)
  JVRP(226) = 1
! JVRP(227) = dARP(135)/dV(59)
  JVRP(227) = V(71)
! JVRP(228) = dARP(135)/dV(71)
  JVRP(228) = V(59)
! JVRP(229) = dARP(136)/dV(42)
  JVRP(229) = V(74)
! JVRP(230) = dARP(136)/dV(74)
  JVRP(230) = V(42)
! JVRP(231) = dARP(137)/dV(42)
  JVRP(231) = 1
! JVRP(232) = dARP(138)/dV(60)
  JVRP(232) = V(74)
! JVRP(233) = dARP(138)/dV(74)
  JVRP(233) = V(60)
! JVRP(234) = dARP(139)/dV(60)
  JVRP(234) = 1
! JVRP(235) = dARP(140)/dV(29)
  JVRP(235) = V(74)
! JVRP(236) = dARP(140)/dV(74)
  JVRP(236) = V(29)
! JVRP(237) = dARP(141)/dV(26)
  JVRP(237) = V(74)
! JVRP(238) = dARP(141)/dV(74)
  JVRP(238) = V(26)
! JVRP(239) = dARP(142)/dV(26)
  JVRP(239) = 1
! JVRP(240) = dARP(143)/dV(37)
  JVRP(240) = V(74)
! JVRP(241) = dARP(143)/dV(74)
  JVRP(241) = V(37)
! JVRP(242) = dARP(144)/dV(37)
  JVRP(242) = 1
! JVRP(243) = dARP(145)/dV(45)
  JVRP(243) = 1
! JVRP(244) = dARP(146)/dV(45)
  JVRP(244) = 1
! JVRP(245) = dARP(147)/dV(45)
  JVRP(245) = V(74)
! JVRP(246) = dARP(147)/dV(74)
  JVRP(246) = V(45)
! JVRP(247) = dARP(148)/dV(45)
  JVRP(247) = V(71)
! JVRP(248) = dARP(148)/dV(71)
  JVRP(248) = V(45)
! JVRP(249) = dARP(149)/dV(41)
  JVRP(249) = 1
! JVRP(250) = dARP(150)/dV(41)
  JVRP(250) = V(74)
! JVRP(251) = dARP(150)/dV(74)
  JVRP(251) = V(41)
! JVRP(252) = dARP(151)/dV(41)
  JVRP(252) = V(71)
! JVRP(253) = dARP(151)/dV(71)
  JVRP(253) = V(41)
! JVRP(254) = dARP(152)/dV(12)
  JVRP(254) = 1
! JVRP(255) = dARP(153)/dV(39)
  JVRP(255) = V(74)
! JVRP(256) = dARP(153)/dV(74)
  JVRP(256) = V(39)
! JVRP(257) = dARP(154)/dV(39)
  JVRP(257) = V(71)
! JVRP(258) = dARP(154)/dV(71)
  JVRP(258) = V(39)
! JVRP(259) = dARP(155)/dV(34)
  JVRP(259) = V(74)
! JVRP(260) = dARP(155)/dV(74)
  JVRP(260) = V(34)
! JVRP(261) = dARP(156)/dV(34)
  JVRP(261) = V(71)
! JVRP(262) = dARP(156)/dV(71)
  JVRP(262) = V(34)
! JVRP(263) = dARP(157)/dV(36)
  JVRP(263) = V(71)
! JVRP(264) = dARP(157)/dV(71)
  JVRP(264) = V(36)
! JVRP(265) = dARP(158)/dV(38)
  JVRP(265) = V(74)
! JVRP(266) = dARP(158)/dV(74)
  JVRP(266) = V(38)
! JVRP(267) = dARP(159)/dV(38)
  JVRP(267) = 1
! JVRP(268) = dARP(160)/dV(38)
  JVRP(268) = V(71)
! JVRP(269) = dARP(160)/dV(71)
  JVRP(269) = V(38)
! JVRP(270) = dARP(161)/dV(50)
  JVRP(270) = V(74)
! JVRP(271) = dARP(161)/dV(74)
  JVRP(271) = V(50)
! JVRP(272) = dARP(162)/dV(50)
  JVRP(272) = V(62)
! JVRP(273) = dARP(162)/dV(62)
  JVRP(273) = V(50)
! JVRP(274) = dARP(163)/dV(50)
  JVRP(274) = V(71)
! JVRP(275) = dARP(163)/dV(71)
  JVRP(275) = V(50)
! JVRP(276) = dARP(164)/dV(50)
  JVRP(276) = V(58)
! JVRP(277) = dARP(164)/dV(58)
  JVRP(277) = V(50)
! JVRP(278) = dARP(165)/dV(50)
  JVRP(278) = 1
! JVRP(279) = dARP(166)/dV(54)
  JVRP(279) = V(74)
! JVRP(280) = dARP(166)/dV(74)
  JVRP(280) = V(54)
! JVRP(281) = dARP(167)/dV(54)
  JVRP(281) = V(62)
! JVRP(282) = dARP(167)/dV(62)
  JVRP(282) = V(54)
! JVRP(283) = dARP(168)/dV(54)
  JVRP(283) = V(58)
! JVRP(284) = dARP(168)/dV(58)
  JVRP(284) = V(54)
! JVRP(285) = dARP(169)/dV(54)
  JVRP(285) = 1
! JVRP(286) = dARP(170)/dV(52)
  JVRP(286) = V(74)
! JVRP(287) = dARP(170)/dV(74)
  JVRP(287) = V(52)
! JVRP(288) = dARP(171)/dV(52)
  JVRP(288) = V(62)
! JVRP(289) = dARP(171)/dV(62)
  JVRP(289) = V(52)
! JVRP(290) = dARP(172)/dV(52)
  JVRP(290) = V(71)
! JVRP(291) = dARP(172)/dV(71)
  JVRP(291) = V(52)
! JVRP(292) = dARP(173)/dV(52)
  JVRP(292) = 1
! JVRP(293) = dARP(174)/dV(61)
  JVRP(293) = V(74)
! JVRP(294) = dARP(174)/dV(74)
  JVRP(294) = V(61)
! JVRP(295) = dARP(175)/dV(61)
  JVRP(295) = 1
! JVRP(296) = dARP(176)/dV(57)
  JVRP(296) = V(74)
! JVRP(297) = dARP(176)/dV(74)
  JVRP(297) = V(57)
! JVRP(298) = dARP(177)/dV(57)
  JVRP(298) = 1
! JVRP(299) = dARP(178)/dV(35)
  JVRP(299) = V(74)
! JVRP(300) = dARP(178)/dV(74)
  JVRP(300) = V(35)
! JVRP(301) = dARP(179)/dV(35)
  JVRP(301) = V(62)
! JVRP(302) = dARP(179)/dV(62)
  JVRP(302) = V(35)
! JVRP(303) = dARP(180)/dV(32)
  JVRP(303) = V(74)
! JVRP(304) = dARP(180)/dV(74)
  JVRP(304) = V(32)
! JVRP(305) = dARP(181)/dV(32)
  JVRP(305) = 1
! JVRP(306) = dARP(182)/dV(33)
  JVRP(306) = V(74)
! JVRP(307) = dARP(182)/dV(74)
  JVRP(307) = V(33)
! JVRP(308) = dARP(183)/dV(33)
  JVRP(308) = 1
! JVRP(309) = dARP(184)/dV(74)
  JVRP(309) = F(5)
! JVRP(310) = dARP(185)/dV(44)
  JVRP(310) = V(74)
! JVRP(311) = dARP(185)/dV(74)
  JVRP(311) = V(44)
! JVRP(312) = dARP(186)/dV(44)
  JVRP(312) = V(62)
! JVRP(313) = dARP(186)/dV(62)
  JVRP(313) = V(44)
! JVRP(314) = dARP(187)/dV(44)
  JVRP(314) = V(71)
! JVRP(315) = dARP(187)/dV(71)
  JVRP(315) = V(44)
! JVRP(316) = dARP(188)/dV(44)
  JVRP(316) = V(58)
! JVRP(317) = dARP(188)/dV(58)
  JVRP(317) = V(44)
! JVRP(318) = dARP(189)/dV(47)
  JVRP(318) = V(74)
! JVRP(319) = dARP(189)/dV(74)
  JVRP(319) = V(47)
! JVRP(320) = dARP(190)/dV(47)
  JVRP(320) = V(62)
! JVRP(321) = dARP(190)/dV(62)
  JVRP(321) = V(47)
! JVRP(322) = dARP(191)/dV(47)
  JVRP(322) = V(71)
! JVRP(323) = dARP(191)/dV(71)
  JVRP(323) = V(47)
! JVRP(324) = dARP(192)/dV(47)
  JVRP(324) = V(58)
! JVRP(325) = dARP(192)/dV(58)
  JVRP(325) = V(47)
! JVRP(326) = dARP(193)/dV(49)
  JVRP(326) = V(74)
! JVRP(327) = dARP(193)/dV(74)
  JVRP(327) = V(49)
! JVRP(328) = dARP(194)/dV(49)
  JVRP(328) = V(62)
! JVRP(329) = dARP(194)/dV(62)
  JVRP(329) = V(49)
! JVRP(330) = dARP(195)/dV(49)
  JVRP(330) = V(71)
! JVRP(331) = dARP(195)/dV(71)
  JVRP(331) = V(49)
! JVRP(332) = dARP(196)/dV(49)
  JVRP(332) = V(58)
! JVRP(333) = dARP(196)/dV(58)
  JVRP(333) = V(49)
! JVRP(334) = dARP(197)/dV(11)
  JVRP(334) = V(74)
! JVRP(335) = dARP(197)/dV(74)
  JVRP(335) = V(11)
! JVRP(336) = dARP(198)/dV(20)
  JVRP(336) = V(74)
! JVRP(337) = dARP(198)/dV(74)
  JVRP(337) = V(20)
! JVRP(338) = dARP(199)/dV(21)
  JVRP(338) = V(74)
! JVRP(339) = dARP(199)/dV(74)
  JVRP(339) = V(21)
! JVRP(340) = dARP(200)/dV(30)
  JVRP(340) = V(74)
! JVRP(341) = dARP(200)/dV(74)
  JVRP(341) = V(30)
! JVRP(342) = dARP(201)/dV(23)
  JVRP(342) = V(74)
! JVRP(343) = dARP(201)/dV(74)
  JVRP(343) = V(23)
! JVRP(344) = dARP(202)/dV(31)
  JVRP(344) = V(74)
! JVRP(345) = dARP(202)/dV(74)
  JVRP(345) = V(31)
! JVRP(346) = dARP(203)/dV(24)
  JVRP(346) = V(74)
! JVRP(347) = dARP(203)/dV(74)
  JVRP(347) = V(24)
! JVRP(348) = dARP(204)/dV(51)
  JVRP(348) = V(74)
! JVRP(349) = dARP(204)/dV(74)
  JVRP(349) = V(51)
! JVRP(350) = dARP(205)/dV(51)
  JVRP(350) = V(62)
! JVRP(351) = dARP(205)/dV(62)
  JVRP(351) = V(51)
! JVRP(352) = dARP(206)/dV(51)
  JVRP(352) = V(71)
! JVRP(353) = dARP(206)/dV(71)
  JVRP(353) = V(51)
! JVRP(354) = dARP(207)/dV(51)
  JVRP(354) = V(58)
! JVRP(355) = dARP(207)/dV(58)
  JVRP(355) = V(51)
! JVRP(356) = dARP(208)/dV(53)
  JVRP(356) = V(74)
! JVRP(357) = dARP(208)/dV(74)
  JVRP(357) = V(53)
! JVRP(358) = dARP(209)/dV(53)
  JVRP(358) = V(62)
! JVRP(359) = dARP(209)/dV(62)
  JVRP(359) = V(53)
! JVRP(360) = dARP(210)/dV(53)
  JVRP(360) = V(71)
! JVRP(361) = dARP(210)/dV(71)
  JVRP(361) = V(53)
! JVRP(362) = dARP(211)/dV(53)
  JVRP(362) = V(58)
! JVRP(363) = dARP(211)/dV(58)
  JVRP(363) = V(53)
      
END SUBROUTINE JacReactantProd

! End of JacReactantProd function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



! Begin Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Fun with respect to rate coefficients
! -----------------------------------------------------------------------------

      SUBROUTINE  dFun_dRcoeff( V, F, NCOEFF, JCOEFF, DFDR )
       
      USE saprc99_Parameters
      USE saprc99_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/radical/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Fun(1:NVAR) / d RCT( JCOEFF(j) )
!         for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DFDR(NVAR*NCOEFF)

! Local vector with reactant products
      REAL(kind=dp) A_RPROD(NREACT)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the reactant products of all reactions     
      CALL ReactantProd ( V, F, A_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_RPROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DFDR(i+NVAR*(j-1)) = 0.0_dp 
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  reactant product  of the JCOEFF(j)-th reaction      
!                  give the j-th column of the derivative matrix   
         aj = A_RPROD(JCOEFF(j))
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DFDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dFun_dRcoeff

! End Derivative w.r.t. Rate Coefficients


! Begin Jacobian Derivative w.r.t. Rate Coefficients

! ------------------------------------------------------------------------------
! Subroutine for the derivative of Jac with respect to rate coefficients
! Times a user vector
! -----------------------------------------------------------------------------

      SUBROUTINE  dJac_dRcoeff( V, F, U, NCOEFF, JCOEFF, DJDR )
       
      USE saprc99_Parameters
      USE saprc99_StoichiomSP
      IMPLICIT NONE 

! V - Concentrations of variable/fixed species            
      REAL(kind=dp) V(NVAR), F(NFIX)
! U - User-supplied Vector           
      REAL(kind=dp) U(NVAR)
! NCOEFF - the number of rate coefficients with respect to which we differentiate
      INTEGER NCOEFF       
! JCOEFF - a vector of integers containing the indices of reactions (rate
!          coefficients) with respect to which we differentiate
      INTEGER JCOEFF(NCOEFF)       
! DFDR  - a matrix containg derivative values; specifically, 
!         column j contains d Jac(1:NVAR) / d RCT( JCOEFF(j) ) * U
!                     for each 1 <= j <= NCOEFF
!         This matrix is stored in a column-wise linearized format
      REAL(kind=dp) DJDR(NVAR*NCOEFF)

! Local vector for Jacobian of reactant products
      REAL(kind=dp) JV_RPROD(NJVRP)
      REAL(kind=dp) aj
      INTEGER i,j,k
      
! Compute the Jacobian of all reactant products   
      CALL JacReactantProd( V, F, JV_RPROD )

! Compute the derivatives by multiplying column JCOEFF(j) of the stoichiometric matrix with A_PROD       
      DO j=1,NCOEFF
!                  Initialize the j-th column of derivative matrix to zero       
         DO i=1,NVAR
           DJDR(i+NVAR*(j-1)) = 0.0_dp
         END DO
!                  Column JCOEFF(j) in the stoichiometric matrix times the
!                  ( Gradient of reactant product of the JCOEFF(j)-th reaction X user vector )    
!                  give the j-th column of the derivative matrix   
!
!          Row JCOEFF(j) of JV_RPROD times the user vector
         aj = 0.0_dp
         DO k=CROW_JVRP(JCOEFF(j)),CROW_JVRP(JCOEFF(j)+1)-1
             aj = aj + JV_RPROD(k)*U(ICOL_JVRP(k))
         END DO
!          Column JCOEFF(j) of Stoichiom. matrix times aj         
         DO k=CCOL_STOICM(JCOEFF(j)),CCOL_STOICM(JCOEFF(j)+1)-1
           DJDR(IROW_STOICM(k)+NVAR*(j-1)) = STOICM(k)*aj
         END DO
      END DO
      
      END SUBROUTINE  dJac_dRcoeff

! End Jacobian Derivative w.r.t. Rate Coefficients


END MODULE saprc99_Stoichiom

