! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-2.2.4_gc symbolic chemistry Kinetics PreProcessor
!       (http://www.cs.vt.edu/~asandu/Software/KPP)
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2005, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian, Villanova University, USA
!        R. Sander, Max-Planck Institute for Chemistry, Mainz, Germany
! 
! File                 : saprc99_Rates.f90
! Time                 : Mon Feb 27 18:13:19 2017
! Working directory    : /home/jlinford/workspace/kppa/verify/ec_saprc99/kpp
! Equation file        : saprc99.kpp
! Output root filename : saprc99
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE saprc99_Rates

  USE saprc99_Parameters
  USE saprc99_Global
  IMPLICIT NONE

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!  Note: the default argument type for rate laws, as read from the equations file, is single precision
!        but all the internal calculations are performed in double precision
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

!~~~>  Arrhenius
   REAL(kind=dp) FUNCTION ARR( A0,B0,C0 )
      REAL A0,B0,C0      
      ARR =  DBLE(A0) * EXP(-DBLE(B0)/TEMP) * (TEMP/300.0_dp)**DBLE(C0)
   END FUNCTION ARR        

!~~~> Simplified Arrhenius, with two arguments
!~~~> Note: The argument B0 has a changed sign when compared to ARR
   REAL(kind=dp) FUNCTION ARR2( A0,B0 )
      REAL A0,B0           
      ARR2 =  DBLE(A0) * EXP( DBLE(B0)/TEMP )              
   END FUNCTION ARR2          

   REAL(kind=dp) FUNCTION EP2(A0,C0,A2,C2,A3,C3)
      REAL A0,C0,A2,C2,A3,C3
      REAL(kind=dp) K0,K2,K3            
      K0 = DBLE(A0) * EXP(-DBLE(C0)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      K3 = DBLE(A3) * EXP(-DBLE(C3)/TEMP)
      K3 = K3*CFACTOR*1.0E6_dp
      EP2 = K0 + K3/(1.0_dp+K3/K2 )
   END FUNCTION EP2

   REAL(kind=dp) FUNCTION EP3(A1,C1,A2,C2) 
      REAL A1, C1, A2, C2
      REAL(kind=dp) K1, K2      
      K1 = DBLE(A1) * EXP(-DBLE(C1)/TEMP)
      K2 = DBLE(A2) * EXP(-DBLE(C2)/TEMP)
      EP3 = K1 + K2*(1.0E6_dp*CFACTOR)
   END FUNCTION EP3 

   REAL(kind=dp) FUNCTION FALL ( A0,B0,C0,A1,B1,C1,CF)
      REAL A0,B0,C0,A1,B1,C1,CF
      REAL(kind=dp) K0, K1     
      K0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
      K1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
      K0 = K0*CFACTOR*1.0E6_dp
      K1 = K0/K1
      FALL = (K0/(1.0_dp+K1))*   &
           DBLE(CF)**(1.0_dp/(1.0_dp+(LOG10(K1))**2))
   END FUNCTION FALL

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_3rd(temp,cair,k0_300K,n,kinf_300K,m,fc)

    INTRINSIC LOG10

    REAL(kind=dp), INTENT(IN) :: temp      ! temperature [K]
    REAL(kind=dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL, INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL, INTENT(IN) :: n         ! exponent for low pressure limit
    REAL, INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL, INTENT(IN) :: m         ! exponent for high pressure limit
    REAL, INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(kind=dp) :: zt_help, k0_T, kinf_T, k_ratio

    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    k_3rd   = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))

  END FUNCTION k_3rd

  !---------------------------------------------------------------------------

  ELEMENTAL REAL(kind=dp) FUNCTION k_arr (k_298,tdep,temp)
    ! Arrhenius function

    REAL,     INTENT(IN) :: k_298 ! k at T = 298.15K
    REAL,     INTENT(IN) :: tdep  ! temperature dependence
    REAL(kind=dp), INTENT(IN) :: temp  ! temperature

    INTRINSIC EXP

    k_arr = k_298 * EXP(tdep*(1._dp/temp-3.3540E-3_dp)) ! 1/298.15=3.3540e-3

  END FUNCTION k_arr

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
      !USE saprc99_Parameters
      !USE saprc99_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


! End INLINED RCONST

  RCONST(1) = (6.69e-1*(SUN/60.0e0))
  RCONST(2) = (ARR(5.68e-34,0.0e0,-2.80e0))
  RCONST(3) = (ARR(8.00e-12,2060.0e0,0.0e0))
  RCONST(4) = (ARR(1.00e-31,0.0e0,-1.60e0))
  RCONST(5) = (ARR(6.50e-12,-120.0e0,0.0e0))
  RCONST(6) = (FALL(9.00e-32,0.0e0,-2.00e0,2.20e-11,0.0e0,0.0e0,0.80e0))
  RCONST(7) = (ARR(1.80e-12,1370.0e0,0.0e0))
  RCONST(8) = (ARR(1.40e-13,2470.0e0,0.0e0))
  RCONST(9) = (ARR(1.80e-11,-110.0e0,0.0e0))
  RCONST(10) = (ARR(3.30e-39,-530.0e0,0.0e0))
  RCONST(11) = (FALL(2.80e-30,0.0e0,-3.50e0,2.00e-12,0.0e0,0.20e0,0.45e0))
  RCONST(12) = (FALL(1.e-3,11000.0e0,-3.5e0,9.7e+14,11080.0e0,0.1e0,0.45e0))
  RCONST(13) = ((2.60e-22))
  RCONST(14) = (ARR(4.50e-14,1260.0e0,0.0e0))
  RCONST(15) = (1.59e0*(SUN/60.0e0))
  RCONST(16) = (1.50e+1*(SUN/60.0e0))
  RCONST(17) = (3.76e-2*(SUN/60.0e0))
  RCONST(18) = (4.19e-3*(SUN/60.0e0))
  RCONST(19) = ((2.20e-10))
  RCONST(20) = (ARR(2.09e-11,-95.0e0,0.0e0))
  RCONST(21) = (FALL(7.00e-31,0.0e0,-2.60e0,3.60e-11,0.0e0,-0.10e0,0.60e0))
  RCONST(22) = (1.27e-1*(SUN/60.0e0))
  RCONST(23) = (1.60e-2*(SUN/60.0e0))
  RCONST(24) = (ARR(2.70e-12,-260.0e0,0.0e0))
  RCONST(25) = (FALL(2.43e-30,0.0e0,-3.10e0,1.67e-11,0.0e0,-2.10e0,0.60e0))
  RCONST(26) = ((2.00e-11))
  RCONST(27) = (EP2(7.20e-15,-785.0e0,4.10e-16,-1440.0e0,1.90e-33,-725.0e0))
  RCONST(28) = (5.40e-5*(SUN/60.0e0))
  RCONST(29) = (EP3(1.30e-13,0.0e0,3.19e-33,0.0e0))
  RCONST(30) = (ARR(1.90e-12,1000.0e0,0.0e0))
  RCONST(31) = (ARR(3.40e-12,-270.0e0,0.0e0))
  RCONST(32) = (FALL(1.80e-31,0.0,-3.20,4.70e-12,0.0e0,0.0,0.6))
  RCONST(33) = (FALL(4.10e-05,10650.0,0.0,5.7e+15,11170.0,0.0,0.5))
  RCONST(34) = (4.69e-4*(SUN/60.0e0))
  RCONST(35) = (ARR(1.50e-12,-360.0e0,0.0e0))
  RCONST(36) = (ARR(1.40e-14,600.0e0,0.0e0))
  RCONST(37) = (EP3(2.20e-13,-600.0e0,1.85e-33,-980.0e0))
  RCONST(38) = (EP3(3.08e-34,-2800.0e0,2.59e-54,-3180.0e0))
  RCONST(39) = ((4.00e-12))
  RCONST(40) = (ARR(8.50e-13,2450.0e0,0.0e0))
  RCONST(41) = (5.64e-4*(SUN/60.0e0))
  RCONST(42) = (ARR(2.90e-12,160.0e0,0.0e0))
  RCONST(43) = (ARR(4.80e-11,-250.0e0,0.0e0))
  RCONST(44) = (FALL(4.00e-31,0.0e0,-3.30e0,2.00e-12,0.0e0,0.0e0,0.45e0))
  RCONST(45) = (ARR(7.70e-12,2100.0e0,0.0e0))
  RCONST(46) = (ARR(2.80e-12,-285.0e0,0.0e0))
  RCONST(47) = (ARR(3.80e-13,-780.0e0,0.0e0))
  RCONST(48) = ((1.30e-12))
  RCONST(49) = (ARR(2.45e-14,-710.0e0,0.0e0))
  RCONST(50) = (ARR(5.90e-13,509.0e0,0.0e0))
  RCONST(51) = (ARR(2.70e-12,-360.0e0,0.0e0))
  RCONST(52) = (ARR(1.90e-13,-1300.0e0,0.0e0))
  RCONST(53) = ((2.30e-12))
  RCONST(54) = ((2.00e-13))
  RCONST(55) = ((3.50e-14))
  RCONST(56) = (ARR(2.70e-12,-360.0e0,0.0e0))
  RCONST(57) = (ARR(1.90e-13,-1300.0e0,0.0e0))
  RCONST(58) = ((2.30e-12))
  RCONST(59) = ((2.00e-13))
  RCONST(60) = ((3.50e-14))
  RCONST(61) = ((0.0e0))
  RCONST(62) = (ARR(2.70e-12,-360.0e0,0.0e0))
  RCONST(63) = (ARR(1.90e-13,-1300.0e0,0.0e0))
  RCONST(64) = ((2.00e-13))
  RCONST(65) = ((2.30e-12))
  RCONST(66) = ((3.50e-14))
  RCONST(67) = ((3.50e-14))
  RCONST(68) = ((3.50e-14))
  RCONST(69) = (FALL(2.70e-28,0.0e0,-7.10e0,1.20e-11,0.0e0,-0.90e0,0.30e0))
  RCONST(70) = (FALL(4.90e-3,12100.0e0,0.0e0,4.0e+16,13600.0e0,0.e0,0.3e0))
  RCONST(71) = (ARR(7.80e-12,-300.0e0,0.0e0))
  RCONST(72) = (ARR(4.30e-13,-1040.0e0,0.0e0))
  RCONST(73) = ((4.00e-12))
  RCONST(74) = (ARR(1.80e-12,-500.0e0,0.0e0))
  RCONST(75) = ((7.50e-12))
  RCONST(76) = ((7.50e-12))
  RCONST(77) = ((7.50e-12))
  RCONST(78) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(79) = (ARR(1.20e-11,0.0e0,-0.90e0))
  RCONST(80) = (ARR(2.00e+15,12800.0e0,0.0e0))
  RCONST(81) = (ARR(1.25e-11,-240.0e0,0.0e0))
  RCONST(82) = (ARR(4.30e-13,-1040.0e0,0.0e0))
  RCONST(83) = ((4.00e-12))
  RCONST(84) = (ARR(1.80e-12,-500.0e0,0.0e0))
  RCONST(85) = ((7.50e-12))
  RCONST(86) = ((7.50e-12))
  RCONST(87) = ((7.50e-12))
  RCONST(88) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(89) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(90) = ((1.37e-11))
  RCONST(91) = (ARR(7.90e+16,14000.0e0,0.0e0))
  RCONST(92) = (ARR(1.25e-11,-240.0e0,0.0e0))
  RCONST(93) = (ARR(4.30e-13,-1040.0e0,0.0e0))
  RCONST(94) = ((4.00e-12))
  RCONST(95) = (ARR(1.80e-12,-500.0e0,0.0e0))
  RCONST(96) = ((7.50e-12))
  RCONST(97) = ((7.50e-12))
  RCONST(98) = ((7.50e-12))
  RCONST(99) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(100) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(101) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(102) = (ARR(1.20e-11,0.0e0,-0.90e0))
  RCONST(103) = (ARR(1.60e+16,13486.0e0,0.0e0))
  RCONST(104) = (ARR(1.25e-11,-240.0e0,0.0e0))
  RCONST(105) = (ARR(4.30e-13,-1040.0e0,0.0e0))
  RCONST(106) = ((4.00e-12))
  RCONST(107) = (ARR(1.80e-12,-500.0e0,0.0e0))
  RCONST(108) = ((7.50e-12))
  RCONST(109) = ((7.50e-12))
  RCONST(110) = ((7.50e-12))
  RCONST(111) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(112) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(113) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(114) = (ARR(2.90e-12,-500.0e0,0.0e0))
  RCONST(115) = ((2.40e-11))
  RCONST(116) = (ARR(7.50e+14,8152.0e0,0.0e0))
  RCONST(117) = (ARR(2.30e-11,-150.0e0,0.0e0))
  RCONST(118) = (ARR(1.90e-13,-1300.0e0,0.0e0))
  RCONST(119) = ((1.00e-03))
  RCONST(120) = (ARR(7.50e+14,8152.0e0,0.0e0))
  RCONST(121) = (ARR(2.30e-11,-150.0e0,0.0e0))
  RCONST(122) = (ARR(1.90e-13,-1300.0e0,0.0e0))
  RCONST(123) = (2.32e-3*(SUN/60.0e0))
  RCONST(124) = (3.15e-3*(SUN/60.0e0))
  RCONST(125) = (ARR(8.60e-12,-20.0e0,0.0e0))
  RCONST(126) = (ARR(9.70e-15,-625.0e0,0.0e0))
  RCONST(127) = (ARR(2.40e+12,7000.0e0,0.0e0))
  RCONST(128) = (ARR(2.80e-12,-285.0e0,0.0e0))
  RCONST(129) = (ARR(2.00e-12,2431.0e0,0.0e0))
  RCONST(130) = (ARR(5.60e-12,-310.0e0,0.0e0))
  RCONST(131) = (4.16e-4*(SUN/60.0e0))
  RCONST(132) = (ARR(1.40e-12,1860.0e0,0.0e0))
  RCONST(133) = ((2.00e-11))
  RCONST(134) = (1.40e-3*(SUN/60.0e0))
  RCONST(135) = (ARR(1.40e-12,1771.0e0,0.0e0))
  RCONST(136) = (ARR(1.10e-12,520.0e0,0.0e0))
  RCONST(137) = (4.16e-5*(SUN/60.0e0))
  RCONST(138) = (ARR(1.30e-12,25.0e0,2.0e0))
  RCONST(139) = (9.49e-4*(1.50e-1*SUN/60.0e0))
  RCONST(140) = (ARR(3.10e-12,360.0e0,2.0e0))
  RCONST(141) = (ARR(2.90e-12,-190.0e0,0.0e0))
  RCONST(142) = (3.94e-4*(SUN/60.0e0))
  RCONST(143) = ((1.10e-11))
  RCONST(144) = (3.94e-4*(SUN/60.0e0))
  RCONST(145) = (8.93e-3*(SUN/60.0e0))
  RCONST(146) = (1.81e-1*(6.00e-3*SUN/60.0e0))
  RCONST(147) = ((1.10e-11))
  RCONST(148) = (ARR(2.80e-12,2376.0e0,0.0e0))
  RCONST(149) = (1.10e-2*(SUN/60.0e0))
! RCONST(150) = constant rate coefficient
  RCONST(151) = (ARR(1.40e-12,1895.0e0,0.0e0))
  RCONST(152) = (1.90e-2*(SUN/60.0e0))
  RCONST(153) = ((2.63e-11))
  RCONST(154) = ((3.78e-12))
  RCONST(155) = ((4.20e-11))
  RCONST(156) = ((1.37e-11))
  RCONST(157) = ((3.78e-12))
  RCONST(158) = ((1.29e-11))
  RCONST(159) = (6.22e-2*(5.00e-2*SUN/60.0e0))
  RCONST(160) = (ARR(1.40e-12,1872.0e0,0.0e0))
  RCONST(161) = (ARR(1.86e-11,-176.0e0,0.0e0))
  RCONST(162) = (ARR(1.36e-15,2114.0e0,0.0e0))
  RCONST(163) = (ARR(1.50e-12,1726.0e0,0.0e0))
  RCONST(164) = ((6.34e-12))
  RCONST(165) = (3.32e-2*(4.10e-3*SUN/60.0e0))
  RCONST(166) = (ARR(4.14e-12,-453.0e0,0.0e0))
  RCONST(167) = (ARR(7.51e-16,1520.0e0,0.0e0))
  RCONST(168) = ((4.32e-12))
  RCONST(169) = (3.32e-2*(2.10e-3*SUN/60.0e0))
  RCONST(170) = ((6.19e-11))
  RCONST(171) = ((4.18e-18))
  RCONST(172) = ((1.00e-13))
  RCONST(173) = (3.32e-2*(4.10e-3*SUN/60.0e0))
  RCONST(174) = ((1.50e-11))
  RCONST(175) = (9.49e-4*(2.00e-2*SUN/60.0e0))
  RCONST(176) = ((7.80e-12))
  RCONST(177) = (2.35e-4*(SUN/60.0e0))
  RCONST(178) = ((5.00e-11))
  RCONST(179) = ((2.00e-18))
  RCONST(180) = ((5.00e-11))
  RCONST(181) = (2.06e-1*(3.65e-1*SUN/60.0e0))
  RCONST(182) = ((5.00e-11))
  RCONST(183) = (3.32e-2*(7.28e0*SUN/60.0e0))
  RCONST(184) = (ARR(2.15e-12,1735.0e0,0.0e0))
  RCONST(185) = (ARR(1.96e-12,-438.0e0,0.0e0))
  RCONST(186) = (ARR(9.14e-15,2580.0e0,0.0e0))
  RCONST(187) = (ARR(4.39e-13,2282.0e0,2.0e0))
  RCONST(188) = (ARR(1.04e-11,792.0e0,0.0e0))
  RCONST(189) = (ARR(2.50e-11,-408.0e0,0.0e0))
  RCONST(190) = (ARR(7.86e-15,1912.0e0,0.0e0))
  RCONST(191) = (ARR(3.03e-12,448.0e0,0.0e0))
  RCONST(192) = ((3.60e-11))
  RCONST(193) = (ARR(1.83e-11,-449.0e0,0.0e0))
  RCONST(194) = (ARR(1.08e-15,821.0e0,0.0e0))
  RCONST(195) = (ARR(3.66e-12,-175.e00,0.0e0))
  RCONST(196) = ((3.27e-11))
  RCONST(197) = (ARR(1.37e-12,498.0e0,2.0e0))
  RCONST(198) = (ARR(9.87e-12,671.0e0,0.0e0))
  RCONST(199) = (ARR(1.019e-11,434.0e0,0.0e0))
  RCONST(200) = (ARR(5.946e-12,91.0e0,0.0e0))
  RCONST(201) = (ARR(1.112e-11,52.0e0,0.0e0))
  RCONST(202) = (ARR(1.81e-12,-355.0e0,0.0e0))
  RCONST(203) = ((2.640e-11))
  RCONST(204) = (ARR(7.095e-12,-451.0e0,0.0e0))
  RCONST(205) = (ARR(2.617e-15,1640.0e0,0.0e0))
  RCONST(206) = (ARR(4.453e-14,376.0e0,0.0e0))
  RCONST(207) = (ARR(1.074e-11,234.0e0,0.0e0))
  RCONST(208) = (ARR(1.743e-11,-384.0e0,0.0e0))
  RCONST(209) = (ARR(5.022e-16,461.0e0,0.0e0))
  RCONST(210) = ((7.265e-13))
  RCONST(211) = ((2.085e-11))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )


   USE saprc99_Global

  RCONST(1) = (6.69e-1*(SUN/60.0e0))
  RCONST(15) = (1.59e0*(SUN/60.0e0))
  RCONST(16) = (1.50e+1*(SUN/60.0e0))
  RCONST(17) = (3.76e-2*(SUN/60.0e0))
  RCONST(18) = (4.19e-3*(SUN/60.0e0))
  RCONST(22) = (1.27e-1*(SUN/60.0e0))
  RCONST(23) = (1.60e-2*(SUN/60.0e0))
  RCONST(28) = (5.40e-5*(SUN/60.0e0))
  RCONST(34) = (4.69e-4*(SUN/60.0e0))
  RCONST(41) = (5.64e-4*(SUN/60.0e0))
  RCONST(123) = (2.32e-3*(SUN/60.0e0))
  RCONST(124) = (3.15e-3*(SUN/60.0e0))
  RCONST(131) = (4.16e-4*(SUN/60.0e0))
  RCONST(134) = (1.40e-3*(SUN/60.0e0))
  RCONST(137) = (4.16e-5*(SUN/60.0e0))
  RCONST(139) = (9.49e-4*(1.50e-1*SUN/60.0e0))
  RCONST(142) = (3.94e-4*(SUN/60.0e0))
  RCONST(144) = (3.94e-4*(SUN/60.0e0))
  RCONST(145) = (8.93e-3*(SUN/60.0e0))
  RCONST(146) = (1.81e-1*(6.00e-3*SUN/60.0e0))
  RCONST(149) = (1.10e-2*(SUN/60.0e0))
  RCONST(152) = (1.90e-2*(SUN/60.0e0))
  RCONST(159) = (6.22e-2*(5.00e-2*SUN/60.0e0))
  RCONST(165) = (3.32e-2*(4.10e-3*SUN/60.0e0))
  RCONST(169) = (3.32e-2*(2.10e-3*SUN/60.0e0))
  RCONST(173) = (3.32e-2*(4.10e-3*SUN/60.0e0))
  RCONST(175) = (9.49e-4*(2.00e-2*SUN/60.0e0))
  RCONST(177) = (2.35e-4*(SUN/60.0e0))
  RCONST(181) = (2.06e-1*(3.65e-1*SUN/60.0e0))
  RCONST(183) = (3.32e-2*(7.28e0*SUN/60.0e0))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE saprc99_Rates

