!---------------------- BEGIN saprc99_shuffle.f90 BEGIN ----------------------
! @file saprc99_shuffle.f90                                                   
! @author jlinford                                                            
! @date 2017-02-27 17:42:42.094413                                            
! @brief Data shuffling routines                                              
!                                                                             
! Data shuffling routines                                                     
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_shuffle

  USE saprc99_parameters

  IMPLICIT NONE




  CONTAINS

!--------------------------------- user2kppa ---------------------------------
! Shuffles variable and fixed species concentrations to Kppa internal order   
!                                                                             
! @param[in]     shuf Shuffled concentrations                                 
! @param[out]    var  Variable species concentration data                     
! @param[out]    fix  Fixed species concentration data                        
!-----------------------------------------------------------------------------
  SUBROUTINE user2kppa(shuf, var, fix)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: shuf(:)
    REAL(8), INTENT(OUT) :: var(:)
    REAL(8), INTENT(OUT) :: fix(:)

    var(1:NVAR) = shuf(1:NVAR)
    fix(1:NFIX) = shuf(NVAR+1:NSPEC)
!    var(1) = shuf(11)
!    var(2) = shuf(18)
!    var(3) = shuf(20)
!    var(4) = shuf(21)
!    var(5) = shuf(53)
!    var(6) = shuf(55)
!    var(7) = shuf(56)
!    var(8) = shuf(57)
!    var(9) = shuf(10)
!    var(10) = shuf(59)
!    var(11) = shuf(36)
!    var(12) = shuf(24)
!    var(13) = shuf(49)
!    var(14) = shuf(50)
!    var(15) = shuf(51)
!    var(16) = shuf(52)
!    var(17) = shuf(2)
!    var(18) = shuf(6)
!    var(19) = shuf(7)
!    var(20) = shuf(37)
!    var(21) = shuf(38)
!    var(22) = shuf(74)
!    var(23) = shuf(40)
!    var(24) = shuf(42)
!    var(25) = shuf(9)
!    var(26) = shuf(63)
!    var(27) = shuf(68)
!    var(28) = shuf(71)
!    var(29) = shuf(19)
!    var(30) = shuf(39)
!    var(31) = shuf(41)
!    var(32) = shuf(32)
!    var(33) = shuf(33)
!    var(34) = shuf(25)
!    var(35) = shuf(31)
!    var(36) = shuf(47)
!    var(37) = shuf(64)
!    var(38) = shuf(26)
!    var(39) = shuf(48)
!    var(40) = shuf(12)
!    var(41) = shuf(23)
!    var(42) = shuf(16)
!    var(43) = shuf(8)
!    var(44) = shuf(34)
!    var(45) = shuf(22)
!    var(46) = shuf(72)
!    var(47) = shuf(35)
!    var(48) = shuf(66)
!    var(49) = shuf(45)
!    var(50) = shuf(28)
!    var(51) = shuf(43)
!    var(52) = shuf(27)
!    var(53) = shuf(44)
!    var(54) = shuf(29)
!    var(55) = shuf(14)
!    var(56) = shuf(13)
!    var(57) = shuf(46)
!    var(58) = shuf(58)
!    var(59) = shuf(15)
!    var(60) = shuf(17)
!    var(61) = shuf(30)
!    var(62) = shuf(1)
!    var(63) = shuf(61)
!    var(64) = shuf(67)
!    var(65) = shuf(73)
!    var(66) = shuf(62)
!    var(67) = shuf(70)
!    var(68) = shuf(65)
!    var(69) = shuf(3)
!    var(70) = shuf(4)
!    var(71) = shuf(5)
!    var(72) = shuf(69)
!    var(73) = shuf(54)
!    var(74) = shuf(60)
!    fix(1) = shuf(75)
!    fix(2) = shuf(76)
!    fix(3) = shuf(77)
!    fix(4) = shuf(78)
!    fix(5) = shuf(79)
  END SUBROUTINE user2kppa


!--------------------------------- kppa2user ---------------------------------
! Shuffles variable and fixed species concentrations to to user order         
!                                                                             
! @param[in]     var  Variable species concentration data                     
! @param[in]     fix  Fixed species concentration data                        
! @param[out]    shuf Shuffled concentrations                                 
!-----------------------------------------------------------------------------
  SUBROUTINE kppa2user(var, fix, shuf)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: var(:)
    REAL(8), INTENT(IN) :: fix(:)
    REAL(8), INTENT(OUT) :: shuf(:)

    shuf(1:NVAR) = var(1:NVAR)
    shuf(NVAR+1:NSPEC) = fix(1:NFIX)

!    shuf(11) = var(1)
!    shuf(18) = var(2)
!    shuf(20) = var(3)
!    shuf(21) = var(4)
!    shuf(53) = var(5)
!    shuf(55) = var(6)
!    shuf(56) = var(7)
!    shuf(57) = var(8)
!    shuf(10) = var(9)
!    shuf(59) = var(10)
!    shuf(36) = var(11)
!    shuf(24) = var(12)
!    shuf(49) = var(13)
!    shuf(50) = var(14)
!    shuf(51) = var(15)
!    shuf(52) = var(16)
!    shuf(2) = var(17)
!    shuf(6) = var(18)
!    shuf(7) = var(19)
!    shuf(37) = var(20)
!    shuf(38) = var(21)
!    shuf(74) = var(22)
!    shuf(40) = var(23)
!    shuf(42) = var(24)
!    shuf(9) = var(25)
!    shuf(63) = var(26)
!    shuf(68) = var(27)
!    shuf(71) = var(28)
!    shuf(19) = var(29)
!    shuf(39) = var(30)
!    shuf(41) = var(31)
!    shuf(32) = var(32)
!    shuf(33) = var(33)
!    shuf(25) = var(34)
!    shuf(31) = var(35)
!    shuf(47) = var(36)
!    shuf(64) = var(37)
!    shuf(26) = var(38)
!    shuf(48) = var(39)
!    shuf(12) = var(40)
!    shuf(23) = var(41)
!    shuf(16) = var(42)
!    shuf(8) = var(43)
!    shuf(34) = var(44)
!    shuf(22) = var(45)
!    shuf(72) = var(46)
!    shuf(35) = var(47)
!    shuf(66) = var(48)
!    shuf(45) = var(49)
!    shuf(28) = var(50)
!    shuf(43) = var(51)
!    shuf(27) = var(52)
!    shuf(44) = var(53)
!    shuf(29) = var(54)
!    shuf(14) = var(55)
!    shuf(13) = var(56)
!    shuf(46) = var(57)
!    shuf(58) = var(58)
!    shuf(15) = var(59)
!    shuf(17) = var(60)
!    shuf(30) = var(61)
!    shuf(1) = var(62)
!    shuf(61) = var(63)
!    shuf(67) = var(64)
!    shuf(73) = var(65)
!    shuf(62) = var(66)
!    shuf(70) = var(67)
!    shuf(65) = var(68)
!    shuf(3) = var(69)
!    shuf(4) = var(70)
!    shuf(5) = var(71)
!    shuf(69) = var(72)
!    shuf(54) = var(73)
!    shuf(60) = var(74)
!    shuf(75) = fix(1)
!    shuf(76) = fix(2)
!    shuf(77) = fix(3)
!    shuf(78) = fix(4)
!    shuf(79) = fix(5)
  END SUBROUTINE kppa2user




END MODULE saprc99_shuffle
!------------------------ END saprc99_shuffle.f90 END ------------------------
