!---------------------- BEGIN saprc99_monitor.f90 BEGIN ----------------------
! @file saprc99_monitor.f90                                                   
! @author jlinford                                                            
! @date 2017-02-27 17:42:47.209952                                            
! @brief Mechanism monitoring                                                 
!                                                                             
! Species names, equations, etc.                                              
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_monitor

  USE saprc99_parameters

  IMPLICIT NONE



!-----------------------------------------------------------------------------
! Array dimensions                                                            
!-----------------------------------------------------------------------------

  ! Number of species on the LOOKAT list 
  INTEGER, PARAMETER :: NLOOKAT = 79

  ! Number of species on the MONITOR list 
  INTEGER, PARAMETER :: NMONITOR = 79

!-----------------------------------------------------------------------------
! Species indices arrays                                                      
!-----------------------------------------------------------------------------

  ! Indices of species concentrations sent to data file 
  INTEGER, PARAMETER :: ILOOKAT(NLOOKAT) = (/ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, &
      11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, &
      29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, &
      47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, &
      65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 /)

  ! Indicies of species concentrations sent to screen 
  INTEGER, PARAMETER :: IMONITOR(NMONITOR) = (/ 1, 2, 3, 4, 5, 6, 7, 8, 9, &
      10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, &
      28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, &
      46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, &
      64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79 /)

!-----------------------------------------------------------------------------
! Mechanism information                                                       
!-----------------------------------------------------------------------------

  ! Species names 
  CHARACTER(LEN=8), PARAMETER :: SPC_NAMES(NSPEC) = (/ &
      'H2SO4   ', &
      'HCOOH   ', &
      'CCO_OH  ', &
      'RCO_OH  ', &
      'CCO_OOH ', &
      'RCO_OOH ', &
      'XN      ', &
      'XC      ', &
      'SO2     ', &
      'O1D     ', &
      'ALK1    ', &
      'BACL    ', &
      'PAN     ', &
      'PAN2    ', &
      'PBZN    ', &
      'MA_PAN  ', &
      'H2O2    ', &
      'N2O5    ', &
      'HONO    ', &
      'ALK2    ', &
      'ALK3    ', &
      'TBU_O   ', &
      'ALK5    ', &
      'ARO2    ', &
      'HNO4    ', &
      'COOH    ', &
      'HOCOO   ', &
      'BZNO2_O ', &
      'MEOH    ', &
      'ALK4    ', &
      'ARO1    ', &
      'DCB2    ', &
      'DCB3    ', &
      'CRES    ', &
      'DCB1    ', &
      'NPHE    ', &
      'ROOH    ', &
      'BALD    ', &
      'PHEN    ', &
      'CO      ', &
      'MGLY    ', &
      'ACET    ', &
      'HNO3    ', &
      'ETHENE  ', &
      'GLY     ', &
      'BZ_O    ', &
      'ISOPRENE', &
      'R2O2    ', &
      'TERP    ', &
      'METHACRO', &
      'OLE1    ', &
      'ISOPROD ', &
      'OLE2    ', &
      'MVK     ', &
      'CCHO    ', &
      'HCHO    ', &
      'RNO3    ', &
      'O3P     ', &
      'RCHO    ', &
      'MEK     ', &
      'PROD2   ', &
      'O3      ', &
      'HO2     ', &
      'RO2_N   ', &
      'MA_RCO3 ', &
      'C_O2    ', &
      'BZCO_O2 ', &
      'RO2_R   ', &
      'NO      ', &
      'NO2     ', &
      'NO3     ', &
      'CCO_O2  ', &
      'RCO_O2  ', &
      'OH      ', &
      'AIR     ', &
      'O2      ', &
      'H2O     ', &
      'H2      ', &
      'CH4     '  /)

  ! Equations 
  CHARACTER(LEN=167), PARAMETER :: EQN_NAMES(NREACT) = (/ &
      'NO2 + hv --> NO + O3P                                    &
      &                                                          &
      &                                                    ', &
      'O3P + O2 + AIR --> O3                                    &
      &                                                          &
      &                                                    ', &
      'O3P + O3 --> 2 O2                                        &
      &                                                          &
      &                                                    ', &
      'O3P + NO + AIR --> NO2                                   &
      &                                                          &
      &                                                    ', &
      'O3P + NO2 --> NO                                         &
      &                                                          &
      &                                                    ', &
      'O3P + NO2 --> NO3                                        &
      &                                                          &
      &                                                    ', &
      'O3 + NO --> NO2                                          &
      &                                                          &
      &                                                    ', &
      'O3 + NO2 --> NO3                                         &
      &                                                          &
      &                                                    ', &
      'NO + NO3 --> 2 NO2                                       &
      &                                                          &
      &                                                    ', &
      'NO + NO + O2 --> 2 NO2                                   &
      &                                                          &
      &                                                    ', &
      'NO2 + NO3 --> N2O5                                       &
      &                                                          &
      &                                                    ', &
      'N2O5 --> NO2 + NO3                                       &
      &                                                          &
      &                                                    ', &
      'N2O5 + H2O --> 2 HNO3                                    &
      &                                                          &
      &                                                    ', &
      'NO2 + NO3 --> NO + NO2                                   &
      &                                                          &
      &                                                    ', &
      'NO3 + hv --> NO                                          &
      &                                                          &
      &                                                    ', &
      'NO3 + hv --> NO2 + O3P                                   &
      &                                                          &
      &                                                    ', &
      'O3 + hv --> O3P                                          &
      &                                                          &
      &                                                    ', &
      'O3 + hv --> O1D                                          &
      &                                                          &
      &                                                    ', &
      'O1D + H2O --> 2 OH                                       &
      &                                                          &
      &                                                    ', &
      'O1D + AIR --> O3P                                        &
      &                                                          &
      &                                                    ', &
      'OH + NO --> HONO                                         &
      &                                                          &
      &                                                    ', &
      'HONO + hv --> OH + NO                                    &
      &                                                          &
      &                                                    ', &
      'HONO + hv --> HO2 + NO2                                  &
      &                                                          &
      &                                                    ', &
      'OH + HONO --> NO2                                        &
      &                                                          &
      &                                                    ', &
      'OH + NO2 --> HNO3                                        &
      &                                                          &
      &                                                    ', &
      'OH + NO3 --> HO2 + NO2                                   &
      &                                                          &
      &                                                    ', &
      'OH + HNO3 --> NO3                                        &
      &                                                          &
      &                                                    ', &
      'HNO3 + hv --> OH + NO2                                   &
      &                                                          &
      &                                                    ', &
      'OH + CO --> HO2                                          &
      &                                                          &
      &                                                    ', &
      'OH + O3 --> HO2                                          &
      &                                                          &
      &                                                    ', &
      'HO2 + NO --> OH + NO2                                    &
      &                                                          &
      &                                                    ', &
      'HO2 + NO2 --> HNO4                                       &
      &                                                          &
      &                                                    ', &
      'HNO4 --> HO2 + NO2                                       &
      &                                                          &
      &                                                    ', &
      'HNO4 + hv --> HO2 + NO2 + OH + NO3                       &
      &                                                          &
      &                                                    ', &
      'HNO4 + OH --> NO2                                        &
      &                                                          &
      &                                                    ', &
      'HO2 + O3 --> OH                                          &
      &                                                          &
      &                                                    ', &
      'HO2 + HO2 --> H2O2                                       &
      &                                                          &
      &                                                    ', &
      'HO2 + HO2 + H2O --> H2O2                                 &
      &                                                          &
      &                                                    ', &
      'NO3 + HO2 --> OH + NO2 + HNO3                            &
      &                                                          &
      &                                                    ', &
      'NO3 + NO3 --> 2 NO2                                      &
      &                                                          &
      &                                                    ', &
      'H2O2 + hv --> 2 OH                                       &
      &                                                          &
      &                                                    ', &
      'H2O2 + OH --> HO2                                        &
      &                                                          &
      &                                                    ', &
      'OH + HO2 --> H2O + O2                                    &
      &                                                          &
      &                                                    ', &
      'OH + SO2 --> HO2 + H2SO4                                 &
      &                                                          &
      &                                                    ', &
      'OH + H2 --> HO2                                          &
      &                                                          &
      &                                                    ', &
      'C_O2 + NO --> NO2 + HCHO + HO2                           &
      &                                                          &
      &                                                    ', &
      'C_O2 + HO2 --> COOH                                      &
      &                                                          &
      &                                                    ', &
      'C_O2 + NO3 --> HCHO + HO2 + NO2                          &
      &                                                          &
      &                                                    ', &
      'C_O2 + C_O2 --> MEOH + HCHO                              &
      &                                                          &
      &                                                    ', &
      'C_O2 + C_O2 --> 2 HCHO + 2 HO2                           &
      &                                                          &
      &                                                    ', &
      'RO2_R + NO --> NO2 + HO2                                 &
      &                                                          &
      &                                                    ', &
      'RO2_R + HO2 --> ROOH                                     &
      &                                                          &
      &                                                    ', &
      'RO2_R + NO3 --> NO2 + HO2                                &
      &                                                          &
      &                                                    ', &
      'RO2_R + C_O2 --> HO2 + HCHO + MEOH                       &
      &                                                          &
      &                                                    ', &
      'RO2_R + RO2_R --> HO2                                    &
      &                                                          &
      &                                                    ', &
      'R2O2 + NO --> NO2                                        &
      &                                                          &
      &                                                    ', &
      'R2O2 + HO2 --> HO2                                       &
      &                                                          &
      &                                                    ', &
      'R2O2 + NO3 --> NO2                                       &
      &                                                          &
      &                                                    ', &
      'R2O2 + C_O2 --> C_O2                                     &
      &                                                          &
      &                                                    ', &
      'R2O2 + RO2_R --> RO2_R                                   &
      &                                                          &
      &                                                    ', &
      'R2O2 + R2O2 --> 2 R2O2                                   &
      &                                                          &
      &                                                    ', &
      'RO2_N + NO --> RNO3                                      &
      &                                                          &
      &                                                    ', &
      'RO2_N + HO2 --> ROOH                                     &
      &                                                          &
      &                                                    ', &
      'RO2_N + C_O2 --> HO2 + MEOH + MEK + PROD2 + HCHO         &
      &                                                          &
      &                                                    ', &
      'RO2_N + NO3 --> NO2 + HO2 + MEK                          &
      &                                                          &
      &                                                    ', &
      'RO2_N + RO2_R --> HO2 + MEK + PROD2                      &
      &                                                          &
      &                                                    ', &
      'RO2_N + R2O2 --> RO2_N                                   &
      &                                                          &
      &                                                    ', &
      'RO2_N + RO2_N --> MEK + HO2 + PROD2                      &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + NO2 --> PAN                                     &
      &                                                          &
      &                                                    ', &
      'PAN --> CCO_O2 + NO2                                     &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + NO --> C_O2 + NO2                               &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + HO2 --> CCO_OOH + CCO_OH + O3                   &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + NO3 --> C_O2 + NO2                              &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + C_O2 --> CCO_OH + HCHO                          &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + RO2_R --> CCO_OH                                &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + R2O2 --> CCO_O2                                 &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + RO2_N --> CCO_OH + PROD2                        &
      &                                                          &
      &                                                    ', &
      'CCO_O2 + CCO_O2 --> 2 C_O2                               &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + NO2 --> PAN2                                    &
      &                                                          &
      &                                                    ', &
      'PAN2 --> RCO_O2 + NO2                                    &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + NO --> NO2 + CCHO + RO2_R                       &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + HO2 --> RCO_OOH + RCO_OH + O3                   &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + NO3 --> NO2 + CCHO + RO2_R                      &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + C_O2 --> RCO_OH + HCHO                          &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + RO2_R --> RCO_OH                                &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + R2O2 --> RCO_O2                                 &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + RO2_N --> RCO_OH + PROD2                        &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + CCO_O2 --> C_O2 + CCHO + RO2_R                  &
      &                                                          &
      &                                                    ', &
      'RCO_O2 + RCO_O2 --> 2 CCHO + 2 RO2_R                     &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + NO2 --> PBZN                                   &
      &                                                          &
      &                                                    ', &
      'PBZN --> BZCO_O2 + NO2                                   &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + NO --> NO2 + BZ_O + R2O2                       &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + HO2 --> RCO_OOH + RCO_OH + O3                  &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + NO3 --> NO2 + BZ_O + R2O2                      &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + C_O2 --> RCO_OH + HCHO                         &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + RO2_R --> RCO_OH                               &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + R2O2 --> BZCO_O2                               &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + RO2_N --> RCO_OH + PROD2                       &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + CCO_O2 --> C_O2 + BZ_O + R2O2                  &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + RCO_O2 --> CCHO + RO2_R + BZ_O + R2O2          &
      &                                                          &
      &                                                    ', &
      'BZCO_O2 + BZCO_O2 --> 2 BZ_O + 2 R2O2                    &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + NO2 --> MA_PAN                                 &
      &                                                          &
      &                                                    ', &
      'MA_PAN --> MA_RCO3 + NO2                                 &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + NO --> NO2 + HCHO + CCO_O2                     &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + HO2 --> RCO_OOH + RCO_OH + O3                  &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + NO3 --> NO2 + HCHO + CCO_O2                    &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + C_O2 --> RCO_OH + HCHO                         &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + RO2_R --> RCO_OH                               &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + R2O2 --> MA_RCO3                               &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + RO2_N --> 2 RCO_OH                             &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + CCO_O2 --> C_O2 + HCHO + CCO_O2                &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + RCO_O2 --> HCHO + CCO_O2 + CCHO + RO2_R        &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + BZCO_O2 --> HCHO + CCO_O2 + BZ_O + R2O2        &
      &                                                          &
      &                                                    ', &
      'MA_RCO3 + MA_RCO3 --> 2 HCHO + 2 CCO_O2                  &
      &                                                          &
      &                                                    ', &
      'TBU_O + NO2 --> RNO3                                     &
      &                                                          &
      &                                                    ', &
      'TBU_O --> ACET + C_O2                                    &
      &                                                          &
      &                                                    ', &
      'BZ_O + NO2 --> NPHE                                      &
      &                                                          &
      &                                                    ', &
      'BZ_O + HO2 --> PHEN                                      &
      &                                                          &
      &                                                    ', &
      'BZ_O --> PHEN                                            &
      &                                                          &
      &                                                    ', &
      'BZNO2_O + NO2 --> 2 XN + 6 XC                            &
      &                                                          &
      &                                                    ', &
      'BZNO2_O + HO2 --> NPHE                                   &
      &                                                          &
      &                                                    ', &
      'BZNO2_O --> NPHE                                         &
      &                                                          &
      &                                                    ', &
      'HCHO + hv --> 2 HO2 + CO                                 &
      &                                                          &
      &                                                    ', &
      'HCHO + hv --> CO                                         &
      &                                                          &
      &                                                    ', &
      'HCHO + OH --> HO2 + CO                                   &
      &                                                          &
      &                                                    ', &
      'HCHO + HO2 --> HOCOO                                     &
      &                                                          &
      &                                                    ', &
      'HOCOO --> HO2 + HCHO                                     &
      &                                                          &
      &                                                    ', &
      'HOCOO + NO --> HCOOH + NO2 + HO2                         &
      &                                                          &
      &                                                    ', &
      'HCHO + NO3 --> HNO3 + HO2 + CO                           &
      &                                                          &
      &                                                    ', &
      'CCHO + OH --> CCO_O2                                     &
      &                                                          &
      &                                                    ', &
      'CCHO + hv --> CO + HO2 + C_O2                            &
      &                                                          &
      &                                                    ', &
      'CCHO + NO3 --> HNO3 + CCO_O2                             &
      &                                                          &
      &                                                    ', &
      'RCHO + OH --> RO2_R + RO2_N + RCO_O2 + CO + CCHO         &
      &                                                          &
      &                                                    ', &
      'RCHO + hv --> CCHO + RO2_R + CO + HO2                    &
      &                                                          &
      &                                                    ', &
      'RCHO + NO3 --> HNO3 + RCO_O2                             &
      &                                                          &
      &                                                    ', &
      'ACET + OH --> HCHO + CCO_O2 + R2O2                       &
      &                                                          &
      &                                                    ', &
      'ACET + hv --> CCO_O2 + C_O2                              &
      &                                                          &
      &                                                    ', &
      'MEK + OH --> RO2_R + RO2_N + R2O2 + CCO_O2 + RCO_O2 + HCH&
      &O + CCHO + RCHO                                           &
      &                                                    ', &
      'MEK + hv --> CCO_O2 + CCHO + RO2_R                       &
      &                                                          &
      &                                                    ', &
      'MEOH + OH --> HCHO + HO2                                 &
      &                                                          &
      &                                                    ', &
      'COOH + OH --> HCHO + OH + C_O2                           &
      &                                                          &
      &                                                    ', &
      'COOH + hv --> HCHO + HO2 + OH                            &
      &                                                          &
      &                                                    ', &
      'ROOH + OH --> RCHO + RO2_R + OH                          &
      &                                                          &
      &                                                    ', &
      'ROOH + hv --> RCHO + HO2 + OH                            &
      &                                                          &
      &                                                    ', &
      'GLY + hv --> 2 CO + 2 HO2                                &
      &                                                          &
      &                                                    ', &
      'GLY + hv --> HCHO + CO                                   &
      &                                                          &
      &                                                    ', &
      'GLY + OH --> HO2 + 1.26 CO + RCO_O2                      &
      &                                                          &
      &                                                    ', &
      'GLY + NO3 --> HNO3 + HO2 + 1.26 CO + RCO_O2              &
      &                                                          &
      &                                                    ', &
      'MGLY + hv --> HO2 + CO + CCO_O2                          &
      &                                                          &
      &                                                    ', &
      'MGLY + OH --> CO + CCO_O2                                &
      &                                                          &
      &                                                    ', &
      'MGLY + NO3 --> HNO3 + CO + CCO_O2                        &
      &                                                          &
      &                                                    ', &
      'BACL + hv --> 2 CCO_O2                                   &
      &                                                          &
      &                                                    ', &
      'PHEN + OH --> BZ_O + RO2_R + GLY                         &
      &                                                          &
      &                                                    ', &
      'PHEN + NO3 --> HNO3 + BZ_O                               &
      &                                                          &
      &                                                    ', &
      'CRES + OH --> BZ_O + RO2_R + MGLY                        &
      &                                                          &
      &                                                    ', &
      'CRES + NO3 --> HNO3 + BZ_O                               &
      &                                                          &
      &                                                    ', &
      'NPHE + NO3 --> HNO3 + BZNO2_O                            &
      &                                                          &
      &                                                    ', &
      'BALD + OH --> BZCO_O2                                    &
      &                                                          &
      &                                                    ', &
      'BALD + hv --> 7 XC                                       &
      &                                                          &
      &                                                    ', &
      'BALD + NO3 --> HNO3 + BZCO_O2                            &
      &                                                          &
      &                                                    ', &
      'METHACRO + OH --> RO2_R + CO + HCHO + MEK + MGLY + MA_RCO&
      &3                                                         &
      &                                                    ', &
      'METHACRO + O3 --> HO2 + RO2_R + OH + RCO_O2 + CO + HCHO +&
      & MGLY + HCOOH                                             &
      &                                                    ', &
      'METHACRO + NO3 --> HNO3 + RO2_R + CO + MA_RCO3           &
      &                                                          &
      &                                                    ', &
      'METHACRO + O3P --> RCHO                                  &
      &                                                          &
      &                                                    ', &
      'METHACRO + hv --> HO2 + RO2_R + OH + CCO_O2 + CO + HCHO +&
      & MA_RCO3                                                  &
      &                                                    ', &
      'MVK + OH --> RO2_R + RO2_N + R2O2 + CCO_O2 + HCHO + RCHO &
      &+ MGLY                                                    &
      &                                                    ', &
      'MVK + O3 --> HO2 + RO2_R + OH + RCO_O2 + CO + HCHO + MGLY&
      & + HCOOH                                                  &
      &                                                    ', &
      'MVK + O3P --> RCHO + MEK                                 &
      &                                                          &
      &                                                    ', &
      'MVK + hv --> C_O2 + CO + PROD2 + MA_RCO3                 &
      &                                                          &
      &                                                    ', &
      'ISOPROD + OH --> RO2_R + RO2_N + MA_RCO3 + CO + HCHO + CC&
      &HO + RCHO + MEK + PROD2 + GLY + MGLY                      &
      &                                                    ', &
      'ISOPROD + O3 --> HO2 + RO2_R + RCO_O2 + OH + CO + HCHO + &
      &CCHO + MEK + GLY + MGLY + HCOOH + RCO_OH                  &
      &                                                    ', &
      'ISOPROD + NO3 --> RO2_R + RO2_N + MA_RCO3 + CO + HNO3 + H&
      &CHO + RCHO + MGLY + RNO3                                  &
      &                                                    ', &
      'ISOPROD + hv --> 1.233 HO2 + CCO_O2 + RCO_O2 + 1.233 CO +&
      & HCHO + CCHO + MEK                                        &
      &                                                    ', &
      'PROD2 + OH --> HO2 + RO2_R + RO2_N + CCO_O2 + RCO_O2 + HC&
      &HO + CCHO + RCHO + MEK + PROD2                            &
      &                                                    ', &
      'PROD2 + hv --> RO2_R + RO2_N + R2O2 + CCO_O2 + RCO_O2 + H&
      &CHO + CCHO + RCHO                                         &
      &                                                    ', &
      'RNO3 + OH --> NO2 + HO2 + RO2_R + RO2_N + R2O2 + HCHO + C&
      &CHO + RCHO + ACET + MEK + PROD2 + RNO3                    &
      &                                                    ', &
      'RNO3 + hv --> NO2 + HO2 + RO2_R + RO2_N + R2O2 + HCHO + C&
      &CHO + RCHO + ACET + MEK + PROD2                           &
      &                                                    ', &
      'DCB1 + OH --> RCHO + RO2_R + CO                          &
      &                                                          &
      &                                                    ', &
      'DCB1 + O3 --> 1.5 HO2 + OH + 1.5 CO + GLY                &
      &                                                          &
      &                                                    ', &
      'DCB2 + OH --> R2O2 + RCHO + CCO_O2                       &
      &                                                          &
      &                                                    ', &
      'DCB2 + hv --> RO2_R + CCO_O2 + HO2 + CO + R2O2 + GLY + MG&
      &LY                                                        &
      &                                                    ', &
      'DCB3 + OH --> R2O2 + RCHO + CCO_O2                       &
      &                                                          &
      &                                                    ', &
      'DCB3 + hv --> RO2_R + CCO_O2 + HO2 + CO + R2O2 + GLY + MG&
      &LY                                                        &
      &                                                    ', &
      'CH4 + OH --> C_O2                                        &
      &                                                          &
      &                                                    ', &
      'ETHENE + OH --> RO2_R + 1.61 HCHO + CCHO                 &
      &                                                          &
      &                                                    ', &
      'ETHENE + O3 --> OH + HO2 + CO + HCHO + HCOOH             &
      &                                                          &
      &                                                    ', &
      'ETHENE + NO3 --> RO2_R + RCHO                            &
      &                                                          &
      &                                                    ', &
      'ETHENE + O3P --> HO2 + RO2_R + C_O2 + CO + HCHO + CCHO + &
      &GLY                                                       &
      &                                                    ', &
      'ISOPRENE + OH --> RO2_R + RO2_N + R2O2 + HCHO + METHACRO &
      &+ MVK + ISOPROD                                           &
      &                                                    ', &
      'ISOPRENE + O3 --> OH + RO2_R + RO2_N + R2O2 + MA_RCO3 + C&
      &O + HCHO + PROD2 + METHACRO + MVK + HCOOH + RCO_OH        &
      &                                                    ', &
      'ISOPRENE + NO3 --> NO2 + RO2_R + RO2_N + R2O2 + ISOPROD  &
      &                                                          &
      &                                                    ', &
      'ISOPRENE + O3P --> RO2_N + R2O2 + C_O2 + MA_RCO3 + HCHO +&
      & PROD2                                                    &
      &                                                    ', &
      'TERP + OH --> RO2_R + RO2_N + R2O2 + HCHO + RCHO + PROD2 &
      &                                                          &
      &                                                    ', &
      'TERP + O3 --> OH + HO2 + RO2_R + RO2_N + R2O2 + CCO_O2 + &
      &RCO_O2 + CO + HCHO + RCHO + ACET + PROD2 + GLY + BACL + HC&
      &OOH + RCO_OH                                        ', &
      'TERP + NO3 --> NO2 + RO2_R + RO2_N + R2O2 + RCHO + RNO3  &
      &                                                          &
      &                                                    ', &
      'TERP + O3P --> RCHO + PROD2                              &
      &                                                          &
      &                                                    ', &
      'ALK1 + OH --> RO2_R + CCHO                               &
      &                                                          &
      &                                                    ', &
      'ALK2 + OH --> OH + HO2 + RO2_R + RO2_N + CO + HCHO + RCHO&
      & + ACET + GLY + HCOOH                                     &
      &                                                    ', &
      'ALK3 + OH --> RO2_R + RO2_N + R2O2 + TBU_O + HCHO + CCHO &
      &+ RCHO + ACET + MEK                                       &
      &                                                    ', &
      'ALK4 + OH --> RO2_R + RO2_N + R2O2 + C_O2 + CCO_O2 + CO +&
      & HCHO + CCHO + RCHO + ACET + MEK + PROD2                  &
      &                                                    ', &
      'ALK5 + OH --> RO2_R + RO2_N + R2O2 + HCHO + CCHO + RCHO +&
      & ACET + MEK + PROD2                                       &
      &                                                    ', &
      'ARO1 + OH --> HO2 + RO2_R + RO2_N + PROD2 + GLY + MGLY + &
      &PHEN + CRES + BALD + DCB1 + DCB2 + DCB3                   &
      &                                                    ', &
      'ARO2 + OH --> HO2 + RO2_R + RO2_N + GLY + MGLY + BACL + C&
      &RES + BALD + DCB1 + DCB2 + DCB3                           &
      &                                                    ', &
      'OLE1 + OH --> RO2_R + RO2_N + R2O2 + HCHO + CCHO + RCHO +&
      & ACET + PROD2                                             &
      &                                                    ', &
      'OLE1 + O3 --> OH + HO2 + RO2_R + RO2_N + C_O2 + CO + HCHO&
      & + CCHO + RCHO + ACET + PROD2 + HCOOH + CCO_OH + RCO_OH   &
      &                                                    ', &
      'OLE1 + NO3 --> RO2_R + RO2_N + R2O2 + CCHO + RCHO + ACET &
      &+ RNO3                                                    &
      &                                                    ', &
      'OLE1 + O3P --> RCHO + MEK + PROD2                        &
      &                                                          &
      &                                                    ', &
      'OLE2 + OH --> RO2_R + RO2_N + R2O2 + HCHO + CCHO + RCHO +&
      & ACET + MEK + BALD + METHACRO + ISOPROD                   &
      &                                                    ', &
      'OLE2 + O3 --> OH + HO2 + RO2_R + RO2_N + R2O2 + C_O2 + CC&
      &O_O2 + RCO_O2 + CO + HCHO + CCHO + RCHO + ACET + MEK + PRO&
      &D2 + BALD + METHACRO + MVK + HCOOH + CCO_OH + RCO_OH', &
      'OLE2 + NO3 --> NO2 + RO2_R + RO2_N + R2O2 + C_O2 + HCHO +&
      & CCHO + RCHO + ACET + MEK + BALD + MVK + RNO3             &
      &                                                    ', &
      'OLE2 + O3P --> HO2 + RO2_R + RO2_N + CO + RCHO + MEK + PR&
      &OD2 + METHACRO                                            &
      &                                                    '  /)


END MODULE saprc99_monitor
!------------------------ END saprc99_monitor.f90 END ------------------------
