!---------------------- BEGIN saprc99_jacobian.f90 BEGIN ---------------------
! @file saprc99_jacobian.f90                                                  
! @author jlinford                                                            
! @date 2017-02-27 17:42:45.245390                                            
! @brief The Jacobian of the chemical model                                   
!                                                                             
! The Jacobian of the chemical model                                          
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_jacobian

  USE saprc99_parameters
  USE saprc99_sparse

  IMPLICIT NONE





  CONTAINS

!------------------------------------ Jac ------------------------------------
! The Jacobian of variable species                                            
!                                                                             
! @param[in]     var  Variable species concentrations                         
! @param[in]     fix  Fixed species concentrations                            
! @param[in]     rct  Reaction rates                                          
! @param[out]    sjac The row-compressed sparse Jacobian                      
!-----------------------------------------------------------------------------
  SUBROUTINE Jac(var, fix, rct, sjac)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: var(NVAR)
    REAL(8), INTENT(IN) :: fix(NFIX)
    REAL(8), INTENT(IN) :: rct(NREACT)
    REAL(8), INTENT(OUT) :: sjac(JAC_LU_NZ)


    REAL(8) :: t(363)

    t(1) = rct(44)*var(74)
    t(2) = 2.2e-10*fix(3)
    t(3) = fix(1)*rct(20)
    t(4) = rct(197)*var(74)
    t(5) = rct(152)
    t(6) = rct(70)
    t(7) = rct(80)
    t(8) = rct(91)
    t(9) = rct(103)
    t(10) = rct(41)
    t(11) = rct(42)*var(74)
    t(12) = rct(12)
    t(13) = 2.6e-22*fix(3)
    t(14) = rct(22)
    t(15) = rct(23)
    t(16) = rct(24)*var(74)
    t(17) = rct(198)*var(74)
    t(18) = rct(199)*var(74)
    t(19) = 2.4e-11*var(70)
    t(20) = rct(116)
    t(21) = rct(201)*var(74)
    t(22) = 2.64e-11*var(74)
    t(23) = rct(33)
    t(24) = rct(34)
    t(25) = rct(35)*var(74)
    t(26) = rct(141)*var(74)
    t(27) = rct(142)
    t(28) = rct(127)
    t(29) = rct(128)*var(69)
    t(30) = rct(120)*var(70)
    t(31) = rct(121)*var(63)
    t(32) = rct(122)
    t(33) = rct(140)*var(74)
    t(34) = rct(200)*var(74)
    t(35) = rct(202)*var(74)
    t(36) = 5.0e-11*var(74)
    t(37) = rct(181)
    t(38) = 5.0e-11*var(74)
    t(39) = rct(183)
    t(40) = 4.2e-11*var(74)
    t(41) = 1.37e-11*var(71)
    t(42) = 5.0e-11*var(74)
    t(43) = 2.0e-18*var(62)
    t(44) = 3.78e-12*var(71)
    t(45) = 1.1e-11*var(74)
    t(46) = rct(144)
    t(47) = 1.29e-11*var(74)
    t(48) = rct(159)
    t(49) = rct(160)*var(71)
    t(50) = 2.63e-11*var(74)
    t(51) = 3.78e-12*var(71)
    t(52) = rct(29)*var(74)
    t(53) = rct(149)
    t(54) = 1.5e-11*var(74)
    t(55) = rct(151)*var(71)
    t(56) = rct(136)*var(74)
    t(57) = rct(137)
    t(58) = rct(27)*var(74)
    t(59) = rct(28)
    t(60) = rct(185)*var(74)
    t(61) = rct(186)*var(62)
    t(62) = rct(187)*var(71)
    t(63) = rct(188)*var(58)
    t(64) = rct(145)
    t(65) = rct(146)
    t(66) = 1.1e-11*var(74)
    t(67) = rct(148)*var(71)
    t(68) = rct(117)*var(70)
    t(69) = rct(118)*var(63)
    t(70) = 0.001
    t(71) = rct(189)*var(74)
    t(72) = rct(190)*var(62)
    t(73) = rct(191)*var(71)
    t(74) = 3.6e-11*var(58)
    t(75) = rct(56)*var(69)
    t(76) = rct(57)*var(63)
    t(77) = 2.3e-12*var(71)
    t(78) = 2.0e-13*var(66)
    t(79) = 3.5e-14*var(68)
    t(80) = 0
    t(81) = 3.5e-14*var(64)
    t(82) = 7.5e-12*var(72)
    t(83) = 7.5e-12*var(73)
    t(84) = 7.5e-12*var(67)
    t(85) = 7.5e-12*var(65)
    t(86) = rct(193)*var(74)
    t(87) = rct(194)*var(62)
    t(88) = rct(195)*var(71)
    t(89) = 3.27e-11*var(58)
    t(90) = rct(161)*var(74)
    t(91) = rct(162)*var(62)
    t(92) = rct(163)*var(71)
    t(93) = 6.34e-12*var(58)
    t(94) = rct(165)
    t(95) = rct(204)*var(74)
    t(96) = rct(205)*var(62)
    t(97) = rct(206)*var(71)
    t(98) = rct(207)*var(58)
    t(99) = 6.19e-11*var(74)
    t(100) = 4.18e-18*var(62)
    t(101) = 1.0e-13*var(71)
    t(102) = rct(173)
    t(103) = rct(208)*var(74)
    t(104) = rct(209)*var(62)
    t(105) = 7.265e-13*var(71)
    t(106) = 2.085e-11*var(58)
    t(107) = rct(166)*var(74)
    t(108) = rct(167)*var(62)
    t(109) = 4.32e-12*var(58)
    t(110) = rct(169)
    t(111) = rct(130)*var(74)
    t(112) = rct(131)
    t(113) = rct(132)*var(71)
    t(114) = rct(123)
    t(115) = rct(124)
    t(116) = rct(125)*var(74)
    t(117) = rct(126)*var(63)
    t(118) = rct(129)*var(71)
    t(119) = 7.8e-12*var(74)
    t(120) = rct(177)
    t(121) = fix(1)*fix(2)*rct(2)
    t(122) = rct(3)*var(62)
    t(123) = fix(1)*rct(4)*var(69)
    t(124) = rct(5)*var(70)
    t(125) = rct(6)*var(70)
    t(126) = 6.34e-12*var(50)
    t(127) = 4.32e-12*var(54)
    t(128) = rct(188)*var(44)
    t(129) = 3.6e-11*var(47)
    t(130) = 3.27e-11*var(49)
    t(131) = rct(207)*var(51)
    t(132) = 2.085e-11*var(53)
    t(133) = 2.0e-11*var(74)
    t(134) = rct(134)
    t(135) = rct(135)*var(71)
    t(136) = rct(138)*var(74)
    t(137) = rct(139)
    t(138) = 1.5e-11*var(74)
    t(139) = rct(175)
    t(140) = rct(3)*var(58)
    t(141) = rct(7)*var(69)
    t(142) = rct(8)*var(70)
    t(143) = rct(17)
    t(144) = rct(18)
    t(145) = rct(30)*var(74)
    t(146) = rct(36)*var(63)
    t(147) = rct(162)*var(50)
    t(148) = rct(167)*var(54)
    t(149) = 4.18e-18*var(52)
    t(150) = 2.0e-18*var(35)
    t(151) = rct(186)*var(44)
    t(152) = rct(190)*var(47)
    t(153) = rct(194)*var(49)
    t(154) = rct(205)*var(51)
    t(155) = rct(209)*var(53)
    t(156) = rct(31)*var(69)
    t(157) = rct(32)*var(70)
    t(158) = rct(36)*var(62)
    t(159) = 2.0*rct(37)*var(63)
    t(160) = 2.0*fix(3)*rct(38)*var(63)
    t(161) = 4.0e-12*var(71)
    t(162) = rct(43)*var(74)
    t(163) = rct(47)*var(66)
    t(164) = rct(52)*var(68)
    t(165) = rct(57)*var(48)
    t(166) = rct(63)*var(64)
    t(167) = rct(72)*var(72)
    t(168) = rct(82)*var(73)
    t(169) = rct(93)*var(67)
    t(170) = rct(105)*var(65)
    t(171) = rct(118)*var(46)
    t(172) = rct(121)*var(28)
    t(173) = rct(126)*var(56)
    t(174) = rct(62)*var(69)
    t(175) = rct(63)*var(63)
    t(176) = 2.0e-13*var(66)
    t(177) = 2.3e-12*var(71)
    t(178) = 3.5e-14*var(68)
    t(179) = 3.5e-14*var(48)
    t(180) = 7.0e-14*var(64)
    t(181) = 7.5e-12*var(72)
    t(182) = 7.5e-12*var(73)
    t(183) = 7.5e-12*var(67)
    t(184) = 7.5e-12*var(65)
    t(185) = rct(102)*var(70)
    t(186) = rct(104)*var(69)
    t(187) = rct(105)*var(63)
    t(188) = 4.0e-12*var(71)
    t(189) = rct(107)*var(66)
    t(190) = 7.5e-12*var(68)
    t(191) = 7.5e-12*var(48)
    t(192) = 7.5e-12*var(64)
    t(193) = rct(111)*var(72)
    t(194) = rct(112)*var(73)
    t(195) = rct(113)*var(67)
    t(196) = 2.0*rct(114)*var(65)
    t(197) = rct(46)*var(69)
    t(198) = rct(47)*var(63)
    t(199) = 1.3e-12*var(71)
    t(200) = 2.0*rct(49)*var(66)
    t(201) = 2.0*rct(50)*var(66)
    t(202) = 2.0e-13*var(68)
    t(203) = 2.0e-13*var(48)
    t(204) = 2.0e-13*var(64)
    t(205) = rct(74)*var(72)
    t(206) = rct(84)*var(73)
    t(207) = rct(95)*var(67)
    t(208) = rct(107)*var(65)
    t(209) = 1.37e-11*var(70)
    t(210) = rct(92)*var(69)
    t(211) = rct(93)*var(63)
    t(212) = 4.0e-12*var(71)
    t(213) = rct(95)*var(66)
    t(214) = 7.5e-12*var(68)
    t(215) = 7.5e-12*var(48)
    t(216) = 7.5e-12*var(64)
    t(217) = rct(99)*var(72)
    t(218) = rct(100)*var(73)
    t(219) = 2.0*rct(101)*var(67)
    t(220) = rct(113)*var(65)
    t(221) = rct(51)*var(69)
    t(222) = rct(52)*var(63)
    t(223) = 2.3e-12*var(71)
    t(224) = 2.0e-13*var(66)
    t(225) = 7.0e-14*var(68)
    t(226) = 3.5e-14*var(48)
    t(227) = 3.5e-14*var(64)
    t(228) = 7.5e-12*var(72)
    t(229) = 7.5e-12*var(73)
    t(230) = 7.5e-12*var(67)
    t(231) = 7.5e-12*var(65)
    t(232) = fix(1)*rct(4)*var(58)
    t(233) = rct(7)*var(62)
    t(234) = rct(9)*var(71)
    t(235) = 2.0*fix(2)*rct(10)*var(69)
    t(236) = rct(21)*var(74)
    t(237) = rct(31)*var(63)
    t(238) = rct(46)*var(66)
    t(239) = rct(51)*var(68)
    t(240) = rct(56)*var(48)
    t(241) = rct(62)*var(64)
    t(242) = rct(71)*var(72)
    t(243) = rct(81)*var(73)
    t(244) = rct(92)*var(67)
    t(245) = rct(104)*var(65)
    t(246) = rct(128)*var(27)
    t(247) = rct(1)
    t(248) = rct(5)*var(58)
    t(249) = rct(6)*var(58)
    t(250) = rct(8)*var(62)
    t(251) = rct(11)*var(71)
    t(252) = rct(14)*var(71)
    t(253) = rct(25)*var(74)
    t(254) = rct(32)*var(63)
    t(255) = rct(69)*var(72)
    t(256) = rct(79)*var(73)
    t(257) = 1.37e-11*var(67)
    t(258) = rct(102)*var(65)
    t(259) = 2.4e-11*var(22)
    t(260) = rct(117)*var(46)
    t(261) = rct(120)*var(28)
    t(262) = rct(9)*var(69)
    t(263) = rct(11)*var(70)
    t(264) = rct(14)*var(70)
    t(265) = rct(15)
    t(266) = rct(16)
    t(267) = 2.0e-11*var(74)
    t(268) = 4.0e-12*var(63)
    t(269) = 2.0*rct(40)*var(71)
    t(270) = 1.3e-12*var(66)
    t(271) = 2.3e-12*var(68)
    t(272) = 2.3e-12*var(48)
    t(273) = 2.3e-12*var(64)
    t(274) = 4.0e-12*var(72)
    t(275) = 4.0e-12*var(73)
    t(276) = 4.0e-12*var(67)
    t(277) = 4.0e-12*var(65)
    t(278) = rct(129)*var(56)
    t(279) = rct(132)*var(55)
    t(280) = rct(135)*var(59)
    t(281) = rct(148)*var(45)
    t(282) = rct(151)*var(41)
    t(283) = 3.78e-12*var(39)
    t(284) = 1.37e-11*var(34)
    t(285) = 3.78e-12*var(36)
    t(286) = rct(160)*var(38)
    t(287) = rct(163)*var(50)
    t(288) = 1.0e-13*var(52)
    t(289) = rct(187)*var(44)
    t(290) = rct(191)*var(47)
    t(291) = rct(195)*var(49)
    t(292) = rct(206)*var(51)
    t(293) = 7.265e-13*var(53)
    t(294) = rct(69)*var(70)
    t(295) = rct(71)*var(69)
    t(296) = rct(72)*var(63)
    t(297) = 4.0e-12*var(71)
    t(298) = rct(74)*var(66)
    t(299) = 7.5e-12*var(68)
    t(300) = 7.5e-12*var(48)
    t(301) = 7.5e-12*var(64)
    t(302) = 2.0*rct(78)*var(72)
    t(303) = rct(88)*var(73)
    t(304) = rct(99)*var(67)
    t(305) = rct(111)*var(65)
    t(306) = rct(79)*var(70)
    t(307) = rct(81)*var(69)
    t(308) = rct(82)*var(63)
    t(309) = 4.0e-12*var(71)
    t(310) = rct(84)*var(66)
    t(311) = 7.5e-12*var(68)
    t(312) = 7.5e-12*var(48)
    t(313) = 7.5e-12*var(64)
    t(314) = rct(88)*var(72)
    t(315) = 2.0*rct(89)*var(73)
    t(316) = rct(100)*var(67)
    t(317) = rct(112)*var(65)
    t(318) = rct(21)*var(69)
    t(319) = rct(24)*var(19)
    t(320) = rct(25)*var(70)
    t(321) = 2.0e-11*var(71)
    t(322) = rct(27)*var(43)
    t(323) = rct(29)*var(40)
    t(324) = rct(30)*var(62)
    t(325) = rct(35)*var(25)
    t(326) = rct(42)*var(17)
    t(327) = rct(43)*var(63)
    t(328) = rct(44)*var(9)
    t(329) = fix(4)*rct(45)
    t(330) = rct(125)*var(56)
    t(331) = rct(130)*var(55)
    t(332) = 2.0e-11*var(59)
    t(333) = rct(136)*var(42)
    t(334) = rct(138)*var(60)
    t(335) = rct(140)*var(29)
    t(336) = rct(141)*var(26)
    t(337) = 1.1e-11*var(37)
    t(338) = 1.1e-11*var(45)
    t(339) = 1.5e-11*var(41)
    t(340) = 2.63e-11*var(39)
    t(341) = 4.2e-11*var(34)
    t(342) = 1.29e-11*var(38)
    t(343) = rct(161)*var(50)
    t(344) = rct(166)*var(54)
    t(345) = 6.19e-11*var(52)
    t(346) = 1.5e-11*var(61)
    t(347) = 7.8e-12*var(57)
    t(348) = 5.0e-11*var(35)
    t(349) = 5.0e-11*var(32)
    t(350) = 5.0e-11*var(33)
    t(351) = fix(5)*rct(184)
    t(352) = rct(185)*var(44)
    t(353) = rct(189)*var(47)
    t(354) = rct(193)*var(49)
    t(355) = rct(197)*var(11)
    t(356) = rct(198)*var(20)
    t(357) = rct(199)*var(21)
    t(358) = rct(200)*var(30)
    t(359) = rct(201)*var(23)
    t(360) = rct(202)*var(31)
    t(361) = 2.64e-11*var(24)
    t(362) = rct(204)*var(51)
    t(363) = rct(208)*var(53)

    sjac(1) = 0
    sjac(2) = t(1)
    sjac(3) = t(328)
    sjac(4) = 0
    sjac(5) = 0.121*t(17)
    sjac(6) = t(29)
    sjac(7) = 0.37*t(61)
    sjac(8) = 0.204*t(72)
    sjac(9) = 0.103*t(87)
    sjac(10) = 0.333*t(91)
    sjac(11) = 0.185*t(96)
    sjac(12) = 0.1*t(100)
    sjac(13) = 0.073*t(104)
    sjac(14) = 0.351*t(108)
    sjac(15) = 0.333*t(147) + 0.351*t(148) + 0.1*t(149) + 0.37*t(151) + &
        0.204*t(152) + 0.103*t(153) + 0.185*t(154) + 0.073*t(155)
    sjac(16) = t(246)
    sjac(17) = 0.121*t(356)
    sjac(18) = 0
    sjac(19) = 0.05*t(96)
    sjac(20) = 0.129*t(104)
    sjac(21) = 0.05*t(154) + 0.129*t(155)
    sjac(22) = 0.25*t(167)
    sjac(23) = t(181)
    sjac(24) = t(205)
    sjac(25) = t(228)
    sjac(26) = 0.25*t(296) + t(298) + t(299) + t(301)
    sjac(27) = 0
    sjac(28) = 0.15*t(72)
    sjac(29) = 0.189*t(87)
    sjac(30) = 0.119*t(96)
    sjac(31) = 0.372*t(100)
    sjac(32) = 0.247*t(104)
    sjac(33) = 0.372*t(149) + 0.15*t(152) + 0.189*t(153) + 0.119*t(154) + &
        0.247*t(155)
    sjac(34) = 0.25*t(168) + 0.25*t(169) + 0.25*t(170)
    sjac(35) = t(182) + t(183) + 2.0*t(184)
    sjac(36) = 0.25*t(187) + t(189) + t(190) + 2.0*t(192)
    sjac(37) = t(206) + t(207) + t(208)
    sjac(38) = 0.25*t(211) + t(213) + t(214) + t(216)
    sjac(39) = t(229) + t(230) + t(231)
    sjac(40) = 0.25*t(308) + t(310) + t(311) + t(313)
    sjac(41) = 0
    sjac(42) = 0.75*t(167)
    sjac(43) = 0.75*t(296)
    sjac(44) = 0
    sjac(45) = 0.75*t(168) + 0.75*t(169) + 0.75*t(170)
    sjac(46) = 0.75*t(187)
    sjac(47) = 0.75*t(211)
    sjac(48) = 0.75*t(308)
    sjac(49) = 0
    sjac(50) = 2.0*t(30)
    sjac(51) = 2.0*t(261)
    sjac(52) = 0
    sjac(53) = 6.0*t(30)
    sjac(54) = 7.0*t(48)
    sjac(55) = 6.0*t(261)
    sjac(56) = -t(1)
    sjac(57) = -t(328)
    sjac(58) = -t(2) - t(3)
    sjac(59) = t(144)
    sjac(60) = -t(4)
    sjac(61) = -t(355)
    sjac(62) = -t(5)
    sjac(63) = 0.087*t(22)
    sjac(64) = 0.031*t(87)
    sjac(65) = 0.031*t(153)
    sjac(66) = 0.087*t(361)
    sjac(67) = -t(6)
    sjac(68) = t(255)
    sjac(69) = t(294)
    sjac(70) = -t(7)
    sjac(71) = t(256)
    sjac(72) = t(306)
    sjac(73) = -t(8)
    sjac(74) = t(209)
    sjac(75) = t(257)
    sjac(76) = -t(9)
    sjac(77) = t(185)
    sjac(78) = t(258)
    sjac(79) = -t(10) - t(11)
    sjac(80) = t(159) + t(160)
    sjac(81) = -t(326)
    sjac(82) = -t(12) - t(13)
    sjac(83) = t(251)
    sjac(84) = t(263)
    sjac(85) = -t(14) - t(15) - t(16)
    sjac(86) = t(236)
    sjac(87) = t(318) - t(319)
    sjac(88) = -t(17)
    sjac(89) = -t(356)
    sjac(90) = -t(18)
    sjac(91) = -t(357)
    sjac(92) = 0.236*t(18)
    sjac(93) = -t(19) - t(20)
    sjac(94) = -t(259)
    sjac(95) = 0.236*t(357)
    sjac(96) = -t(21)
    sjac(97) = -t(359)
    sjac(98) = -t(22)
    sjac(99) = -t(361)
    sjac(100) = -t(23) - t(24) - t(25)
    sjac(101) = t(157)
    sjac(102) = t(254)
    sjac(103) = -t(325)
    sjac(104) = -t(26) - t(27)
    sjac(105) = t(163)
    sjac(106) = t(198)
    sjac(107) = -t(336)
    sjac(108) = -t(28) - t(29)
    sjac(109) = t(117)
    sjac(110) = t(173)
    sjac(111) = -t(246)
    sjac(112) = -t(30) - t(31) - t(32)
    sjac(113) = t(44)
    sjac(114) = -t(172)
    sjac(115) = -t(261)
    sjac(116) = t(285)
    sjac(117) = -t(33)
    sjac(118) = 0.25*t(176)
    sjac(119) = t(200) + 0.25*t(202) + 0.25*t(204)
    sjac(120) = 0.25*t(224)
    sjac(121) = -t(335)
    sjac(122) = -t(34)
    sjac(123) = -t(358)
    sjac(124) = -t(35)
    sjac(125) = -t(360)
    sjac(126) = 0.099*t(22)
    sjac(127) = 0.108*t(35)
    sjac(128) = -t(36) - t(37)
    sjac(129) = -t(349) + 0.108*t(360) + 0.099*t(361)
    sjac(130) = 0.093*t(22)
    sjac(131) = 0.051*t(35)
    sjac(132) = -t(38) - t(39)
    sjac(133) = -t(350) + 0.051*t(360) + 0.093*t(361)
    sjac(134) = 0.187*t(22)
    sjac(135) = 0.207*t(35)
    sjac(136) = -t(40) - t(41)
    sjac(137) = -t(284)
    sjac(138) = -t(341) + 0.207*t(360) + 0.187*t(361)
    sjac(139) = 0.561*t(22)
    sjac(140) = 0.491*t(35)
    sjac(141) = -t(42) - t(43)
    sjac(142) = -t(150)
    sjac(143) = -t(348) + 0.491*t(360) + 0.561*t(361)
    sjac(144) = t(31) + t(32)
    sjac(145) = -t(44)
    sjac(146) = t(68)
    sjac(147) = t(172)
    sjac(148) = t(260)
    sjac(149) = -t(285)
    sjac(150) = -t(45) - t(46)
    sjac(151) = t(164) + t(166)
    sjac(152) = t(175)
    sjac(153) = t(222)
    sjac(154) = -t(337)
    sjac(155) = 0.05*t(22)
    sjac(156) = 0.059*t(35)
    sjac(157) = -t(47) - t(48) - t(49)
    sjac(158) = 0.061*t(103) + 0.042*t(104) + 0.015*t(105)
    sjac(159) = 0.042*t(155)
    sjac(160) = -t(286) + 0.015*t(293)
    sjac(161) = -t(342) + 0.059*t(360) + 0.05*t(361) + 0.061*t(363)
    sjac(162) = 0.017*t(35)
    sjac(163) = -t(50) - t(51)
    sjac(164) = t(69) + t(70)
    sjac(165) = t(171)
    sjac(166) = -t(283)
    sjac(167) = -t(340) + 0.017*t(360)
    sjac(168) = 0.16*t(17)
    sjac(169) = 0.002*t(34)
    sjac(170) = t(37)
    sjac(171) = t(39)
    sjac(172) = t(42) + 1.5*t(43)
    sjac(173) = -t(52)
    sjac(174) = t(53) + t(54) + t(55)
    sjac(175) = 0.5*t(61) + 0.491*t(63)
    sjac(176) = 2.0*t(64) + t(65) + 1.26*t(66) + 1.26*t(67)
    sjac(177) = 0.275*t(72)
    sjac(178) = 0.157*t(87)
    sjac(179) = 0.416*t(90) + 0.45*t(91) + 0.5*t(92) + 0.67*t(94)
    sjac(180) = 0.345*t(96)
    sjac(181) = 0.498*t(100) + 0.572*t(101) + 1.233*t(102) + 0.336*t(99)
    sjac(182) = 0.265*t(104) + 0.012*t(106)
    sjac(183) = 0.475*t(108) + 0.7*t(110)
    sjac(184) = t(112)
    sjac(185) = t(114) + t(115) + t(116) + t(118)
    sjac(186) = 0.491*t(128) + 0.012*t(132)
    sjac(187) = 0.034*t(133) + t(134)
    sjac(188) = 0.45*t(147) + 0.475*t(148) + 0.498*t(149) + 1.5*t(150) + &
        0.5*t(151) + 0.275*t(152) + 0.157*t(153) + 0.345*t(154) + &
        0.265*t(155)
    sjac(189) = t(278) + 1.26*t(281) + t(282) + 0.5*t(287) + 0.572*t(288)
    sjac(190) = -t(323) + t(330) + 0.034*t(332) + 1.26*t(338) + t(339) + &
        0.416*t(343) + 0.336*t(345) + t(348) + 0.16*t(356) + 0.002*t(358)
    sjac(191) = 0.287*t(22)
    sjac(192) = 0.119*t(35)
    sjac(193) = 0.5*t(37)
    sjac(194) = 0.5*t(39)
    sjac(195) = 0.23*t(40)
    sjac(196) = -t(53) - t(54) - t(55)
    sjac(197) = 0.084*t(90) + 0.9*t(91)
    sjac(198) = 0.742*t(100) + 0.008*t(101) + 0.174*t(99)
    sjac(199) = 0.3*t(107) + 0.95*t(108)
    sjac(200) = 0.9*t(147) + 0.95*t(148) + 0.742*t(149)
    sjac(201) = -t(282) + 0.008*t(288)
    sjac(202) = -t(339) + 0.23*t(341) + 0.084*t(343) + 0.3*t(344) + &
        0.174*t(345) + 0.119*t(360) + 0.287*t(361)
    sjac(203) = 0.417*t(17)
    sjac(204) = 0.024*t(18)
    sjac(205) = t(20)
    sjac(206) = 0.072*t(21)
    sjac(207) = 0.452*t(34)
    sjac(208) = -t(56) - t(57)
    sjac(209) = 0.13*t(87)
    sjac(210) = 0.005*t(95) + 0.001*t(96) + 0.024*t(97)
    sjac(211) = 0.127*t(103) + 0.045*t(104) + 0.102*t(105)
    sjac(212) = 0.006*t(119) + 0.02*t(120)
    sjac(213) = 0.13*t(153) + 0.001*t(154) + 0.045*t(155)
    sjac(214) = 0
    sjac(215) = 0.024*t(292) + 0.102*t(293)
    sjac(216) = -t(333) + 0.006*t(347) + 0.417*t(356) + 0.024*t(357) + &
        0.452*t(358) + 0.072*t(359) + 0.005*t(362) + 0.127*t(363)
    sjac(217) = 2.0*t(13)
    sjac(218) = t(41)
    sjac(219) = t(44)
    sjac(220) = t(49)
    sjac(221) = t(51)
    sjac(222) = t(55)
    sjac(223) = -t(58) - t(59)
    sjac(224) = t(67)
    sjac(225) = 0
    sjac(226) = 0.5*t(92)
    sjac(227) = 0.15*t(101)
    sjac(228) = 0
    sjac(229) = 0
    sjac(230) = t(113)
    sjac(231) = t(118)
    sjac(232) = t(135)
    sjac(233) = 0
    sjac(234) = 0.2*t(161)
    sjac(235) = t(253)
    sjac(236) = 0.2*t(268) + t(278) + t(279) + t(280) + t(281) + t(282) + &
        t(283) + t(284) + t(285) + t(286) + 0.5*t(287) + 0.15*t(288)
    sjac(237) = t(320) - t(322)
    sjac(238) = -t(60) - t(61) - t(62) - t(63)
    sjac(239) = -t(128)
    sjac(240) = -t(151)
    sjac(241) = -t(289)
    sjac(242) = -t(352)
    sjac(243) = 0.248*t(17)
    sjac(244) = 0.097*t(22)
    sjac(245) = 0.118*t(35)
    sjac(246) = 0.5*t(37)
    sjac(247) = 0.5*t(39)
    sjac(248) = t(43)
    sjac(249) = 0.23*t(50)
    sjac(250) = 0.009*t(63)
    sjac(251) = -t(64) - t(65) - t(66) - t(67)
    sjac(252) = 0
    sjac(253) = 0.001*t(87)
    sjac(254) = 0.023*t(100) + 0.15*t(99)
    sjac(255) = 0.009*t(128)
    sjac(256) = 0.023*t(149) + t(150) + 0.001*t(153)
    sjac(257) = 0
    sjac(258) = -t(281)
    sjac(259) = -t(338) + 0.23*t(340) + 0.15*t(345) + 0.248*t(356) + &
        0.118*t(360) + 0.097*t(361)
    sjac(260) = 0.24*t(40) + t(41)
    sjac(261) = 0.24*t(50) + t(51)
    sjac(262) = -t(68) - t(69) - t(70)
    sjac(263) = -t(171)
    sjac(264) = t(195)
    sjac(265) = t(210) + t(212) + t(217) + t(218) + 2.0*t(219) + t(220)
    sjac(266) = t(244)
    sjac(267) = -t(260)
    sjac(268) = t(276) + t(283) + t(284)
    sjac(269) = t(304)
    sjac(270) = t(316)
    sjac(271) = 0.24*t(340) + 0.24*t(341)
    sjac(272) = -t(71) - t(72) - t(73) - t(74)
    sjac(273) = -t(129)
    sjac(274) = -t(152)
    sjac(275) = -t(290)
    sjac(276) = -t(353)
    sjac(277) = 0.559*t(18)
    sjac(278) = 0.948*t(21)
    sjac(279) = 0.936*t(34)
    sjac(280) = t(36) + t(37)
    sjac(281) = t(38) + t(39)
    sjac(282) = t(56)
    sjac(283) = 0.079*t(71) + 0.126*t(72) + 0.187*t(73) + 0.24*t(74)
    sjac(284) = -t(75) - t(76) - t(77) - t(78) - t(79) - t(81) - t(82) - &
        t(83) - t(84) - t(85)
    sjac(285) = 0.5*t(86) + 0.729*t(87) + 0.75*t(88)
    sjac(286) = 0.205*t(95) + 0.488*t(97)
    sjac(287) = 0.001*t(103) + 0.137*t(104) + 0.711*t(105)
    sjac(288) = 0.675*t(107)
    sjac(289) = 0.596*t(119) + 0.152*t(120)
    sjac(290) = 0.24*t(129)
    sjac(291) = 0.616*t(136)
    sjac(292) = 0.515*t(139)
    sjac(293) = 0.126*t(152) + 0.729*t(153) + 0.137*t(155)
    sjac(294) = -t(165)
    sjac(295) = -t(179)
    sjac(296) = -t(191) + t(195)
    sjac(297) = -t(203)
    sjac(298) = t(210) + t(212) - t(215) + t(217) + t(218) + 2.0*t(219) + &
        t(220)
    sjac(299) = -t(226)
    sjac(300) = -t(240) + t(244)
    sjac(301) = 0
    sjac(302) = -t(272) + t(276) + 0.187*t(290) + 0.75*t(291) + 0.488*t(292) &
        + 0.711*t(293)
    sjac(303) = -t(300) + t(304)
    sjac(304) = -t(312) + t(316)
    sjac(305) = t(333) + 0.616*t(334) + 0.675*t(344) + 0.596*t(347) + t(349) &
        + t(350) + 0.079*t(353) + 0.5*t(354) + 0.559*t(357) + 0.936*t(358) + &
        0.948*t(359) + 0.205*t(362) + 0.001*t(363)
    sjac(306) = -t(86) - t(87) - t(88) - t(89)
    sjac(307) = -t(130)
    sjac(308) = -t(153)
    sjac(309) = -t(291)
    sjac(310) = -t(354)
    sjac(311) = 0.23*t(71) + 0.39*t(72)
    sjac(312) = -t(90) - t(91) - t(92) - t(93) - t(94)
    sjac(313) = 0.025*t(103) + 0.026*t(104) + 0.012*t(106)
    sjac(314) = -t(126) + 0.012*t(132)
    sjac(315) = -t(147) + 0.39*t(152) + 0.026*t(155)
    sjac(316) = -t(287)
    sjac(317) = -t(343) + 0.23*t(353) + 0.025*t(363)
    sjac(318) = -t(95) - t(96) - t(97) - t(98)
    sjac(319) = -t(131)
    sjac(320) = -t(154)
    sjac(321) = -t(292)
    sjac(322) = -t(362)
    sjac(323) = 0.357*t(71) + 0.936*t(73)
    sjac(324) = -t(100) - t(101) - t(102) - t(99)
    sjac(325) = 0.025*t(103)
    sjac(326) = 0
    sjac(327) = -t(149)
    sjac(328) = -t(288) + 0.936*t(290)
    sjac(329) = -t(345) + 0.357*t(353) + 0.025*t(363)
    sjac(330) = -t(103) - t(104) - t(105) - t(106)
    sjac(331) = -t(132)
    sjac(332) = -t(155)
    sjac(333) = -t(293)
    sjac(334) = -t(363)
    sjac(335) = 0.32*t(71) + 0.16*t(72)
    sjac(336) = 0.019*t(104) + 0.048*t(105)
    sjac(337) = -t(107) - t(108) - t(109) - t(110)
    sjac(338) = -t(127)
    sjac(339) = -t(148) + 0.16*t(152) + 0.019*t(155)
    sjac(340) = 0.048*t(293)
    sjac(341) = -t(344) + 0.32*t(353)
    sjac(342) = t(4)
    sjac(343) = 0.445*t(18)
    sjac(344) = 0.099*t(21)
    sjac(345) = 0.455*t(34)
    sjac(346) = 0.195*t(60) + 0.25*t(63)
    sjac(347) = 0.294*t(95) + 0.154*t(96) + 0.009*t(97)
    sjac(348) = 0.047*t(100) + 0.467*t(102) + 0.129*t(99)
    sjac(349) = 0.732*t(103) + 0.456*t(104) + 0.507*t(105)
    sjac(350) = -t(111) - t(112) - t(113)
    sjac(351) = 0.439*t(119) + 0.431*t(120)
    sjac(352) = 0.25*t(128)
    sjac(353) = 0.034*t(133) + t(134)
    sjac(354) = 0.482*t(136) + t(137)
    sjac(355) = 0.084*t(138) + 0.246*t(139)
    sjac(356) = 0.047*t(149) + 0.154*t(154) + 0.456*t(155)
    sjac(357) = t(194)
    sjac(358) = t(218)
    sjac(359) = t(243)
    sjac(360) = t(275) - t(279) + 0.009*t(292) + 0.507*t(293)
    sjac(361) = t(303)
    sjac(362) = t(307) + t(309) + t(314) + 2.0*t(315) + t(316) + t(317)
    sjac(363) = -t(331) + 0.034*t(332) + 0.482*t(334) + 0.129*t(345) + &
        0.084*t(346) + 0.439*t(347) + 0.195*t(352) + t(355) + 0.445*t(357) + &
        0.455*t(358) + 0.099*t(359) + 0.294*t(362) + 0.732*t(363)
    sjac(364) = 0.039*t(17)
    sjac(365) = 0.026*t(18)
    sjac(366) = 0.026*t(21)
    sjac(367) = 0.35*t(26) + t(27)
    sjac(368) = t(28)
    sjac(369) = t(33)
    sjac(370) = 0.024*t(34)
    sjac(371) = t(56)
    sjac(372) = 1.61*t(60) + t(61) + 0.191*t(63)
    sjac(373) = t(65)
    sjac(374) = 0
    sjac(375) = 0.624*t(71) + 0.592*t(72) + 0.24*t(74)
    sjac(376) = 0.276*t(86) + 0.235*t(87)
    sjac(377) = 0.084*t(90) + 0.2*t(91) + 0.67*t(94)
    sjac(378) = 0.732*t(95) + 0.5*t(96)
    sjac(379) = 0.125*t(100) + 0.227*t(101) + 0.3*t(102) + 0.055*t(99)
    sjac(380) = 0.244*t(103) + 0.269*t(104) + 0.079*t(105)
    sjac(381) = 0.3*t(107) + 0.1*t(108)
    sjac(382) = -t(114) - t(115) - t(116) - t(117) - t(118)
    sjac(383) = 0.01*t(119) + 0.134*t(120)
    sjac(384) = 0.191*t(128) + 0.24*t(129)
    sjac(385) = 0.115*t(136)
    sjac(386) = 0.213*t(138) + 0.506*t(139)
    sjac(387) = 0.2*t(147) + 0.1*t(148) + 0.125*t(149) + t(151) + &
        0.592*t(152) + 0.235*t(153) + 0.5*t(154) + 0.269*t(155)
    sjac(388) = -t(173)
    sjac(389) = 0.75*t(176)
    sjac(390) = t(186) + t(188) + t(189) + t(193) + t(194) + t(195) + &
        2.0*t(196)
    sjac(391) = t(197) + t(199) + t(200) + 2.0*t(201) + 0.75*t(202) + &
        0.75*t(204) + t(205) + t(206) + t(207) + t(208)
    sjac(392) = t(213) + t(220)
    sjac(393) = 0.75*t(224)
    sjac(394) = t(238) + t(245)
    sjac(395) = 0
    sjac(396) = t(270) + t(277) - t(278) + 0.227*t(288) + 0.079*t(293)
    sjac(397) = t(298) + t(305)
    sjac(398) = t(310) + t(317)
    sjac(399) = -t(330) + t(333) + 0.115*t(334) + t(335) + 0.35*t(336) + &
        0.084*t(343) + 0.3*t(344) + 0.055*t(345) + 0.213*t(346) + 0.01*t(347) &
        + 1.61*t(352) + 0.624*t(353) + 0.276*t(354) + 0.039*t(356) + &
        0.026*t(357) + 0.024*t(358) + 0.026*t(359) + 0.732*t(362) + &
        0.244*t(363)
    sjac(400) = t(19)
    sjac(401) = 0.276*t(88)
    sjac(402) = 0.511*t(97)
    sjac(403) = 0.572*t(101)
    sjac(404) = 0.321*t(105)
    sjac(405) = -0.69*t(119) - t(120)
    sjac(406) = 0
    sjac(407) = 0
    sjac(408) = t(174)
    sjac(409) = t(241)
    sjac(410) = t(259)
    sjac(411) = 0.572*t(288) + 0.276*t(291) + 0.511*t(292) + 0.321*t(293)
    sjac(412) = -0.69*t(347)
    sjac(413) = t(3)
    sjac(414) = -t(63)
    sjac(415) = -t(74)
    sjac(416) = -t(89)
    sjac(417) = -t(93)
    sjac(418) = -t(98)
    sjac(419) = -t(106)
    sjac(420) = -t(109)
    sjac(421) = -t(121) - t(122) - t(123) - t(124) - t(125) - t(126) - t(127) &
        - t(128) - t(129) - t(130) - t(131) - t(132)
    sjac(422) = -t(140) + t(143)
    sjac(423) = -t(232)
    sjac(424) = t(247) - t(248) - t(249)
    sjac(425) = t(266)
    sjac(426) = 0
    sjac(427) = 0.155*t(17)
    sjac(428) = 0.122*t(18)
    sjac(429) = 0.204*t(21)
    sjac(430) = 0.244*t(34)
    sjac(431) = t(36)
    sjac(432) = t(38)
    sjac(433) = t(42)
    sjac(434) = t(45) + t(46)
    sjac(435) = t(62)
    sjac(436) = 0.474*t(86) + 0.205*t(87) + 0.474*t(88) + 0.147*t(89)
    sjac(437) = t(93)
    sjac(438) = 0.497*t(95) + 0.363*t(96) + 0.037*t(97) + 0.45*t(98)
    sjac(439) = 0.218*t(101) + 0.013*t(99)
    sjac(440) = 0.511*t(103) + 0.305*t(104) + 0.151*t(105) + 0.069*t(106)
    sjac(441) = 0.675*t(107) + 0.45*t(109)
    sjac(442) = 0.213*t(119) + 0.147*t(120)
    sjac(443) = t(126) + 0.45*t(127) + 0.147*t(130) + 0.45*t(131) + &
        0.069*t(132)
    sjac(444) = -t(133) - t(134) - t(135)
    sjac(445) = 0.37*t(136)
    sjac(446) = 0.558*t(138) + 0.71*t(139)
    sjac(447) = 0.205*t(153) + 0.363*t(154) + 0.305*t(155)
    sjac(448) = 0
    sjac(449) = 0
    sjac(450) = 0
    sjac(451) = 0
    sjac(452) = 0
    sjac(453) = -t(280) + 0.218*t(288) + t(289) + 0.474*t(291) + 0.037*t(292) &
        + 0.151*t(293)
    sjac(454) = -t(332) + 0.37*t(334) + t(337) + 0.675*t(344) + 0.013*t(345) &
        + 0.558*t(346) + 0.213*t(347) + t(348) + t(349) + t(350) + &
        0.474*t(354) + 0.155*t(356) + 0.122*t(357) + 0.244*t(358) + &
        0.204*t(359) + 0.497*t(362) + 0.511*t(363)
    sjac(455) = 0.332*t(18)
    sjac(456) = 0.089*t(21)
    sjac(457) = 0.11*t(34)
    sjac(458) = 0.416*t(90)
    sjac(459) = 0.437*t(98)
    sjac(460) = 0.21*t(100) + 0.233*t(102) + 0.15*t(99)
    sjac(461) = 0.072*t(103) + 0.026*t(104) + 0.001*t(105) + 0.659*t(106)
    sjac(462) = 0.55*t(109)
    sjac(463) = 0.177*t(119) + 0.243*t(120)
    sjac(464) = 0.55*t(127) + 0.437*t(131) + 0.659*t(132)
    sjac(465) = -t(136) - t(137)
    sjac(466) = 0.115*t(138)
    sjac(467) = 0.21*t(149) + 0.026*t(155)
    sjac(468) = 0.5*t(176) + t(177) + 0.5*t(178) + t(180)
    sjac(469) = 0.5*t(204)
    sjac(470) = 0.5*t(227)
    sjac(471) = 0
    sjac(472) = 0
    sjac(473) = t(273) + 0.001*t(293)
    sjac(474) = -t(334) + 0.416*t(343) + 0.15*t(345) + 0.115*t(346) + &
        0.177*t(347) + 0.332*t(357) + 0.11*t(358) + 0.089*t(359) + &
        0.072*t(363)
    sjac(475) = 0.417*t(21)
    sjac(476) = 0.125*t(34)
    sjac(477) = 0.055*t(35)
    sjac(478) = 0.1*t(72) + 0.75*t(74)
    sjac(479) = 0.276*t(86) + 0.276*t(87) + 0.853*t(89)
    sjac(480) = 0.119*t(95) + 0.215*t(96) + 0.113*t(98)
    sjac(481) = 0.332*t(99)
    sjac(482) = 0.043*t(104) + 0.259*t(106)
    sjac(483) = 0.7*t(110)
    sjac(484) = 0.048*t(119) + 0.435*t(120)
    sjac(485) = 0.75*t(129) + 0.853*t(130) + 0.113*t(131) + 0.259*t(132)
    sjac(486) = -0.671*t(138) - t(139)
    sjac(487) = 0.1*t(152) + 0.276*t(153) + 0.215*t(154) + 0.043*t(155)
    sjac(488) = 0.5*t(176) + 0.5*t(178) + t(180) + t(181) + t(182) + t(183)
    sjac(489) = 0.5*t(204)
    sjac(490) = t(216)
    sjac(491) = 0.5*t(227)
    sjac(492) = 0
    sjac(493) = 0
    sjac(494) = 0
    sjac(495) = t(301)
    sjac(496) = t(313)
    sjac(497) = 0.332*t(345) - 0.671*t(346) + 0.048*t(347) + 0.276*t(354) + &
        0.125*t(358) + 0.417*t(359) + 0.055*t(360) + 0.119*t(362)
    sjac(498) = -t(43)
    sjac(499) = -t(61)
    sjac(500) = -t(72)
    sjac(501) = -t(87)
    sjac(502) = -t(91)
    sjac(503) = -t(96)
    sjac(504) = -t(100)
    sjac(505) = -t(104)
    sjac(506) = -t(108)
    sjac(507) = t(121) - t(122)
    sjac(508) = -t(140) - t(141) - t(142) - t(143) - t(144) - t(145) - t(146) &
        - t(147) - t(148) - t(149) - t(150) - t(151) - t(152) - t(153) - &
        t(154) - t(155)
    sjac(509) = -t(158) + 0.25*t(167) + 0.25*t(168) + 0.25*t(169) + &
        0.25*t(170)
    sjac(510) = 0.25*t(187)
    sjac(511) = 0.25*t(211)
    sjac(512) = -t(233)
    sjac(513) = -t(250)
    sjac(514) = 0
    sjac(515) = 0.25*t(296)
    sjac(516) = 0.25*t(308)
    sjac(517) = -t(324)
    sjac(518) = t(1)
    sjac(519) = t(11)
    sjac(520) = t(15)
    sjac(521) = 0.121*t(17)
    sjac(522) = 0.187*t(22)
    sjac(523) = t(23) + 0.61*t(24)
    sjac(524) = t(27)
    sjac(525) = t(28) + t(29)
    sjac(526) = -t(31)
    sjac(527) = t(33)
    sjac(528) = 0.224*t(35)
    sjac(529) = 0.5*t(37)
    sjac(530) = 0.5*t(39)
    sjac(531) = 1.5*t(43)
    sjac(532) = 0
    sjac(533) = t(46)
    sjac(534) = t(52)
    sjac(535) = t(53)
    sjac(536) = 0.12*t(61) + 0.5*t(63)
    sjac(537) = 2.0*t(64) + 0.63*t(66) + 0.63*t(67)
    sjac(538) = -t(69)
    sjac(539) = 0
    sjac(540) = 0.033*t(87)
    sjac(541) = 0.008*t(91) + 0.34*t(94)
    sjac(542) = 0.056*t(96)
    sjac(543) = 0.4*t(100) + 1.233*t(102)
    sjac(544) = 0.003*t(104) + 0.013*t(106)
    sjac(545) = 0.064*t(108)
    sjac(546) = t(112)
    sjac(547) = 2.0*t(114) + t(116) - t(117) + t(118)
    sjac(548) = 0.113*t(119) + 0.341*t(120)
    sjac(549) = 0.5*t(128) + 0.013*t(132)
    sjac(550) = t(134)
    sjac(551) = 0
    sjac(552) = 0.379*t(138)
    sjac(553) = t(145) - t(146) + 0.008*t(147) + 0.064*t(148) + 0.4*t(149) + &
        1.5*t(150) + 0.12*t(151) + 0.033*t(153) + 0.056*t(154) + 0.003*t(155)
    sjac(554) = -t(156) - t(157) - t(158) - 2.0*t(159) - 2.0*t(160) - t(161) &
        - t(162) - t(163) - t(164) - t(166) - t(167) - t(168) - t(169) - &
        t(170) - t(171) - t(172) - t(173)
    sjac(555) = -t(175) + t(176) + t(177) + t(178) + t(180)
    sjac(556) = -t(187)
    sjac(557) = t(197) - t(198) + t(199) + 2.0*t(201) + t(202) + t(204)
    sjac(558) = -t(211)
    sjac(559) = t(221) - t(222) + t(223) + t(224) + t(225) + t(227)
    sjac(560) = -t(237) + t(238) + t(239) + t(246)
    sjac(561) = -t(254)
    sjac(562) = t(267) - t(268) + t(270) + t(271) + t(273) + t(278) + &
        0.63*t(281)
    sjac(563) = -t(296)
    sjac(564) = -t(308)
    sjac(565) = t(321) + t(323) + t(324) + t(326) - t(327) + t(328) + t(329) &
        + t(330) + t(335) + 0.63*t(338) + 0.379*t(346) + 0.113*t(347) + &
        0.121*t(356) + 0.224*t(360) + 0.187*t(361)
    sjac(566) = 0.021*t(17)
    sjac(567) = 0.07*t(18)
    sjac(568) = 0.347*t(21)
    sjac(569) = 0.009*t(22)
    sjac(570) = 0.143*t(34)
    sjac(571) = 0.011*t(35)
    sjac(572) = 0.093*t(71) + 0.008*t(72) + 0.064*t(73) + 0.01*t(74)
    sjac(573) = 0.25*t(86) + 0.18*t(87) + 0.25*t(88)
    sjac(574) = 0.09*t(95) + 0.001*t(96) + 0.176*t(97)
    sjac(575) = 0.051*t(101) + 0.041*t(99)
    sjac(576) = 0.082*t(103) + 0.002*t(104) + 0.136*t(105) + 0.001*t(106)
    sjac(577) = 0.025*t(107)
    sjac(578) = 0.173*t(119) + 0.095*t(120)
    sjac(579) = 0.01*t(129) + 0.001*t(132)
    sjac(580) = 0.001*t(133)
    sjac(581) = 0.042*t(136)
    sjac(582) = 0.07*t(138) + 0.04*t(139)
    sjac(583) = 0.008*t(152) + 0.18*t(153) + 0.001*t(154) + 0.002*t(155)
    sjac(584) = -t(166)
    sjac(585) = -t(174) - t(175) - t(176) - t(177) - t(178) - 2.0*t(180) - &
        t(181) - t(182) - t(183) - t(184)
    sjac(586) = -t(192)
    sjac(587) = -t(204)
    sjac(588) = -t(216)
    sjac(589) = -t(227)
    sjac(590) = -t(241)
    sjac(591) = 0
    sjac(592) = -t(273) + 0.051*t(288) + 0.064*t(290) + 0.25*t(291) + &
        0.176*t(292) + 0.136*t(293)
    sjac(593) = -t(301)
    sjac(594) = -t(313)
    sjac(595) = 0.001*t(332) + 0.042*t(334) + 0.025*t(344) + 0.041*t(345) + &
        0.07*t(346) + 0.173*t(347) + 0.093*t(353) + 0.25*t(354) + &
        0.021*t(356) + 0.07*t(357) + 0.143*t(358) + 0.347*t(359) + &
        0.011*t(360) + 0.009*t(361) + 0.09*t(362) + 0.082*t(363)
    sjac(596) = t(9)
    sjac(597) = 0.192*t(72) + 0.24*t(74)
    sjac(598) = 0.5*t(90) + 0.5*t(92) + 0.33*t(94)
    sjac(599) = 0.15*t(101) + 0.289*t(99)
    sjac(600) = 0
    sjac(601) = 0.3*t(110)
    sjac(602) = 0.24*t(129)
    sjac(603) = 0.192*t(152)
    sjac(604) = -t(170)
    sjac(605) = -t(184)
    sjac(606) = -t(185) - t(186) - t(187) - t(188) - t(189) - t(190) - t(192) &
        - t(193) - t(194) - t(195) - 2.0*t(196)
    sjac(607) = -t(208)
    sjac(608) = -t(220)
    sjac(609) = -t(231)
    sjac(610) = -t(245)
    sjac(611) = -t(258)
    sjac(612) = -t(277) + 0.5*t(287) + 0.15*t(288)
    sjac(613) = -t(305)
    sjac(614) = -t(317)
    sjac(615) = 0.5*t(343) + 0.289*t(345)
    sjac(616) = t(20)
    sjac(617) = 0.65*t(26)
    sjac(618) = 0.011*t(34)
    sjac(619) = t(57)
    sjac(620) = 0.3*t(63)
    sjac(621) = 0.25*t(74)
    sjac(622) = 0
    sjac(623) = 0.076*t(96)
    sjac(624) = 0.197*t(104) + 0.03*t(105)
    sjac(625) = 0.3*t(110)
    sjac(626) = t(112)
    sjac(627) = 0
    sjac(628) = 0.3*t(128) + 0.25*t(129)
    sjac(629) = 0
    sjac(630) = 0
    sjac(631) = 0
    sjac(632) = 0.076*t(154) + 0.197*t(155)
    sjac(633) = -t(163)
    sjac(634) = -t(176)
    sjac(635) = -t(189) + t(193)
    sjac(636) = -t(197) - t(198) - t(199) - 2.0*t(200) - 2.0*t(201) - t(202) &
        - t(204) - t(205) - t(206) - t(207) - t(208)
    sjac(637) = -t(213) + t(217)
    sjac(638) = -t(224)
    sjac(639) = -t(238) + t(242)
    sjac(640) = 0
    sjac(641) = -t(270) + t(274) + 0.03*t(293)
    sjac(642) = t(295) + t(297) - t(298) + 2.0*t(302) + t(303) + t(304) + &
        t(305)
    sjac(643) = -t(310) + t(314)
    sjac(644) = 0.65*t(336) + t(351) + 0.011*t(358)
    sjac(645) = t(8)
    sjac(646) = t(47) + t(49)
    sjac(647) = 0
    sjac(648) = 0
    sjac(649) = 0
    sjac(650) = -t(169)
    sjac(651) = -t(183)
    sjac(652) = -t(195)
    sjac(653) = -t(207)
    sjac(654) = -t(209) - t(210) - t(211) - t(212) - t(213) - t(214) - t(216) &
        - t(217) - t(218) - 2.0*t(219) - t(220)
    sjac(655) = -t(230)
    sjac(656) = -t(244)
    sjac(657) = -t(257)
    sjac(658) = -t(276) + t(286)
    sjac(659) = -t(304)
    sjac(660) = -t(316)
    sjac(661) = t(342)
    sjac(662) = t(4)
    sjac(663) = 0.612*t(17)
    sjac(664) = 0.695*t(18)
    sjac(665) = 0.653*t(21)
    sjac(666) = 0.804*t(22)
    sjac(667) = 0.835*t(34)
    sjac(668) = 0.765*t(35)
    sjac(669) = t(37)
    sjac(670) = t(39)
    sjac(671) = 0.76*t(40)
    sjac(672) = t(42)
    sjac(673) = 0.34*t(45)
    sjac(674) = 0.76*t(50)
    sjac(675) = t(60) + t(62) + 0.2*t(63)
    sjac(676) = 0
    sjac(677) = 0.907*t(71) + 0.066*t(72) + 0.749*t(73)
    sjac(678) = 0.75*t(86) + 0.031*t(87) + 0.276*t(88)
    sjac(679) = 0.5*t(90) + 0.1*t(91) + 0.5*t(92) + 0.33*t(94)
    sjac(680) = 0.91*t(95) + 0.022*t(96) + 0.824*t(97)
    sjac(681) = 0.048*t(100) + 0.799*t(101) + 0.67*t(99)
    sjac(682) = 0.918*t(103) + 0.033*t(104) + 0.442*t(105) + 0.012*t(106)
    sjac(683) = 0.3*t(107) + 0.05*t(108)
    sjac(684) = 0.376*t(119) + 0.564*t(120)
    sjac(685) = 0.2*t(128) + 0.012*t(132)
    sjac(686) = 0.034*t(133) + t(134)
    sjac(687) = 0.37*t(136) + t(137)
    sjac(688) = 0.473*t(138) + 0.96*t(139)
    sjac(689) = 0.1*t(147) + 0.05*t(148) + 0.048*t(149) + 0.066*t(152) + &
        0.031*t(153) + 0.022*t(154) + 0.033*t(155)
    sjac(690) = -t(164)
    sjac(691) = -t(178)
    sjac(692) = -t(190) + t(194)
    sjac(693) = -t(202)
    sjac(694) = -t(214) + t(218)
    sjac(695) = -t(221) - t(222) - t(223) - t(224) - 2.0*t(225) - t(227) - &
        t(228) - t(229) - t(230) - t(231)
    sjac(696) = -t(239) + t(243)
    sjac(697) = 0
    sjac(698) = -t(271) + t(275) + 0.5*t(287) + 0.799*t(288) + t(289) + &
        0.749*t(290) + 0.276*t(291) + 0.824*t(292) + 0.442*t(293)
    sjac(699) = -t(299) + t(303)
    sjac(700) = t(307) + t(309) - t(311) + t(314) + 2.0*t(315) + t(316) + &
        t(317)
    sjac(701) = 0.034*t(332) + 0.37*t(334) + 0.34*t(337) + 0.76*t(340) + &
        0.76*t(341) + 0.5*t(343) + 0.3*t(344) + 0.67*t(345) + 0.473*t(346) + &
        0.376*t(347) + t(348) + t(352) + 0.907*t(353) + 0.75*t(354) + t(355) &
        + 0.612*t(356) + 0.695*t(357) + 0.835*t(358) + 0.653*t(359) + &
        0.765*t(360) + 0.804*t(361) + 0.91*t(362) + 0.918*t(363)
    sjac(702) = t(14)
    sjac(703) = -t(29)
    sjac(704) = -t(75)
    sjac(705) = 0
    sjac(706) = 0
    sjac(707) = 0
    sjac(708) = 0
    sjac(709) = 0
    sjac(710) = 0
    sjac(711) = -t(123) + t(124)
    sjac(712) = 0
    sjac(713) = 0
    sjac(714) = -t(141)
    sjac(715) = -t(156)
    sjac(716) = -t(174)
    sjac(717) = -t(186)
    sjac(718) = -t(197)
    sjac(719) = -t(210)
    sjac(720) = -t(221)
    sjac(721) = -t(232) - t(233) - t(234) - 2.0*t(235) - t(236) - t(237) - &
        t(238) - t(239) - t(240) - t(241) - t(242) - t(243) - t(244) - t(245) &
        - t(246)
    sjac(722) = t(247) + t(248) + t(252)
    sjac(723) = -t(262) + t(264) + t(265)
    sjac(724) = -t(295)
    sjac(725) = -t(307)
    sjac(726) = -t(318)
    sjac(727) = t(6)
    sjac(728) = t(7)
    sjac(729) = t(8)
    sjac(730) = t(9)
    sjac(731) = t(12)
    sjac(732) = t(15) + t(16)
    sjac(733) = -t(19)
    sjac(734) = t(23) + 0.61*t(24) + t(25)
    sjac(735) = t(29)
    sjac(736) = -t(30)
    sjac(737) = 0
    sjac(738) = t(59)
    sjac(739) = 0
    sjac(740) = -t(68)
    sjac(741) = 0.187*t(73)
    sjac(742) = t(75) + t(77)
    sjac(743) = 0.474*t(88)
    sjac(744) = 0
    sjac(745) = 0
    sjac(746) = 0
    sjac(747) = 0.391*t(105)
    sjac(748) = 0
    sjac(749) = 0
    sjac(750) = 0
    sjac(751) = 0.338*t(119) + t(120)
    sjac(752) = t(123) - t(124) - t(125)
    sjac(753) = 0
    sjac(754) = 0
    sjac(755) = 0
    sjac(756) = t(141) - t(142)
    sjac(757) = t(156) - t(157) + 0.8*t(161)
    sjac(758) = t(177)
    sjac(759) = -t(185) + t(186) + t(188)
    sjac(760) = t(197) + t(199)
    sjac(761) = -t(209) + t(210) + t(212)
    sjac(762) = t(221) + t(223)
    sjac(763) = t(232) + t(233) + 2.0*t(234) + 2.0*t(235) + t(237) + t(238) + &
        t(239) + t(240) + t(242) + t(243) + t(244) + t(245) + t(246)
    sjac(764) = -t(247) - t(248) - t(249) - t(250) - t(251) - t(253) - t(254) &
        - t(255) - t(256) - t(257) - t(258) - t(259) - t(260) - t(261)
    sjac(765) = 2.0*t(262) - t(263) + t(266) + t(267) + 0.8*t(268) + &
        2.0*t(269) + t(270) + t(271) + t(272) + t(273) + t(274) + t(275) + &
        t(276) + t(277) + 0.187*t(290) + 0.474*t(291) + 0.391*t(293)
    sjac(766) = -t(294) + t(295) + t(297)
    sjac(767) = -t(306) + t(307) + t(309)
    sjac(768) = t(319) - t(320) + t(321) + t(325) + 0.338*t(347)
    sjac(769) = t(12)
    sjac(770) = 0.39*t(24)
    sjac(771) = -t(41)
    sjac(772) = -t(44)
    sjac(773) = -t(49)
    sjac(774) = -t(51)
    sjac(775) = -t(55)
    sjac(776) = t(58)
    sjac(777) = -t(62)
    sjac(778) = -t(67)
    sjac(779) = 0
    sjac(780) = -t(73)
    sjac(781) = -t(77)
    sjac(782) = -t(88)
    sjac(783) = -t(92)
    sjac(784) = -t(97)
    sjac(785) = -t(101)
    sjac(786) = -t(105)
    sjac(787) = 0
    sjac(788) = -t(113)
    sjac(789) = -t(118)
    sjac(790) = 0
    sjac(791) = t(125)
    sjac(792) = -t(135)
    sjac(793) = 0
    sjac(794) = 0
    sjac(795) = t(142)
    sjac(796) = -t(161)
    sjac(797) = -t(177)
    sjac(798) = -t(188)
    sjac(799) = -t(199)
    sjac(800) = -t(212)
    sjac(801) = -t(223)
    sjac(802) = -t(234)
    sjac(803) = t(249) + t(250) - t(251) - t(252)
    sjac(804) = -t(262) - t(263) - t(264) - t(265) - t(266) - t(267) - t(268) &
        - 2.0*t(269) - t(270) - t(271) - t(272) - t(273) - t(274) - t(275) - &
        t(276) - t(277) - t(278) - t(279) - t(280) - t(281) - t(282) - t(283) &
        - t(284) - t(285) - t(286) - t(287) - t(288) - t(289) - t(290) - &
        t(291) - t(292) - t(293)
    sjac(805) = -t(297)
    sjac(806) = -t(309)
    sjac(807) = -t(321) + t(322)
    sjac(808) = 2.0*t(5)
    sjac(809) = t(6)
    sjac(810) = 0
    sjac(811) = 0.011*t(34)
    sjac(812) = t(36) + 0.5*t(37)
    sjac(813) = t(38) + 0.5*t(39)
    sjac(814) = t(53) + t(54) + t(55)
    sjac(815) = t(56) + t(57)
    sjac(816) = 0.123*t(87)
    sjac(817) = 0.67*t(94)
    sjac(818) = 0
    sjac(819) = 0.467*t(102)
    sjac(820) = 0.137*t(104)
    sjac(821) = 0.675*t(107)
    sjac(822) = t(111) + t(113)
    sjac(823) = 0
    sjac(824) = 0
    sjac(825) = 0
    sjac(826) = 0.492*t(136) + t(137)
    sjac(827) = 0.029*t(138) + 0.667*t(139)
    sjac(828) = 0.123*t(153) + 0.137*t(155)
    sjac(829) = -t(167)
    sjac(830) = -t(181)
    sjac(831) = t(186) + t(188) + t(194) + t(195) + 2.0*t(196)
    sjac(832) = -t(205)
    sjac(833) = -t(217) + t(220)
    sjac(834) = -t(228)
    sjac(835) = -t(242) + t(245)
    sjac(836) = -t(255)
    sjac(837) = -t(274) + t(277) + t(279) + t(282)
    sjac(838) = -t(294) - t(295) - t(296) - t(297) - t(298) - t(299) - t(301) &
        - 2.0*t(302) - t(303) - t(304)
    sjac(839) = -t(314) + t(317)
    sjac(840) = t(331) + t(333) + 0.492*t(334) + t(339) + 0.675*t(344) + &
        0.029*t(346) + t(349) + t(350) + 0.011*t(358)
    sjac(841) = t(7)
    sjac(842) = 0.37*t(66) + 0.37*t(67)
    sjac(843) = 0
    sjac(844) = 0.201*t(87)
    sjac(845) = 0.1*t(91)
    sjac(846) = 0.048*t(100) + 0.3*t(102)
    sjac(847) = 0.006*t(104)
    sjac(848) = 0.05*t(108)
    sjac(849) = 0
    sjac(850) = 0.965*t(133) + t(135)
    sjac(851) = 0.096*t(136)
    sjac(852) = 0.049*t(138) + 0.333*t(139)
    sjac(853) = 0.1*t(147) + 0.05*t(148) + 0.048*t(149) + 0.201*t(153) + &
        0.006*t(155)
    sjac(854) = -t(168)
    sjac(855) = -t(182)
    sjac(856) = -t(194)
    sjac(857) = -t(206)
    sjac(858) = -t(218)
    sjac(859) = -t(229)
    sjac(860) = -t(243)
    sjac(861) = -t(256)
    sjac(862) = -t(275) + t(280) + 0.37*t(281)
    sjac(863) = -t(303)
    sjac(864) = -t(306) - t(307) - t(308) - t(309) - t(310) - t(311) - t(313) &
        - t(314) - 2.0*t(315) - t(316) - t(317)
    sjac(865) = 0.965*t(332) + 0.096*t(334) + 0.37*t(338) + 0.049*t(346)
    sjac(866) = -t(1)
    sjac(867) = 2.0*t(2)
    sjac(868) = -t(4)
    sjac(869) = 2.0*t(10) - t(11)
    sjac(870) = t(14) - t(16)
    sjac(871) = -0.754*t(17)
    sjac(872) = -t(18)
    sjac(873) = -t(21)
    sjac(874) = -t(22)
    sjac(875) = 0.39*t(24) - t(25)
    sjac(876) = -0.65*t(26) + t(27)
    sjac(877) = -t(33)
    sjac(878) = -t(34)
    sjac(879) = -t(35)
    sjac(880) = -t(36)
    sjac(881) = -t(38)
    sjac(882) = -t(40)
    sjac(883) = -t(42) + 0.5*t(43)
    sjac(884) = -0.34*t(45) + t(46)
    sjac(885) = -t(47)
    sjac(886) = -t(50)
    sjac(887) = -t(52)
    sjac(888) = -t(54)
    sjac(889) = -t(56)
    sjac(890) = -t(58) + t(59)
    sjac(891) = -t(60) + 0.12*t(61)
    sjac(892) = -t(66)
    sjac(893) = 0
    sjac(894) = -t(71) + 0.266*t(72)
    sjac(895) = -t(86) + 0.567*t(87)
    sjac(896) = -t(90) + 0.208*t(91) + 0.33*t(94)
    sjac(897) = -t(95) + 0.155*t(96)
    sjac(898) = 0.285*t(100) - t(99)
    sjac(899) = -t(103) + 0.378*t(104)
    sjac(900) = -t(107) + 0.164*t(108)
    sjac(901) = -t(111)
    sjac(902) = -t(116)
    sjac(903) = -t(119)
    sjac(904) = 0
    sjac(905) = -t(133)
    sjac(906) = -t(136)
    sjac(907) = -t(138)
    sjac(908) = -t(145) + t(146) + 0.208*t(147) + 0.164*t(148) + 0.285*t(149) &
        + 0.5*t(150) + 0.12*t(151) + 0.266*t(152) + 0.567*t(153) + &
        0.155*t(154) + 0.378*t(155)
    sjac(909) = t(156) + t(158) + 0.8*t(161) - t(162)
    sjac(910) = 0
    sjac(911) = 0
    sjac(912) = 0
    sjac(913) = 0
    sjac(914) = 0
    sjac(915) = -t(236) + t(237)
    sjac(916) = -t(253)
    sjac(917) = -t(267) + 0.8*t(268)
    sjac(918) = 0
    sjac(919) = 0
    sjac(920) = -t(318) - t(319) - t(320) - t(321) - t(322) - t(323) - t(324) &
        - t(325) - t(326) - t(327) - t(328) - t(329) - t(330) - t(331) - &
        t(332) - t(333) - t(334) - t(335) - 0.65*t(336) - 0.34*t(337) - &
        t(338) - t(339) - t(340) - t(341) - t(342) - t(343) - t(344) - t(345) &
        - t(346) - t(347) - t(348) - t(349) - t(350) - t(351) - t(352) - &
        t(353) - t(354) - t(355) - 0.754*t(356) - t(357) - t(358) - t(359) - &
        t(360) - t(361) - t(362) - t(363)

  END SUBROUTINE Jac



END MODULE saprc99_jacobian
!------------------------ END saprc99_jacobian.f90 END -----------------------
