!--------------------- BEGIN saprc99_integrate.f90 BEGIN ---------------------
! @file saprc99_integrate.f90                                                 
! @author jlinford                                                            
! @date 2017-02-27 17:42:47.144710                                            
! @brief Interface to time stepping integrator                                
!                                                                             
! Definitions of interface functions for the Kppa-generated                   
! time stepping integrator.  These are the Kppa "entry point" routines.       
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_integrate

  USE saprc99_parameters
  USE saprc99_shuffle
  USE saprc99_rosenbrock

  IMPLICIT NONE




  CONTAINS

!------------------------------- GridIntegrate -------------------------------
! Applies the Kppa-generated integrator to the grid                           
!                                                                             
! @param[in]     ncells Number of grid cells                                  
! @param[in,out] conc   Species concentrations                                
! @param[in]     tstart Integration start time                                
! @param[in]     tend   Integration end time                                  
! @param[in]     abstol Absolute integration tolerances for variable species  
! @param[in]     reltol Relative integration tolerances for variable species  
! @param[in,out] idata  Integer integration in/out parameters                 
! @param[in,out] rdata  Real value integration in/out parameters              
!-----------------------------------------------------------------------------
  INTEGER FUNCTION GridIntegrate(ncells, conc, tstart, tend, abstol, reltol, &
      idata, rdata)
    IMPLICIT NONE

    INTEGER, INTENT(IN) :: ncells
    REAL(8), INTENT(INOUT) :: conc(NSPEC*ncells)
    REAL(8), INTENT(IN) :: tstart
    REAL(8), INTENT(IN) :: tend
    REAL(8), INTENT(IN) :: abstol(NVAR)
    REAL(8), INTENT(IN) :: reltol(NVAR)
    INTEGER, INTENT(INOUT) :: idata(20)
    REAL(8), INTENT(INOUT) :: rdata(20)

    ! Variable concentrations in Kppa order 
    REAL(8) :: var(NVAR)
    ! Fixed concentrations in Kppa order 
    REAL(8) :: fix(NFIX)
    ! Return value 
    INTEGER :: retval
    ! Iterator
    INTEGER :: i

    retval = 0
    DO i = 1, ncells

        CALL user2kppa(conc((i-1)*NSPEC+1:i*NSPEC), var, fix)
        CALL Integrate(var, fix, i, tstart, tend, &
                       abstol, reltol, idata, rdata)
        CALL kppa2user(var, fix, conc((i-1)*NSPEC+1:i*NSPEC))

        ! Save the last timestep for future use
        rdata(3) = rdata(12)

        ! Process integrator return code
        IF (idata(20) < 0) THEN
            WRITE(*,*) "Kppa: CELL",i,"-- INTEGRATION FAILED"
            WRITE(*,*) "Kppa: CELL",i,"idata=",idata
            WRITE(*,*) "Kppa: CELL",i,"rdata=",rdata
            retval = MIN(idata(20), retval)
        ELSE IF (idata(20) > 0) THEN
            WRITE(*,*) "Kppa: CELL",i,"-- INTEGRATION COMPLETED WITH WARNING"
            IF (retval >= 0 .AND. idata(20) > retval) THEN
                retval = idata(20)
            END IF
        END IF
    END DO
    
    GridIntegrate = retval
    RETURN
  END FUNCTION GridIntegrate


END MODULE saprc99_integrate
!----------------------- END saprc99_integrate.f90 END -----------------------
