!--------------------- BEGIN saprc99_initialize.f90 BEGIN --------------------
! @file saprc99_initialize.f90                                                
! @author jlinford                                                            
! @date 2017-02-27 17:42:47.179127                                            
! @brief Species concentration initialization                                 
!                                                                             
! Species concentration initialization                                        
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_initialize

  USE saprc99_parameters
  USE saprc99_shuffle

  IMPLICIT NONE





  CONTAINS

!--------------------------------- Initialize --------------------------------
! Species concentration initialization.                                       
! Concentrations are usually supplied by the model from input data            
! or other calculations, not specified directly as done here.                 
!                                                                             
! @param[in,out] var Variable species concentrations                          
! @param[in,out] fix Fixed species concentrations                             
!-----------------------------------------------------------------------------
  SUBROUTINE Initialize(var, fix)
    IMPLICIT NONE

    REAL(8), INTENT(INOUT) :: var(74)
    REAL(8), INTENT(INOUT) :: fix(5)

    ! Variable species initialization 
    var(1) = CFACTOR*VAR_DEFAULT
    var(2) = 0.000677*CFACTOR
    var(3) = 0.00116*CFACTOR
    var(4) = 0.000392*CFACTOR
    var(5) = CFACTOR*VAR_DEFAULT
    var(6) = CFACTOR*VAR_DEFAULT
    var(7) = CFACTOR*VAR_DEFAULT
    var(8) = 0.2*CFACTOR
    var(9) = 0.05*CFACTOR
    var(10) = CFACTOR*VAR_DEFAULT
    var(11) = 0.01167*CFACTOR
    var(12) = CFACTOR*VAR_DEFAULT
    var(13) = CFACTOR*VAR_DEFAULT
    var(14) = CFACTOR*VAR_DEFAULT
    var(15) = CFACTOR*VAR_DEFAULT
    var(16) = CFACTOR*VAR_DEFAULT
    var(17) = CFACTOR*VAR_DEFAULT
    var(18) = CFACTOR*VAR_DEFAULT
    var(19) = 0.001*CFACTOR
    var(20) = 0.0188*CFACTOR
    var(21) = 0.0469*CFACTOR
    var(22) = CFACTOR*VAR_DEFAULT
    var(23) = 0.0306*CFACTOR
    var(24) = 0.00874*CFACTOR
    var(25) = CFACTOR*VAR_DEFAULT
    var(26) = CFACTOR*VAR_DEFAULT
    var(27) = CFACTOR*VAR_DEFAULT
    var(28) = CFACTOR*VAR_DEFAULT
    var(29) = 0.00589*CFACTOR
    var(30) = 0.0417*CFACTOR
    var(31) = 0.0118*CFACTOR
    var(32) = CFACTOR*VAR_DEFAULT
    var(33) = CFACTOR*VAR_DEFAULT
    var(34) = 0.00056*CFACTOR
    var(35) = CFACTOR*VAR_DEFAULT
    var(36) = CFACTOR*VAR_DEFAULT
    var(37) = CFACTOR*VAR_DEFAULT
    var(38) = 7.51e-5*CFACTOR
    var(39) = 0.000606*CFACTOR
    var(40) = CFACTOR*VAR_DEFAULT
    var(41) = 8.37e-5*CFACTOR
    var(42) = 0.00507*CFACTOR
    var(43) = CFACTOR*VAR_DEFAULT
    var(44) = 0.0189*CFACTOR
    var(45) = 0.000121*CFACTOR
    var(46) = CFACTOR*VAR_DEFAULT
    var(47) = 0.000433*CFACTOR
    var(48) = CFACTOR*VAR_DEFAULT
    var(49) = 0.00082*CFACTOR
    var(50) = 0.0013*CFACTOR
    var(51) = 0.0104*CFACTOR
    var(52) = 8.93e-5*CFACTOR
    var(53) = 0.00797*CFACTOR
    var(54) = CFACTOR*VAR_DEFAULT
    var(55) = 0.002316*CFACTOR
    var(56) = 0.01121*CFACTOR
    var(57) = CFACTOR*VAR_DEFAULT
    var(58) = 7.843e-9*CFACTOR
    var(59) = 0.00172*CFACTOR
    var(60) = 0.00326*CFACTOR
    var(61) = 0.00193*CFACTOR
    var(62) = CFACTOR*VAR_DEFAULT
    var(63) = CFACTOR*VAR_DEFAULT
    var(64) = CFACTOR*VAR_DEFAULT
    var(65) = CFACTOR*VAR_DEFAULT
    var(66) = CFACTOR*VAR_DEFAULT
    var(67) = CFACTOR*VAR_DEFAULT
    var(68) = CFACTOR*VAR_DEFAULT
    var(69) = 0.1*CFACTOR
    var(70) = 0.05*CFACTOR
    var(71) = CFACTOR*VAR_DEFAULT
    var(72) = CFACTOR*VAR_DEFAULT
    var(73) = CFACTOR*VAR_DEFAULT
    var(74) = CFACTOR*VAR_DEFAULT

    ! Fixed species initialization 
    fix(1) = 1000000.0*CFACTOR
    fix(2) = 209000.0*CFACTOR
    fix(3) = 20000.0*CFACTOR
    fix(4) = CFACTOR*FIX_DEFAULT
    fix(5) = CFACTOR
  END SUBROUTINE Initialize


END MODULE saprc99_initialize
!----------------------- END saprc99_initialize.f90 END ----------------------
