!----------------------- BEGIN saprc99_sparse.f90 BEGIN ----------------------
! @file saprc99_sparse.f90                                                    
! @author jlinford                                                            
! @date 2017-02-27 19:38:46.382273                                            
! @brief Data and utilities for row-compressed sparse matrices                
!                                                                             
! The following matrices are represented here in row-compressed form:         
! @li The Jacobian                                                            
! @li The LU decomposition of the Jacobian                                    
! @li The stoichiometric matrix                                               
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_sparse


  IMPLICIT NONE



  ! Number of nonzero entries in the Jacobian 
  INTEGER, PARAMETER :: JAC_NZ = 920

  ! Number of nonzero entries in the LU decomposition of the Jacobian 
  INTEGER, PARAMETER :: JAC_LU_NZ = 920

  ! Number of nonzero entries in the stoichiometric matrix 
  INTEGER, PARAMETER :: STOICH_NZ = 1067

  ! Number of nonzero entries in the left-side stoichiometric matrix 
  INTEGER, PARAMETER :: LHS_STOICH_NZ = 403

  ! Number of nonzero entries in the right-side stoichiometric matrix 
  INTEGER, PARAMETER :: RHS_STOICH_NZ = 691


  ! Row indices of elements in the row-compressed Jacobian 
  INTEGER, PARAMETER :: JAC_IROW(920) = (/ 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, &
      2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, &
      4, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 10, &
      10, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, &
      16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 21, 21, 22, 22, 22, &
      22, 23, 23, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28, &
      28, 28, 28, 28, 29, 29, 29, 29, 29, 30, 30, 31, 31, 32, 32, 32, 32, 33, &
      33, 33, 33, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 36, 36, 36, 36, 36, &
      36, 37, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 39, 39, 39, 39, 39, &
      39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, &
      40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, &
      42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 43, 43, 43, 43, &
      43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 44, &
      44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, &
      45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, 47, 47, &
      47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, &
      48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, &
      50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, &
      52, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, &
      55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, &
      57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 58, &
      58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, &
      59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, &
      60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, &
      60, 60, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, &
      61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, &
      62, 62, 62, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, &
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, &
      65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 66, &
      66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, &
      66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, &
      67, 67, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, &
      69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, &
      69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, &
      73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74 /)

  ! Column indices of elements in the row-compressed Jacobian 
  INTEGER, PARAMETER :: JAC_ICOL(920) = (/ 1, 9, 74, 2, 20, 27, 44, 47, 49, &
      50, 51, 52, 53, 54, 62, 69, 74, 3, 51, 53, 62, 63, 64, 66, 68, 72, 4, &
      47, 49, 51, 52, 53, 62, 63, 64, 65, 66, 67, 68, 73, 5, 63, 72, 6, 63, &
      65, 67, 73, 7, 28, 70, 8, 28, 38, 70, 9, 74, 10, 62, 11, 74, 12, 24, &
      49, 62, 74, 13, 70, 72, 14, 70, 73, 15, 67, 70, 16, 65, 70, 17, 63, 74, &
      18, 70, 71, 19, 69, 74, 20, 74, 21, 74, 21, 22, 70, 74, 23, 74, 24, 74, &
      25, 63, 70, 74, 26, 63, 66, 74, 27, 56, 63, 69, 28, 36, 63, 70, 71, 29, &
      64, 66, 68, 74, 30, 74, 31, 74, 24, 31, 32, 74, 24, 31, 33, 74, 24, 31, &
      34, 71, 74, 24, 31, 35, 62, 74, 28, 36, 46, 63, 70, 71, 37, 63, 64, 68, &
      74, 24, 31, 38, 53, 62, 71, 74, 31, 39, 46, 63, 71, 74, 20, 30, 32, 33, &
      35, 40, 41, 44, 45, 47, 49, 50, 51, 52, 53, 54, 55, 56, 58, 59, 62, 71, &
      74, 24, 31, 32, 33, 34, 41, 50, 52, 54, 62, 71, 74, 20, 21, 22, 23, 30, &
      42, 49, 51, 53, 57, 62, 70, 71, 74, 18, 34, 36, 38, 39, 41, 43, 45, 46, &
      50, 52, 53, 54, 55, 56, 59, 62, 63, 70, 71, 74, 44, 58, 62, 71, 74, 20, &
      24, 31, 32, 33, 35, 39, 44, 45, 46, 49, 52, 58, 62, 63, 71, 74, 34, 39, &
      46, 63, 65, 67, 69, 70, 71, 72, 73, 74, 47, 58, 62, 71, 74, 21, 23, 30, &
      32, 33, 42, 47, 48, 49, 51, 53, 54, 57, 58, 60, 61, 62, 63, 64, 65, 66, &
      67, 68, 69, 70, 71, 72, 73, 74, 49, 58, 62, 71, 74, 47, 50, 53, 58, 62, &
      71, 74, 51, 58, 62, 71, 74, 47, 52, 53, 58, 62, 71, 74, 53, 58, 62, 71, &
      74, 47, 53, 54, 58, 62, 71, 74, 11, 21, 23, 30, 44, 51, 52, 53, 55, 57, &
      58, 59, 60, 61, 62, 65, 67, 69, 71, 72, 73, 74, 20, 21, 23, 26, 27, 29, &
      30, 42, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 56, 57, 58, 60, 61, 62, &
      63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 22, 49, 51, 52, 53, 57, &
      58, 62, 64, 69, 70, 71, 74, 10, 44, 47, 49, 50, 51, 53, 54, 58, 62, 69, &
      70, 71, 74, 20, 21, 23, 30, 32, 33, 35, 37, 44, 49, 50, 51, 52, 53, 54, &
      57, 58, 59, 60, 61, 62, 63, 64, 68, 69, 70, 71, 74, 21, 23, 30, 50, 51, &
      52, 53, 54, 57, 58, 60, 61, 62, 64, 66, 68, 69, 70, 71, 74, 23, 30, 31, &
      47, 49, 51, 52, 53, 54, 57, 58, 61, 62, 64, 66, 67, 68, 69, 70, 71, 72, &
      73, 74, 35, 44, 47, 49, 50, 51, 52, 53, 54, 58, 62, 63, 65, 67, 69, 70, &
      71, 72, 73, 74, 9, 17, 19, 20, 24, 25, 26, 27, 28, 29, 31, 32, 33, 35, &
      36, 37, 40, 41, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, &
      59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 20, 21, &
      23, 24, 30, 31, 47, 49, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62, 63, 64, &
      65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 16, 47, 50, 52, 53, 54, 58, 62, &
      63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 22, 26, 30, 42, 44, 47, &
      49, 51, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, &
      70, 71, 72, 73, 74, 15, 38, 53, 58, 62, 63, 64, 65, 66, 67, 68, 69, 70, &
      71, 72, 73, 74, 11, 20, 21, 23, 24, 30, 31, 32, 33, 34, 35, 37, 39, 44, &
      46, 47, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, &
      67, 68, 69, 70, 71, 72, 73, 74, 19, 27, 48, 49, 51, 53, 54, 56, 57, 58, &
      60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 13, 14, 15, &
      16, 18, 19, 22, 25, 27, 28, 36, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, &
      54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, &
      72, 73, 74, 18, 25, 34, 36, 38, 39, 41, 43, 44, 45, 46, 47, 48, 49, 50, &
      51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, &
      69, 70, 71, 72, 73, 74, 12, 13, 24, 30, 32, 33, 41, 42, 49, 50, 51, 52, &
      53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, &
      72, 73, 74, 14, 45, 46, 49, 50, 52, 53, 54, 58, 59, 60, 61, 62, 63, 64, &
      65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 9, 10, 11, 17, 19, 20, 21, 23, &
      24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, &
      45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, &
      64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74 /)

  ! Start-of-row indices in the row-compressed Jacobian 
  INTEGER, PARAMETER :: JAC_CROW(75) = (/ 1, 4, 18, 27, 41, 44, 49, 52, 56, &
      58, 60, 62, 67, 70, 73, 76, 79, 82, 85, 88, 90, 92, 96, 98, 100, 104, &
      108, 112, 117, 122, 124, 126, 130, 134, 139, 144, 150, 155, 162, 168, &
      191, 203, 217, 238, 243, 260, 272, 277, 306, 311, 318, 323, 330, 335, &
      342, 364, 400, 413, 427, 455, 475, 498, 518, 566, 596, 616, 645, 662, &
      702, 727, 769, 808, 841, 866, 921 /)

  ! Diagonal indices in the row-compressed Jacobian 
  INTEGER, PARAMETER :: JAC_DIAG(75) = (/ 1, 4, 18, 27, 41, 44, 49, 52, 56, &
      58, 60, 62, 67, 70, 73, 76, 79, 82, 85, 88, 90, 93, 96, 98, 100, 104, &
      108, 112, 117, 122, 124, 128, 132, 136, 141, 145, 150, 157, 163, 173, &
      196, 208, 223, 238, 251, 262, 272, 284, 306, 312, 318, 324, 330, 337, &
      350, 382, 405, 421, 444, 465, 486, 508, 554, 585, 606, 636, 654, 695, &
      721, 764, 804, 838, 864, 920, 921 /)

  ! Row indices of elements in the row-compressed LU decomposition of the Jacobian 
  INTEGER, PARAMETER :: JAC_LU_IROW(920) = (/ 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, &
      2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, &
      4, 4, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, &
      10, 10, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, &
      16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 21, 21, 22, 22, &
      22, 22, 23, 23, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, &
      28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 30, 30, 31, 31, 32, 32, 32, 32, &
      33, 33, 33, 33, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 36, 36, 36, 36, &
      36, 36, 37, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 39, 39, 39, 39, &
      39, 39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, &
      40, 40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, &
      41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 43, 43, 43, &
      43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, &
      44, 44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, &
      45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, 47, &
      47, 47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, &
      48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, &
      49, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, &
      52, 52, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, &
      55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, &
      58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, &
      59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, &
      59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, &
      60, 60, 60, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, &
      61, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, &
      62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, &
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, &
      65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, &
      66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, &
      66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, &
      67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, &
      69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, &
      69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, &
      73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74 /)

  ! Column indices of elements in the row-compressed LU decomposition of the Jacobian 
  INTEGER, PARAMETER :: JAC_LU_ICOL(920) = (/ 1, 9, 74, 2, 20, 27, 44, 47, &
      49, 50, 51, 52, 53, 54, 62, 69, 74, 3, 51, 53, 62, 63, 64, 66, 68, 72, &
      4, 47, 49, 51, 52, 53, 62, 63, 64, 65, 66, 67, 68, 73, 5, 63, 72, 6, &
      63, 65, 67, 73, 7, 28, 70, 8, 28, 38, 70, 9, 74, 10, 62, 11, 74, 12, &
      24, 49, 62, 74, 13, 70, 72, 14, 70, 73, 15, 67, 70, 16, 65, 70, 17, 63, &
      74, 18, 70, 71, 19, 69, 74, 20, 74, 21, 74, 21, 22, 70, 74, 23, 74, 24, &
      74, 25, 63, 70, 74, 26, 63, 66, 74, 27, 56, 63, 69, 28, 36, 63, 70, 71, &
      29, 64, 66, 68, 74, 30, 74, 31, 74, 24, 31, 32, 74, 24, 31, 33, 74, 24, &
      31, 34, 71, 74, 24, 31, 35, 62, 74, 28, 36, 46, 63, 70, 71, 37, 63, 64, &
      68, 74, 24, 31, 38, 53, 62, 71, 74, 31, 39, 46, 63, 71, 74, 20, 30, 32, &
      33, 35, 40, 41, 44, 45, 47, 49, 50, 51, 52, 53, 54, 55, 56, 58, 59, 62, &
      71, 74, 24, 31, 32, 33, 34, 41, 50, 52, 54, 62, 71, 74, 20, 21, 22, 23, &
      30, 42, 49, 51, 53, 57, 62, 70, 71, 74, 18, 34, 36, 38, 39, 41, 43, 45, &
      46, 50, 52, 53, 54, 55, 56, 59, 62, 63, 70, 71, 74, 44, 58, 62, 71, 74, &
      20, 24, 31, 32, 33, 35, 39, 44, 45, 46, 49, 52, 58, 62, 63, 71, 74, 34, &
      39, 46, 63, 65, 67, 69, 70, 71, 72, 73, 74, 47, 58, 62, 71, 74, 21, 23, &
      30, 32, 33, 42, 47, 48, 49, 51, 53, 54, 57, 58, 60, 61, 62, 63, 64, 65, &
      66, 67, 68, 69, 70, 71, 72, 73, 74, 49, 58, 62, 71, 74, 47, 50, 53, 58, &
      62, 71, 74, 51, 58, 62, 71, 74, 47, 52, 53, 58, 62, 71, 74, 53, 58, 62, &
      71, 74, 47, 53, 54, 58, 62, 71, 74, 11, 21, 23, 30, 44, 51, 52, 53, 55, &
      57, 58, 59, 60, 61, 62, 65, 67, 69, 71, 72, 73, 74, 20, 21, 23, 26, 27, &
      29, 30, 42, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 56, 57, 58, 60, 61, &
      62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 22, 49, 51, 52, 53, &
      57, 58, 62, 64, 69, 70, 71, 74, 10, 44, 47, 49, 50, 51, 53, 54, 58, 62, &
      69, 70, 71, 74, 20, 21, 23, 30, 32, 33, 35, 37, 44, 49, 50, 51, 52, 53, &
      54, 57, 58, 59, 60, 61, 62, 63, 64, 68, 69, 70, 71, 74, 21, 23, 30, 50, &
      51, 52, 53, 54, 57, 58, 60, 61, 62, 64, 66, 68, 69, 70, 71, 74, 23, 30, &
      31, 47, 49, 51, 52, 53, 54, 57, 58, 61, 62, 64, 66, 67, 68, 69, 70, 71, &
      72, 73, 74, 35, 44, 47, 49, 50, 51, 52, 53, 54, 58, 62, 63, 65, 67, 69, &
      70, 71, 72, 73, 74, 9, 17, 19, 20, 24, 25, 26, 27, 28, 29, 31, 32, 33, &
      35, 36, 37, 40, 41, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, &
      58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 20, &
      21, 23, 24, 30, 31, 47, 49, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62, 63, &
      64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 16, 47, 50, 52, 53, 54, 58, &
      62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 22, 26, 30, 42, 44, &
      47, 49, 51, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, &
      69, 70, 71, 72, 73, 74, 15, 38, 53, 58, 62, 63, 64, 65, 66, 67, 68, 69, &
      70, 71, 72, 73, 74, 11, 20, 21, 23, 24, 30, 31, 32, 33, 34, 35, 37, 39, &
      44, 46, 47, 49, 50, 51, 52, 53, 54, 57, 58, 59, 60, 61, 62, 63, 64, 65, &
      66, 67, 68, 69, 70, 71, 72, 73, 74, 19, 27, 48, 49, 51, 53, 54, 56, 57, &
      58, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 13, 14, &
      15, 16, 18, 19, 22, 25, 27, 28, 36, 43, 45, 46, 47, 48, 49, 50, 51, 52, &
      53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, &
      71, 72, 73, 74, 18, 25, 34, 36, 38, 39, 41, 43, 44, 45, 46, 47, 48, 49, &
      50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, &
      68, 69, 70, 71, 72, 73, 74, 12, 13, 24, 30, 32, 33, 41, 42, 49, 50, 51, &
      52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, &
      71, 72, 73, 74, 14, 45, 46, 49, 50, 52, 53, 54, 58, 59, 60, 61, 62, 63, &
      64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 9, 10, 11, 17, 19, 20, 21, &
      23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, &
      44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, &
      63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74 /)

  ! Start-of-row indices in the row-compressed LU decomposition of the Jacobian 
  INTEGER, PARAMETER :: JAC_LU_CROW(75) = (/ 1, 4, 18, 27, 41, 44, 49, 52, &
      56, 58, 60, 62, 67, 70, 73, 76, 79, 82, 85, 88, 90, 92, 96, 98, 100, &
      104, 108, 112, 117, 122, 124, 126, 130, 134, 139, 144, 150, 155, 162, &
      168, 191, 203, 217, 238, 243, 260, 272, 277, 306, 311, 318, 323, 330, &
      335, 342, 364, 400, 413, 427, 455, 475, 498, 518, 566, 596, 616, 645, &
      662, 702, 727, 769, 808, 841, 866, 921 /)

  ! Diagonal indices in the row-compressed LU decomposition of the Jacobian 
  INTEGER, PARAMETER :: JAC_LU_DIAG(75) = (/ 1, 4, 18, 27, 41, 44, 49, 52, &
      56, 58, 60, 62, 67, 70, 73, 76, 79, 82, 85, 88, 90, 93, 96, 98, 100, &
      104, 108, 112, 117, 122, 124, 128, 132, 136, 141, 145, 150, 157, 163, &
      173, 196, 208, 223, 238, 251, 262, 272, 284, 306, 312, 318, 324, 330, &
      337, 350, 382, 405, 421, 444, 465, 486, 508, 554, 585, 606, 636, 654, &
      695, 721, 764, 804, 838, 864, 920, 921 /)

  ! Row indices of elements in the row-compressed stoichiometric matrix 
  INTEGER, PARAMETER :: STOICH_IROW(1067) = (/ 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, &
      2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, &
      5, 6, 6, 6, 7, 8, 8, 9, 10, 10, 10, 11, 12, 12, 12, 13, 13, 14, 14, 15, &
      15, 16, 16, 17, 17, 17, 17, 18, 18, 18, 19, 19, 19, 19, 20, 21, 22, 22, &
      22, 23, 24, 25, 25, 25, 25, 26, 26, 26, 27, 27, 27, 28, 28, 28, 28, 29, &
      29, 29, 29, 30, 31, 32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34, 35, &
      35, 35, 35, 36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, &
      38, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, &
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, &
      40, 40, 40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, &
      41, 41, 41, 41, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, &
      42, 42, 42, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, &
      43, 44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, &
      45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, 47, 47, &
      47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, &
      48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, &
      48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, &
      50, 50, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 54, &
      54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, &
      55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, &
      55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, &
      58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, &
      59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, &
      59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 60, &
      60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 61, &
      61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, &
      61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, &
      62, 62, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, &
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, &
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 65, 65, 65, &
      65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, &
      66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, &
      66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, &
      67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 69, 69, 69, &
      69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, &
      73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, &
      73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, &
      75, 76, 76, 76, 76, 77, 77, 77, 77, 78, 79, 80, 80, 80, 80, 80, 80, 80, &
      80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, &
      80, 80, 80, 80, 80 /)

  ! Column indices of elements in the row-compressed stoichiometric matrix 
  INTEGER, PARAMETER :: STOICH_ICOL(1067) = (/ 44, 128, 162, 167, 171, 186, &
      190, 194, 198, 205, 209, 72, 74, 75, 77, 205, 209, 82, 84, 85, 87, 93, &
      95, 96, 98, 105, 107, 108, 110, 171, 190, 194, 205, 209, 72, 82, 93, &
      105, 120, 120, 159, 44, 18, 19, 20, 197, 152, 194, 203, 69, 70, 79, 80, &
      90, 91, 102, 103, 37, 38, 41, 42, 11, 12, 13, 21, 22, 23, 24, 198, 199, &
      115, 116, 199, 201, 203, 32, 33, 34, 35, 47, 141, 142, 126, 127, 128, &
      120, 121, 122, 157, 49, 54, 64, 140, 200, 202, 180, 181, 202, 203, 182, &
      183, 202, 203, 155, 156, 202, 203, 178, 179, 202, 203, 117, 121, 122, &
      157, 52, 63, 143, 144, 158, 159, 160, 202, 203, 208, 209, 210, 118, &
      119, 153, 154, 202, 29, 123, 124, 125, 129, 131, 133, 134, 145, 146, &
      147, 148, 149, 150, 151, 161, 162, 163, 165, 167, 169, 170, 171, 172, &
      173, 178, 179, 181, 183, 186, 188, 190, 194, 198, 200, 205, 209, 211, &
      149, 150, 151, 155, 161, 162, 166, 167, 170, 171, 172, 181, 183, 202, &
      203, 116, 136, 137, 176, 177, 194, 198, 199, 200, 201, 204, 205, 206, &
      208, 209, 210, 13, 25, 27, 28, 39, 129, 132, 135, 148, 151, 154, 156, &
      157, 160, 163, 172, 185, 186, 187, 188, 145, 146, 147, 148, 153, 170, &
      171, 179, 181, 183, 188, 194, 198, 202, 203, 92, 94, 99, 100, 101, 113, &
      117, 118, 119, 153, 154, 155, 156, 189, 190, 191, 192, 56, 57, 58, 59, &
      60, 67, 76, 86, 92, 94, 97, 99, 100, 101, 109, 113, 136, 138, 166, 175, &
      176, 177, 180, 181, 182, 183, 189, 190, 191, 192, 193, 194, 195, 199, &
      200, 201, 204, 206, 208, 209, 210, 193, 194, 195, 196, 161, 162, 163, &
      164, 165, 189, 190, 208, 209, 211, 204, 205, 206, 207, 170, 171, 172, &
      173, 189, 191, 208, 208, 209, 210, 211, 166, 167, 168, 169, 189, 190, &
      209, 210, 81, 83, 88, 89, 100, 112, 130, 131, 132, 133, 134, 138, 139, &
      170, 171, 173, 174, 175, 176, 177, 185, 188, 197, 199, 200, 201, 204, &
      205, 206, 208, 209, 210, 46, 48, 49, 50, 54, 64, 74, 84, 95, 104, 106, &
      107, 111, 112, 113, 114, 123, 124, 125, 126, 127, 129, 136, 138, 140, &
      141, 142, 146, 161, 162, 165, 166, 167, 170, 171, 172, 173, 174, 175, &
      176, 177, 185, 186, 188, 189, 190, 192, 193, 194, 198, 199, 200, 201, &
      204, 205, 208, 209, 210, 62, 115, 172, 176, 177, 195, 206, 210, 1, 2, &
      3, 4, 5, 6, 16, 17, 20, 164, 168, 188, 192, 196, 207, 211, 133, 134, &
      135, 138, 143, 144, 164, 166, 168, 170, 172, 174, 175, 176, 177, 178, &
      180, 182, 187, 193, 194, 195, 196, 198, 199, 200, 201, 204, 205, 206, &
      207, 208, 209, 210, 211, 64, 65, 66, 68, 138, 139, 161, 168, 170, 171, &
      173, 174, 176, 177, 199, 200, 201, 207, 208, 209, 210, 211, 64, 66, 68, &
      77, 87, 98, 169, 170, 174, 175, 176, 177, 190, 192, 193, 194, 196, 200, &
      201, 202, 204, 205, 207, 209, 211, 2, 3, 7, 8, 17, 18, 30, 36, 72, 82, &
      93, 105, 162, 167, 171, 179, 186, 190, 194, 205, 209, 23, 26, 29, 30, &
      31, 32, 33, 34, 36, 37, 38, 39, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, &
      53, 54, 55, 63, 64, 65, 66, 68, 72, 82, 93, 105, 118, 121, 123, 125, &
      126, 127, 128, 129, 131, 134, 140, 142, 144, 145, 147, 148, 149, 162, &
      165, 167, 171, 173, 174, 176, 177, 179, 181, 183, 186, 188, 194, 198, &
      202, 203, 205, 209, 211, 62, 63, 64, 65, 66, 68, 77, 87, 98, 110, 133, &
      138, 166, 170, 172, 174, 175, 176, 177, 189, 190, 191, 192, 193, 194, &
      195, 198, 199, 200, 201, 202, 203, 204, 205, 206, 208, 209, 210, 211, &
      102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 161, 163, &
      165, 169, 170, 172, 190, 192, 46, 47, 48, 49, 50, 54, 64, 71, 73, 74, &
      78, 84, 88, 95, 99, 107, 111, 116, 131, 137, 141, 169, 184, 188, 192, &
      200, 205, 209, 210, 90, 91, 92, 93, 94, 95, 96, 98, 99, 100, 101, 113, &
      158, 160, 51, 52, 53, 54, 55, 66, 75, 81, 83, 85, 88, 89, 96, 100, 108, &
      112, 133, 134, 138, 139, 143, 153, 155, 161, 162, 163, 165, 166, 167, &
      170, 171, 172, 174, 175, 176, 177, 178, 181, 183, 185, 187, 188, 189, &
      190, 191, 193, 194, 195, 197, 198, 199, 200, 201, 202, 203, 204, 205, &
      206, 208, 209, 210, 211, 1, 4, 5, 7, 9, 10, 14, 15, 21, 22, 31, 46, 51, &
      56, 62, 71, 81, 92, 104, 128, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 23, &
      24, 25, 26, 28, 31, 32, 33, 34, 35, 39, 40, 46, 48, 51, 53, 56, 58, 65, &
      69, 70, 71, 73, 79, 80, 81, 83, 90, 91, 92, 94, 102, 103, 104, 106, &
      115, 117, 120, 128, 176, 177, 191, 195, 210, 6, 8, 9, 11, 12, 14, 15, &
      16, 26, 27, 34, 39, 40, 48, 53, 58, 65, 73, 83, 94, 106, 129, 132, 135, &
      148, 151, 154, 156, 157, 160, 163, 172, 187, 191, 195, 206, 210, 69, &
      70, 71, 72, 73, 74, 75, 77, 78, 88, 99, 104, 106, 112, 113, 114, 130, &
      132, 136, 137, 138, 139, 149, 150, 151, 152, 165, 166, 173, 174, 175, &
      180, 181, 182, 183, 194, 200, 209, 79, 80, 81, 82, 83, 84, 85, 87, 88, &
      89, 100, 112, 133, 135, 138, 147, 148, 162, 167, 171, 173, 174, 175, &
      194, 209, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 34, 35, 36, 39, &
      41, 42, 43, 44, 45, 125, 130, 133, 136, 138, 140, 141, 142, 143, 144, &
      147, 150, 153, 155, 158, 161, 162, 165, 166, 167, 170, 171, 174, 176, &
      178, 179, 180, 182, 184, 185, 186, 189, 190, 193, 194, 197, 198, 199, &
      200, 201, 202, 203, 204, 205, 208, 209, 2, 4, 20, 2, 3, 10, 43, 13, 19, &
      38, 43, 45, 184, 1, 15, 16, 17, 18, 22, 23, 28, 34, 41, 123, 124, 131, &
      134, 137, 139, 142, 144, 145, 146, 149, 152, 159, 165, 169, 173, 175, &
      177, 181, 183 /)

  ! Start-of-row indices in the row-compressed stoichiometric matrix 
  INTEGER, PARAMETER :: STOICH_CROW(82) = (/ 1, 2, 12, 18, 35, 36, 39, 40, &
      42, 43, 46, 47, 50, 52, 54, 56, 58, 62, 65, 69, 70, 71, 74, 75, 76, 80, &
      83, 86, 90, 94, 95, 96, 100, 104, 108, 112, 116, 120, 128, 133, 171, &
      186, 202, 218, 222, 237, 250, 254, 295, 299, 309, 313, 320, 324, 332, &
      364, 422, 430, 446, 481, 503, 528, 549, 620, 659, 679, 708, 722, 784, &
      804, 859, 896, 934, 959, 1025, 1028, 1032, 1036, 1037, 1038, 1068, 1068 &
      /)

  ! Stoichiometric coefficients 
  REAL(8), PARAMETER :: STOICH(1067) = (/ 1.0, 1.0, 0.333, 0.351, 0.1, 0.37, &
      0.204, 0.103, 0.121, 0.185, 0.073, 0.25, 1.0, 1.0, 1.0, 0.05, 0.129, &
      0.25, 1.0, 1.0, 1.0, 0.25, 1.0, 1.0, 1.0, 0.25, 1.0, 1.0, 2.0, 0.372, &
      0.15, 0.189, 0.119, 0.247, 0.75, 0.75, 0.75, 0.75, 2.0, 6.0, 7.0, -1.0, &
      1.0, -1.0, -1.0, -1.0, -1.0, 0.031, 0.087, 1.0, -1.0, 1.0, -1.0, 1.0, &
      -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.236, -1.0, -1.0, 1.0, -1.0, -1.0, &
      -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, &
      0.25, 0.25, -1.0, -1.0, -1.0, -1.0, -1.0, 0.108, 0.099, -1.0, -1.0, &
      0.051, 0.093, -1.0, -1.0, 0.207, 0.187, -1.0, -1.0, 0.491, 0.561, 1.0, &
      1.0, 1.0, -1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.059, 0.05, &
      0.061, 0.042, 0.015, 1.0, 1.0, -1.0, -1.0, 0.017, -1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 0.034, 1.0, 2.0, 1.0, 1.26, 1.26, 1.0, 1.0, 1.0, 0.416, 0.45, &
      0.5, 0.67, 0.475, 0.7, 0.336, 0.498, 0.572, 1.233, 1.0, 1.5, 1.0, 1.0, &
      0.5, 0.491, 0.275, 0.157, 0.16, 0.002, 0.345, 0.265, 0.012, -1.0, -1.0, &
      -1.0, 0.23, 0.084, 0.9, 0.3, 0.95, 0.174, 0.742, 0.008, 0.5, 0.5, &
      0.119, 0.287, 1.0, -1.0, -1.0, 0.006, 0.02, 0.13, 0.417, 0.024, 0.452, &
      0.072, 0.005, 0.001, 0.024, 0.127, 0.045, 0.102, 2.0, 1.0, -1.0, -1.0, &
      0.2, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.5, 0.15, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.23, 0.15, 0.023, 1.0, 0.5, &
      0.5, 0.009, 0.001, 0.248, 0.118, 0.097, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, &
      -1.0, -1.0, -1.0, 0.24, 1.0, 0.24, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, 1.0, -1.0, 1.0, 1.0, &
      2.0, -1.0, 1.0, 1.0, 0.616, 0.675, 0.515, 0.596, 0.152, 1.0, 1.0, 1.0, &
      1.0, 0.079, 0.126, 0.187, 0.24, 0.5, 0.729, 0.75, 0.559, 0.936, 0.948, &
      0.205, 0.488, 0.001, 0.137, 0.711, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, 0.23, 0.39, 0.025, 0.026, 0.012, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, 0.357, 0.936, 0.025, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, 0.32, 0.16, 0.019, 0.048, 1.0, 1.0, 1.0, &
      2.0, 1.0, 1.0, -1.0, -1.0, -1.0, 0.034, 1.0, 0.482, 1.0, 0.129, 0.047, &
      0.467, 0.084, 0.246, 0.439, 0.431, 0.195, 0.25, 1.0, 0.445, 0.455, &
      0.099, 0.294, 0.154, 0.009, 0.732, 0.456, 0.507, 1.0, 1.0, 1.0, 2.0, &
      0.75, 0.75, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, -1.0, &
      -1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 0.115, 1.0, 0.35, 1.0, 1.0, 0.084, &
      0.2, 0.67, 0.3, 0.1, 0.055, 0.125, 0.227, 0.3, 0.213, 0.506, 0.01, &
      0.134, 1.61, 1.0, 0.191, 0.624, 0.592, 0.24, 0.276, 0.235, 0.039, &
      0.026, 0.024, 0.026, 0.732, 0.5, 0.244, 0.269, 0.079, 1.0, 1.0, 0.572, &
      -0.69, -1.0, 0.276, 0.511, 0.321, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, 0.37, 1.0, 1.0, 1.0, 0.675, 0.45, 0.013, 0.218, 0.558, 0.71, &
      0.213, 0.147, 1.0, 1.0, 1.0, 1.0, 0.474, 0.205, 0.474, 0.147, 0.155, &
      0.122, 0.244, 0.204, 0.497, 0.363, 0.037, 0.45, 0.511, 0.305, 0.151, &
      0.069, 0.5, 1.0, 0.5, 1.0, -1.0, -1.0, 0.416, 0.55, 0.15, 0.21, 0.233, &
      0.115, 0.177, 0.243, 0.332, 0.11, 0.089, 0.437, 0.072, 0.026, 0.001, &
      0.659, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, 0.7, 0.332, -0.671, -1.0, 0.048, &
      0.435, 0.1, 0.75, 0.276, 0.276, 0.853, 0.125, 0.417, 0.055, 0.119, &
      0.215, 0.113, 0.043, 0.259, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, 0.25, 0.25, 0.25, 0.25, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, 1.0, 0.61, -1.0, -2.0, &
      -2.0, -1.0, 1.0, -1.0, 1.0, 1.0, 1.0, -1.0, 1.0, 2.0, 1.0, -1.0, 1.0, &
      1.0, 1.0, -1.0, 1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      2.0, 1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 0.63, &
      0.63, 1.0, 0.008, 0.34, 0.064, 0.4, 1.233, 0.379, 0.113, 0.341, 1.5, &
      0.5, 0.5, 0.12, 0.5, 0.033, 0.121, 0.224, 0.187, 0.056, 0.003, 0.013, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -2.0, -1.0, -1.0, -1.0, -1.0, 0.001, &
      0.042, 0.025, 0.041, 0.051, 0.07, 0.04, 0.173, 0.095, 0.093, 0.008, &
      0.064, 0.01, 0.25, 0.18, 0.25, 0.021, 0.07, 0.143, 0.347, 0.011, 0.009, &
      0.09, 0.001, 0.176, 0.082, 0.002, 0.136, 0.001, -1.0, 1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -2.0, 0.5, 0.5, 0.33, 0.3, &
      0.289, 0.15, 0.192, 0.24, -1.0, -1.0, -1.0, -2.0, -2.0, -1.0, -1.0, &
      1.0, 1.0, -1.0, 2.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, 1.0, 1.0, 1.0, &
      0.65, 0.3, 1.0, 0.3, 0.25, 0.011, 0.076, 0.197, 0.03, -1.0, 1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -2.0, -1.0, 1.0, 1.0, -1.0, &
      -1.0, -1.0, -1.0, -2.0, -1.0, -1.0, 1.0, 1.0, -1.0, 1.0, 2.0, -1.0, &
      1.0, -1.0, 1.0, 0.034, 1.0, 0.37, 1.0, 0.34, 0.76, 0.76, 0.5, 0.1, 0.5, &
      0.33, 0.3, 0.05, 0.67, 0.048, 0.799, 0.473, 0.96, 0.376, 0.564, 1.0, &
      1.0, 1.0, 1.0, 1.0, 0.2, 0.907, 0.066, 0.749, 0.75, 0.031, 0.276, 1.0, &
      0.612, 0.695, 0.835, 0.653, 0.765, 0.804, 0.91, 0.022, 0.824, 0.918, &
      0.033, 0.442, 0.012, 1.0, -1.0, 1.0, -1.0, -1.0, -2.0, 1.0, 1.0, -1.0, &
      1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      1.0, -1.0, -1.0, 1.0, -1.0, 2.0, 2.0, -1.0, 1.0, 1.0, 1.0, 1.0, -1.0, &
      1.0, 1.0, 1.0, -1.0, 1.0, 0.61, 1.0, 0.8, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, -1.0, 1.0, 1.0, 1.0, -1.0, 1.0, 1.0, 1.0, -1.0, 1.0, 1.0, &
      1.0, -1.0, 1.0, 1.0, 1.0, -1.0, -1.0, -1.0, 1.0, 0.338, 1.0, 0.187, &
      0.474, 0.391, 1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, 1.0, &
      0.39, -1.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -2.0, &
      -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 0.492, 1.0, &
      1.0, 1.0, 1.0, 2.0, 0.67, 0.675, 0.467, 0.029, 0.667, 1.0, 0.5, 1.0, &
      0.5, 0.123, 0.011, 0.137, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -2.0, -1.0, -1.0, 0.965, 1.0, 0.096, 0.37, 0.37, 0.1, 0.05, &
      0.048, 0.3, 0.049, 0.333, 0.201, 0.006, 2.0, -1.0, 1.0, -1.0, -1.0, &
      -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, 0.39, -1.0, 1.0, 0.8, 2.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -0.65, 1.0, &
      -0.34, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.208, 0.33, -1.0, &
      0.164, -1.0, 0.285, -1.0, -1.0, -1.0, 0.5, -1.0, -1.0, -1.0, -1.0, &
      0.12, -1.0, 0.266, -1.0, 0.567, -1.0, -0.754, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, 0.155, -1.0, 0.378, -1.0, -1.0, -1.0, -1.0, 2.0, -1.0, 1.0, &
      -1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, &
      -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0 &
      /)

  ! Row indices of elements in the row-compressed left-side stoichiometric matrix 
  INTEGER, PARAMETER :: LHS_STOICH_IROW(403) = (/ 9, 10, 10, 11, 12, 13, 14, &
      15, 16, 17, 17, 18, 18, 19, 19, 19, 20, 21, 22, 22, 23, 24, 25, 25, 25, &
      26, 26, 27, 27, 28, 28, 28, 29, 30, 31, 32, 32, 33, 33, 34, 34, 35, 35, &
      36, 37, 37, 38, 38, 38, 39, 39, 40, 41, 41, 41, 42, 42, 43, 43, 44, 44, &
      44, 44, 45, 45, 45, 45, 46, 46, 46, 47, 47, 47, 47, 48, 48, 48, 48, 48, &
      48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 50, 51, 51, 51, &
      51, 52, 52, 52, 52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, 55, 56, 56, &
      56, 56, 56, 57, 57, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, &
      59, 59, 60, 60, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, &
      62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, &
      65, 65, 65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, &
      66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, &
      69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, &
      71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, &
      73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 76, &
      76, 77, 77, 77, 78, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, &
      80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80 &
      /)

  ! Column indices of elements in the row-compressed left-side stoichiometric matrix 
  INTEGER, PARAMETER :: LHS_STOICH_ICOL(403) = (/ 44, 19, 20, 197, 152, 70, &
      80, 91, 103, 41, 42, 12, 13, 22, 23, 24, 198, 199, 115, 116, 201, 203, &
      33, 34, 35, 141, 142, 127, 128, 120, 121, 122, 140, 200, 202, 180, 181, &
      182, 183, 155, 156, 178, 179, 157, 143, 144, 158, 159, 160, 153, 154, &
      29, 149, 150, 151, 136, 137, 27, 28, 185, 186, 187, 188, 145, 146, 147, &
      148, 117, 118, 119, 189, 190, 191, 192, 56, 57, 58, 59, 60, 61, 67, 76, &
      86, 97, 109, 193, 194, 195, 196, 161, 162, 163, 164, 165, 204, 205, &
      206, 207, 170, 171, 172, 173, 208, 209, 210, 211, 166, 167, 168, 169, &
      130, 131, 132, 123, 124, 125, 126, 129, 176, 177, 2, 3, 4, 5, 6, 164, &
      168, 188, 192, 196, 207, 211, 133, 134, 135, 138, 139, 174, 175, 3, 7, &
      8, 17, 18, 30, 36, 162, 167, 171, 179, 186, 190, 194, 205, 209, 31, 32, &
      36, 37, 38, 39, 43, 47, 52, 57, 63, 72, 82, 93, 105, 118, 121, 126, 62, &
      63, 64, 65, 66, 67, 68, 77, 87, 98, 110, 102, 104, 105, 106, 107, 108, &
      109, 110, 111, 112, 113, 114, 46, 47, 48, 49, 50, 54, 59, 64, 74, 84, &
      95, 107, 90, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 113, 51, 52, 53, &
      54, 55, 60, 66, 75, 85, 96, 108, 4, 7, 9, 10, 21, 31, 46, 51, 56, 62, &
      71, 81, 92, 104, 128, 1, 5, 6, 8, 11, 14, 25, 32, 69, 79, 90, 102, 115, &
      117, 120, 9, 11, 14, 15, 16, 26, 39, 40, 48, 53, 58, 65, 73, 83, 94, &
      106, 129, 132, 135, 148, 151, 154, 156, 157, 160, 163, 172, 187, 191, &
      195, 206, 210, 69, 71, 72, 73, 74, 75, 76, 77, 78, 88, 99, 111, 79, 81, &
      82, 83, 84, 85, 86, 87, 88, 89, 100, 112, 21, 24, 25, 26, 27, 29, 30, &
      35, 42, 43, 44, 45, 125, 130, 133, 136, 138, 140, 141, 143, 147, 150, &
      153, 155, 158, 161, 166, 170, 174, 176, 178, 180, 182, 184, 185, 189, &
      193, 197, 198, 199, 200, 201, 202, 203, 204, 208, 2, 4, 20, 2, 10, 13, &
      19, 38, 45, 184, 1, 15, 16, 17, 18, 22, 23, 28, 34, 41, 123, 124, 131, &
      134, 137, 139, 142, 144, 145, 146, 149, 152, 159, 165, 169, 173, 175, &
      177, 181, 183 /)

  ! Start-of-row indices in the row-compressed left-side stoichiometric matrix 
  INTEGER, PARAMETER :: LHS_STOICH_CROW(82) = (/ 1, 1, 1, 1, 1, 1, 1, 1, 1, &
      2, 4, 5, 6, 7, 8, 9, 10, 12, 14, 17, 18, 19, 21, 22, 23, 26, 28, 30, &
      33, 34, 35, 36, 38, 40, 42, 44, 45, 47, 50, 52, 53, 56, 58, 60, 64, 68, &
      71, 75, 86, 90, 95, 99, 103, 107, 111, 114, 119, 121, 133, 136, 138, &
      140, 156, 174, 185, 197, 209, 221, 232, 247, 262, 294, 306, 318, 364, &
      367, 369, 372, 373, 374, 404, 404 /)

  ! Left-side stoichiometric coefficients 
  REAL(8), PARAMETER :: LHS_STOICH(403) = (/ 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 2.0, 2.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0 /)

  ! Row indices of elements in the row-compressed right-side stoichiometric matrix 
  INTEGER, PARAMETER :: RHS_STOICH_IROW(691) = (/ 1, 2, 2, 2, 2, 2, 2, 2, 2, &
      2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, &
      4, 5, 6, 6, 6, 7, 8, 8, 10, 12, 12, 13, 14, 15, 16, 17, 17, 18, 19, 22, &
      25, 26, 27, 28, 29, 29, 29, 32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 36, &
      37, 37, 38, 38, 38, 38, 38, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40, 40, &
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, &
      40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, &
      41, 41, 41, 41, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, &
      42, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 45, 45, 45, &
      45, 45, 45, 45, 45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, &
      48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, &
      48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 50, 50, 50, &
      50, 52, 52, 52, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, &
      55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, &
      55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, &
      57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, &
      59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, &
      59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, &
      60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 61, 61, 61, 61, 61, 61, 61, 61, &
      61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, &
      62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, &
      63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, &
      64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, &
      65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, &
      66, 66, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, &
      68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, &
      70, 70, 70, 70, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, &
      72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, &
      74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, &
      74, 74, 74, 74, 74, 76, 76, 77 /)

  ! Column indices of elements in the row-compressed right-side stoichiometric matrix 
  INTEGER, PARAMETER :: RHS_STOICH_ICOL(691) = (/ 44, 128, 162, 167, 171, &
      186, 190, 194, 198, 205, 209, 72, 74, 75, 77, 205, 209, 82, 84, 85, 87, &
      93, 95, 96, 98, 105, 107, 108, 110, 171, 190, 194, 205, 209, 72, 82, &
      93, 105, 120, 120, 159, 18, 194, 203, 69, 79, 90, 102, 37, 38, 11, 21, &
      199, 32, 47, 126, 157, 49, 54, 64, 202, 203, 202, 203, 202, 203, 202, &
      203, 117, 121, 122, 52, 63, 202, 203, 208, 209, 210, 118, 119, 202, &
      123, 124, 125, 129, 131, 133, 134, 145, 146, 147, 148, 149, 150, 151, &
      161, 162, 163, 165, 167, 169, 170, 171, 172, 173, 178, 179, 181, 183, &
      186, 188, 190, 194, 198, 200, 205, 209, 211, 155, 161, 162, 166, 167, &
      170, 171, 172, 181, 183, 202, 203, 116, 176, 177, 194, 198, 199, 200, &
      201, 204, 205, 206, 208, 209, 210, 13, 25, 39, 129, 132, 135, 148, 151, &
      154, 156, 157, 160, 163, 172, 153, 170, 171, 179, 181, 183, 188, 194, &
      198, 202, 203, 92, 94, 99, 100, 101, 113, 153, 154, 155, 156, 61, 92, &
      94, 99, 100, 101, 113, 136, 138, 166, 175, 176, 177, 180, 181, 182, &
      183, 189, 190, 191, 192, 193, 194, 195, 199, 200, 201, 204, 206, 208, &
      209, 210, 189, 190, 208, 209, 211, 189, 191, 208, 189, 190, 209, 210, &
      81, 83, 88, 89, 100, 112, 133, 134, 138, 139, 170, 171, 173, 174, 175, &
      176, 177, 185, 188, 197, 199, 200, 201, 204, 205, 206, 208, 209, 210, &
      46, 48, 49, 50, 54, 64, 74, 84, 95, 104, 106, 107, 111, 112, 113, 114, &
      127, 136, 138, 140, 141, 142, 146, 161, 162, 165, 166, 167, 170, 171, &
      172, 173, 174, 175, 176, 177, 185, 186, 188, 189, 190, 192, 193, 194, &
      198, 199, 200, 201, 204, 205, 208, 209, 210, 62, 115, 172, 176, 195, &
      206, 210, 1, 16, 17, 20, 138, 143, 144, 164, 166, 168, 170, 172, 174, &
      175, 176, 177, 178, 180, 182, 187, 193, 194, 195, 196, 198, 199, 200, &
      201, 204, 205, 206, 207, 208, 209, 210, 211, 64, 65, 66, 68, 161, 168, &
      170, 171, 173, 174, 176, 177, 199, 200, 201, 207, 208, 209, 210, 211, &
      64, 66, 68, 77, 87, 98, 169, 170, 174, 176, 177, 190, 192, 193, 194, &
      196, 200, 201, 202, 204, 205, 207, 209, 211, 2, 72, 82, 93, 105, 23, &
      26, 29, 30, 33, 34, 42, 44, 45, 46, 48, 50, 51, 53, 54, 55, 57, 64, 65, &
      66, 68, 123, 125, 127, 128, 129, 131, 134, 140, 142, 144, 145, 147, &
      148, 149, 162, 165, 167, 171, 173, 174, 176, 177, 179, 181, 183, 186, &
      188, 194, 198, 202, 203, 205, 209, 211, 67, 133, 138, 166, 170, 172, &
      174, 175, 176, 177, 189, 190, 191, 192, 193, 194, 195, 198, 199, 200, &
      201, 202, 203, 204, 205, 206, 208, 209, 210, 211, 103, 109, 161, 163, &
      165, 169, 170, 172, 190, 192, 59, 71, 73, 78, 88, 99, 111, 116, 131, &
      137, 141, 169, 184, 188, 192, 200, 205, 209, 210, 91, 97, 158, 160, 60, &
      81, 83, 88, 89, 100, 112, 133, 134, 138, 139, 143, 153, 155, 161, 162, &
      163, 165, 166, 167, 170, 171, 172, 174, 175, 176, 177, 178, 181, 183, &
      185, 187, 188, 189, 190, 191, 193, 194, 195, 197, 198, 199, 200, 201, &
      202, 203, 204, 205, 206, 208, 209, 210, 211, 1, 5, 14, 15, 22, 4, 7, 9, &
      10, 12, 14, 16, 23, 24, 26, 28, 31, 33, 34, 35, 39, 40, 46, 48, 51, 53, &
      56, 58, 65, 70, 71, 73, 80, 81, 83, 91, 92, 94, 103, 104, 106, 128, &
      176, 177, 191, 195, 210, 6, 8, 12, 27, 34, 70, 76, 104, 106, 111, 112, &
      113, 114, 130, 132, 136, 137, 138, 139, 149, 150, 151, 152, 165, 166, &
      173, 174, 175, 180, 181, 182, 183, 194, 200, 209, 80, 86, 133, 135, &
      138, 147, 148, 162, 167, 171, 173, 174, 175, 194, 209, 19, 22, 28, 31, &
      34, 36, 39, 41, 141, 142, 143, 144, 162, 165, 167, 171, 179, 186, 190, &
      194, 198, 205, 209, 3, 43, 43 /)

  ! Start-of-row indices in the row-compressed right-side stoichiometric matrix 
  INTEGER, PARAMETER :: RHS_STOICH_CROW(82) = (/ 1, 2, 12, 18, 35, 36, 39, &
      40, 42, 42, 43, 43, 45, 46, 47, 48, 49, 51, 52, 53, 53, 53, 54, 54, 54, &
      55, 56, 57, 58, 61, 61, 61, 63, 65, 67, 69, 72, 74, 79, 82, 119, 131, &
      145, 159, 159, 170, 180, 180, 212, 212, 217, 217, 220, 220, 224, 253, &
      306, 313, 317, 349, 369, 393, 398, 453, 483, 493, 512, 516, 569, 574, &
      616, 621, 651, 666, 689, 689, 691, 692, 692, 692, 692, 692 /)

  ! Right-side stoichiometric coefficients 
  REAL(8), PARAMETER :: RHS_STOICH(691) = (/ 1.0, 1.0, 0.333, 0.351, 0.1, &
      0.37, 0.204, 0.103, 0.121, 0.185, 0.073, 0.25, 1.0, 1.0, 1.0, 0.05, &
      0.129, 0.25, 1.0, 1.0, 1.0, 0.25, 1.0, 1.0, 1.0, 0.25, 1.0, 1.0, 2.0, &
      0.372, 0.15, 0.189, 0.119, 0.247, 0.75, 0.75, 0.75, 0.75, 2.0, 6.0, &
      7.0, 1.0, 0.031, 0.087, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.236, &
      1.0, 1.0, 1.0, 1.0, 1.0, 0.25, 0.25, 0.108, 0.099, 0.051, 0.093, 0.207, &
      0.187, 0.491, 0.561, 1.0, 1.0, 1.0, 1.0, 1.0, 0.059, 0.05, 0.061, &
      0.042, 0.015, 1.0, 1.0, 0.017, 1.0, 1.0, 1.0, 1.0, 1.0, 0.034, 1.0, &
      2.0, 1.0, 1.26, 1.26, 1.0, 1.0, 1.0, 0.416, 0.45, 0.5, 0.67, 0.475, &
      0.7, 0.336, 0.498, 0.572, 1.233, 1.0, 1.5, 1.0, 1.0, 0.5, 0.491, 0.275, &
      0.157, 0.16, 0.002, 0.345, 0.265, 0.012, 0.23, 0.084, 0.9, 0.3, 0.95, &
      0.174, 0.742, 0.008, 0.5, 0.5, 0.119, 0.287, 1.0, 0.006, 0.02, 0.13, &
      0.417, 0.024, 0.452, 0.072, 0.005, 0.001, 0.024, 0.127, 0.045, 0.102, &
      2.0, 1.0, 0.2, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.5, 0.15, &
      0.23, 0.15, 0.023, 1.0, 0.5, 0.5, 0.009, 0.001, 0.248, 0.118, 0.097, &
      1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 0.24, 1.0, 0.24, 1.0, 2.0, 1.0, 1.0, 1.0, &
      1.0, 2.0, 1.0, 1.0, 0.616, 0.675, 0.515, 0.596, 0.152, 1.0, 1.0, 1.0, &
      1.0, 0.079, 0.126, 0.187, 0.24, 0.5, 0.729, 0.75, 0.559, 0.936, 0.948, &
      0.205, 0.488, 0.001, 0.137, 0.711, 0.23, 0.39, 0.025, 0.026, 0.012, &
      0.357, 0.936, 0.025, 0.32, 0.16, 0.019, 0.048, 1.0, 1.0, 1.0, 2.0, 1.0, &
      1.0, 0.034, 1.0, 0.482, 1.0, 0.129, 0.047, 0.467, 0.084, 0.246, 0.439, &
      0.431, 0.195, 0.25, 1.0, 0.445, 0.455, 0.099, 0.294, 0.154, 0.009, &
      0.732, 0.456, 0.507, 1.0, 1.0, 1.0, 2.0, 0.75, 0.75, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 0.115, 1.0, 0.35, 1.0, &
      1.0, 0.084, 0.2, 0.67, 0.3, 0.1, 0.055, 0.125, 0.227, 0.3, 0.213, &
      0.506, 0.01, 0.134, 1.61, 1.0, 0.191, 0.624, 0.592, 0.24, 0.276, 0.235, &
      0.039, 0.026, 0.024, 0.026, 0.732, 0.5, 0.244, 0.269, 0.079, 1.0, 1.0, &
      0.572, 0.31, 0.276, 0.511, 0.321, 1.0, 1.0, 1.0, 1.0, 0.37, 1.0, 1.0, &
      1.0, 0.675, 0.45, 0.013, 0.218, 0.558, 0.71, 0.213, 0.147, 1.0, 1.0, &
      1.0, 1.0, 0.474, 0.205, 0.474, 0.147, 0.155, 0.122, 0.244, 0.204, &
      0.497, 0.363, 0.037, 0.45, 0.511, 0.305, 0.151, 0.069, 0.5, 1.0, 0.5, &
      1.0, 0.416, 0.55, 0.15, 0.21, 0.233, 0.115, 0.177, 0.243, 0.332, 0.11, &
      0.089, 0.437, 0.072, 0.026, 0.001, 0.659, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, &
      0.7, 0.332, 0.329, 0.048, 0.435, 0.1, 0.75, 0.276, 0.276, 0.853, 0.125, &
      0.417, 0.055, 0.119, 0.215, 0.113, 0.043, 0.259, 1.0, 0.25, 0.25, 0.25, &
      0.25, 1.0, 1.0, 1.0, 1.0, 1.0, 0.61, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 2.0, 0.63, 0.63, 1.0, 0.008, 0.34, 0.064, 0.4, &
      1.233, 0.379, 0.113, 0.341, 1.5, 0.5, 0.5, 0.12, 0.5, 0.033, 0.121, &
      0.224, 0.187, 0.056, 0.003, 0.013, 1.0, 0.001, 0.042, 0.025, 0.041, &
      0.051, 0.07, 0.04, 0.173, 0.095, 0.093, 0.008, 0.064, 0.01, 0.25, 0.18, &
      0.25, 0.021, 0.07, 0.143, 0.347, 0.011, 0.009, 0.09, 0.001, 0.176, &
      0.082, 0.002, 0.136, 0.001, 1.0, 1.0, 0.5, 0.5, 0.33, 0.3, 0.289, 0.15, &
      0.192, 0.24, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.65, &
      0.3, 1.0, 0.3, 0.25, 0.011, 0.076, 0.197, 0.03, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 2.0, 1.0, 1.0, 0.034, 1.0, 0.37, 1.0, 0.34, 0.76, &
      0.76, 0.5, 0.1, 0.5, 0.33, 0.3, 0.05, 0.67, 0.048, 0.799, 0.473, 0.96, &
      0.376, 0.564, 1.0, 1.0, 1.0, 1.0, 1.0, 0.2, 0.907, 0.066, 0.749, 0.75, &
      0.031, 0.276, 1.0, 0.612, 0.695, 0.835, 0.653, 0.765, 0.804, 0.91, &
      0.022, 0.824, 0.918, 0.033, 0.442, 0.012, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.61, 1.0, &
      0.8, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.338, 1.0, 0.187, 0.474, &
      0.391, 1.0, 1.0, 1.0, 1.0, 0.39, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, &
      2.0, 1.0, 1.0, 1.0, 1.0, 0.492, 1.0, 1.0, 1.0, 1.0, 2.0, 0.67, 0.675, &
      0.467, 0.029, 0.667, 1.0, 0.5, 1.0, 0.5, 0.123, 0.011, 0.137, 1.0, 1.0, &
      0.965, 1.0, 0.096, 0.37, 0.37, 0.1, 0.05, 0.048, 0.3, 0.049, 0.333, &
      0.201, 0.006, 2.0, 1.0, 1.0, 1.0, 0.39, 1.0, 0.8, 2.0, 0.35, 1.0, 0.66, &
      1.0, 0.208, 0.33, 0.164, 0.285, 0.5, 0.12, 0.266, 0.567, 0.246, 0.155, &
      0.378, 2.0, 1.0, 1.0 /)



  CONTAINS

!------------------------------------ CSR ------------------------------------
! Retrieves an element from a compressed sparse row matrix                    
!                                                                             
! @param[in]     nz   Matrix nonzero values                                   
! @param[in]     crow Row start indices                                       
! @param[in]     icol Column indices                                          
! @param[in]     row  Row index into matrix                                   
! @param[in]     col  Column index into matrix                                
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION CSR(nz, crow, icol, row, col)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: nz(:)
    INTEGER, INTENT(IN) :: crow(:)
    INTEGER, INTENT(IN) :: icol(:)
    INTEGER, INTENT(IN) :: row
    INTEGER, INTENT(IN) :: col

    ! i-loop index 
    INTEGER :: i

    i = crow(row)
    DO WHILE (i < crow(row + 1))
      IF (icol(i) == col) THEN
        CSR = nz(i)
        RETURN
      END IF ! icol(i) == col 
      i = i + 1
    END DO ! i < crow(row + 1) 
    CSR = 0
    RETURN
  END FUNCTION CSR



END MODULE saprc99_sparse
!------------------------- END saprc99_sparse.f90 END ------------------------
