!----------------------- BEGIN saprc99_rates.f90 BEGIN -----------------------
! @file saprc99_rates.f90                                                     
! @author jlinford                                                            
! @date 2017-02-27 19:38:46.348645                                            
! @brief Reaction rate calculation and utility functions                      
!                                                                             
! Reaction rate calculation and utility functions                             
!                                                                             
! This file was generated by Kppa: http://www.paratools.com/Kppa              
!-----------------------------------------------------------------------------


MODULE saprc99_rates

  USE saprc99_parameters

  IMPLICIT NONE





  CONTAINS

!------------------------------------ ARR ------------------------------------
! @param[in]     a0   None                                                    
! @param[in]     b0   None                                                    
! @param[in]     c0   None                                                    
! @param[in]     temp Temperature                                             
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION ARR(a0, b0, c0, temp)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: a0
    REAL(8), INTENT(IN) :: b0
    REAL(8), INTENT(IN) :: c0
    REAL(8), INTENT(IN) :: temp

        ARR = a0 * (temp/300.0)**c0 * EXP(-b0/temp)
  END FUNCTION ARR


!------------------------------------ ARR2 -----------------------------------
! @param[in]     a0   None                                                    
! @param[in]     b0   None                                                    
! @param[in]     temp Temperature                                             
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION ARR2(a0, b0, temp)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: a0
    REAL(8), INTENT(IN) :: b0
    REAL(8), INTENT(IN) :: temp

        ARR2 = a0 * EXP(b0/temp)
  END FUNCTION ARR2


!------------------------------------ EP2 ------------------------------------
! @param[in]     a0   None                                                    
! @param[in]     c0   None                                                    
! @param[in]     a2   None                                                    
! @param[in]     c2   None                                                    
! @param[in]     a3   None                                                    
! @param[in]     c3   None                                                    
! @param[in]     temp Temperature                                             
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION EP2(a0, c0, a2, c2, a3, c3, temp)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: a0
    REAL(8), INTENT(IN) :: c0
    REAL(8), INTENT(IN) :: a2
    REAL(8), INTENT(IN) :: c2
    REAL(8), INTENT(IN) :: a3
    REAL(8), INTENT(IN) :: c3
    REAL(8), INTENT(IN) :: temp

        REAL(8) :: k0, k2, k3

        k0 = a0 * EXP(-c0/temp)
        k2 = a2 * EXP(-c2/temp)
        k3 = a3 * EXP(-c3/temp) * 1.0e6*CFACTOR
        
        EP2 = k0 + k3/(1.0 + k3/k2)
  END FUNCTION EP2


!------------------------------------ EP3 ------------------------------------
! @param[in]     a1   None                                                    
! @param[in]     c1   None                                                    
! @param[in]     a2   None                                                    
! @param[in]     c2   None                                                    
! @param[in]     temp Temperature                                             
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION EP3(a1, c1, a2, c2, temp)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: a1
    REAL(8), INTENT(IN) :: c1
    REAL(8), INTENT(IN) :: a2
    REAL(8), INTENT(IN) :: c2
    REAL(8), INTENT(IN) :: temp

        REAL(8) :: k1, k2
        
        k1 = a1 * EXP(-c1/temp)
        k2 = a2 * EXP(-c2/temp) * 1.0e6*CFACTOR
        
        EP3 = k1 + k2
  END FUNCTION EP3


!------------------------------------ FALL -----------------------------------
! @param[in]     a0   None                                                    
! @param[in]     b0   None                                                    
! @param[in]     c0   None                                                    
! @param[in]     a1   None                                                    
! @param[in]     b1   None                                                    
! @param[in]     c1   None                                                    
! @param[in]     cf   None                                                    
! @param[in]     temp Temperature                                             
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION FALL(a0, b0, c0, a1, b1, c1, cf, temp)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: a0
    REAL(8), INTENT(IN) :: b0
    REAL(8), INTENT(IN) :: c0
    REAL(8), INTENT(IN) :: a1
    REAL(8), INTENT(IN) :: b1
    REAL(8), INTENT(IN) :: c1
    REAL(8), INTENT(IN) :: cf
    REAL(8), INTENT(IN) :: temp

        REAL(8) :: k0, k1
    
        k0 = a0 * (temp/300.0)**c0 * EXP(-b0/temp) * 1.0e6*CFACTOR
        k1 = k0 / (a1 * (temp/300.0)**c1 * EXP(-b1/temp))
        
        FALL = (k0/(1.0+k1)) * cf**(1.0/(1.0+LOG10(k1)**2.0))
  END FUNCTION FALL


!------------------------------------ TROE -----------------------------------
! Troe reactions (Stockwell et. al., 1997)                                    
!                                                                             
! @param[in]     k0_300K   None                                               
! @param[in]     n         None                                               
! @param[in]     kinf_300K None                                               
! @param[in]     m         None                                               
! @param[in]     temp      Temperature                                        
! @param[in]     cair      None                                               
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION TROE(k0_300K, n, kinf_300K, m, temp, cair)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: k0_300K
    REAL(8), INTENT(IN) :: n
    REAL(8), INTENT(IN) :: kinf_300K
    REAL(8), INTENT(IN) :: m
    REAL(8), INTENT(IN) :: temp
    REAL(8), INTENT(IN) :: cair

        REAL(8) :: zt_help, k0_T, kinf_T, k_ratio
    
        zt_help = 300.0/temp
        k0_T = k0_300K * zt_help**n * cair
        kinf_T = kinf_300K * zt_help**m
        k_ratio = k0_T/kinf_T
    
        TROE = k0_T / (1.0 + k_ratio) * 0.6**(1.0/(1.0+LOG10(k_ratio)**2))
  END FUNCTION TROE


!----------------------------------- TROEE -----------------------------------
! Troe equilibrium reactions (Stockwell et. al., 1997)                        
!                                                                             
! @param[in]     a0        None                                               
! @param[in]     b0        None                                               
! @param[in]     k0_300K   None                                               
! @param[in]     n         None                                               
! @param[in]     kinf_300K None                                               
! @param[in]     m         None                                               
! @param[in]     temp      Temperature                                        
! @param[in]     cair      None                                               
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION TROEE(a0, b0, k0_300K, n, kinf_300K, m, temp, cair)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: a0
    REAL(8), INTENT(IN) :: b0
    REAL(8), INTENT(IN) :: k0_300K
    REAL(8), INTENT(IN) :: n
    REAL(8), INTENT(IN) :: kinf_300K
    REAL(8), INTENT(IN) :: m
    REAL(8), INTENT(IN) :: temp
    REAL(8), INTENT(IN) :: cair

        REAL(8) :: zt_help, k0_T, kinf_T, k_ratio, troe
    
        zt_help = 300.0/temp
        k0_T = k0_300K * zt_help**n * cair
        kinf_T = kinf_300K * zt_help**m
        k_ratio = k0_T/kinf_T 
        troe = k0_T / (1.0 + k_ratio) * 0.6**(1.0/(1.0+ LOG10(k_ratio)**2))
    
        TROEE = a0 * EXP(-b0 / temp) * troe;
  END FUNCTION TROEE


!---------------------------------- Sunlight ---------------------------------
! Calculates sunlight intensity in the range [0,1] as a function of time.     
! Modify this routine to get the correct sunlight values for your model.      
!                                                                             
! @param[in]     time Integration time                                        
! @param[in]     idx  Current grid cell index                                 
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION Sunlight(time, idx)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: time
    INTEGER, INTENT(IN) :: idx

    REAL(8) :: SunRise, SunSet
    REAL(8) :: Thour, Tlocal, Ttmp
    ! PI - Value of pi
    REAL(8), PARAMETER :: PI = 3.14159265358979d0

    SunRise = 4.5
    SunSet  = 19.5
    Thour = TIME/3600.0
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       Sunlight = ( 1.0 + COS(PI*Ttmp) )/2.0
    ELSE
       Sunlight = 0.0
    END IF
  END FUNCTION Sunlight


!-------------------------------- Temperature --------------------------------
! Calculates temperature (kelvin) as a function of time.                      
! Modify this routine to get the correct temperature values for your model.   
!                                                                             
! @param[in]     time Integration time                                        
! @param[in]     idx  Current grid cell index                                 
!-----------------------------------------------------------------------------
  REAL(8) FUNCTION Temperature(time, idx)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: time
    INTEGER, INTENT(IN) :: idx

!        REAL, PARAMETER :: PI = 4.0*ATAN(1.0)   ! Pi
!        REAL, PARAMETER :: mintemp = 280        ! 280 Kelvin ~= 44 Fahrenheit
!        REAL, PARAMETER :: maxtemp = 300        ! 300 Kelvin ~= 80 Fahrenheit
!        REAL :: tmp
!
!        ! Estimate temperature cycling from mintemp to maxtemp
!        tmp = SIN(time*PI/(24*3600))
!        IF (tmp < 0) THEN
!            tmp = mintemp - tmp * (maxtemp-mintemp)
!        ELSE
!            tmp = mintemp + tmp * (maxtemp-mintemp)
!        END IF
!        Temperature = tmp

    Temperature = 300.0d0

  END FUNCTION Temperature


!----------------------------------- Rates -----------------------------------
! Calculates reaction rate coefficients                                       
!                                                                             
! @param[in]     time Integration time                                        
! @param[in]     idx  Current grid cell index                                 
! @param[out]    rct  Reaction rates                                          
!-----------------------------------------------------------------------------
  SUBROUTINE Rates(time, idx, rct)
    IMPLICIT NONE

    REAL(8), INTENT(IN) :: time
    INTEGER, INTENT(IN) :: idx
    REAL(8), INTENT(OUT) :: rct(211)

    ! Sunlight intensity: 0 to 1 inclusive (uppercase for KPP compatibility) 
    REAL(8) :: SUN
    ! Temperature in kelvin  (uppercase for KPP compatibility) 
    REAL(8) :: TEMP

    SUN = Sunlight(time, idx)
    TEMP = Temperature(time, idx)

    rct(1) = 6.69e-1*(SUN/60.0e0)
    rct(2) = ARR(5.68e-34,0.0e0,-2.80e0,TEMP)
    rct(3) = ARR(8.00e-12,2060.0e0,0.0e0,TEMP)
    rct(4) = ARR(1.00e-31,0.0e0,-1.60e0,TEMP)
    rct(5) = ARR(6.50e-12,-120.0e0,0.0e0,TEMP)
    rct(6) = FALL(9.00e-32,0.0e0,-2.00e0,2.20e-11,0.0e0,0.0e0,0.80e0,TEMP)
    rct(7) = ARR(1.80e-12,1370.0e0,0.0e0,TEMP)
    rct(8) = ARR(1.40e-13,2470.0e0,0.0e0,TEMP)
    rct(9) = ARR(1.80e-11,-110.0e0,0.0e0,TEMP)
    rct(10) = ARR(3.30e-39,-530.0e0,0.0e0,TEMP)
    rct(11) = FALL(2.80e-30,0.0e0,-3.50e0,2.00e-12,0.0e0,0.20e0,0.45e0,TEMP)
    rct(12) = &
        FALL(1.e-3,11000.0e0,-3.5e0,9.7e+14,11080.0e0,0.1e0,0.45e0,TEMP)
    rct(13) = 2.6e-22
    rct(14) = ARR(4.50e-14,1260.0e0,0.0e0,TEMP)
    rct(15) = 1.59e0*(SUN/60.0e0)
    rct(16) = 1.50e+1*(SUN/60.0e0)
    rct(17) = 3.76e-2*(SUN/60.0e0)
    rct(18) = 4.19e-3*(SUN/60.0e0)
    rct(19) = 2.2e-10
    rct(20) = ARR(2.09e-11,-95.0e0,0.0e0,TEMP)
    rct(21) = FALL(7.00e-31,0.0e0,-2.60e0,3.60e-11,0.0e0,-0.10e0,0.60e0,TEMP)
    rct(22) = 1.27e-1*(SUN/60.0e0)
    rct(23) = 1.60e-2*(SUN/60.0e0)
    rct(24) = ARR(2.70e-12,-260.0e0,0.0e0,TEMP)
    rct(25) = FALL(2.43e-30, &
        0.0e0,-3.10e0,1.67e-11,0.0e0,-2.10e0,0.60e0,TEMP)
    rct(26) = 2e-11
    rct(27) = &
        EP2(7.20e-15,-785.0e0,4.10e-16,-1440.0e0,1.90e-33,-725.0e0,TEMP)
    rct(28) = 5.40e-5*(SUN/60.0e0)
    rct(29) = EP3(1.30e-13,0.0e0,3.19e-33,0.0e0,TEMP)
    rct(30) = ARR(1.90e-12,1000.0e0,0.0e0,TEMP)
    rct(31) = ARR(3.40e-12,-270.0e0,0.0e0,TEMP)
    rct(32) = FALL(1.80e-31,0.0,-3.20,4.70e-12,0.0e0,0.0,0.6,TEMP)
    rct(33) = FALL(4.10e-05,10650.0,0.0,5.7e+15,11170.0,0.0,0.5,TEMP)
    rct(34) = 4.69e-4*(SUN/60.0e0)
    rct(35) = ARR(1.50e-12,-360.0e0,0.0e0,TEMP)
    rct(36) = ARR(1.40e-14,600.0e0,0.0e0,TEMP)
    rct(37) = EP3(2.20e-13,-600.0e0,1.85e-33,-980.0e0,TEMP)
    rct(38) = EP3(3.08e-34,-2800.0e0,2.59e-54,-3180.0e0,TEMP)
    rct(39) = 4e-12
    rct(40) = ARR(8.50e-13,2450.0e0,0.0e0,TEMP)
    rct(41) = 5.64e-4*(SUN/60.0e0)
    rct(42) = ARR(2.90e-12,160.0e0,0.0e0,TEMP)
    rct(43) = ARR(4.80e-11,-250.0e0,0.0e0,TEMP)
    rct(44) = FALL(4.00e-31,0.0e0,-3.30e0,2.00e-12,0.0e0,0.0e0,0.45e0,TEMP)
    rct(45) = ARR(7.70e-12,2100.0e0,0.0e0,TEMP)
    rct(46) = ARR(2.80e-12,-285.0e0,0.0e0,TEMP)
    rct(47) = ARR(3.80e-13,-780.0e0,0.0e0,TEMP)
    rct(48) = 1.3e-12
    rct(49) = ARR(2.45e-14,-710.0e0,0.0e0,TEMP)
    rct(50) = ARR(5.90e-13,509.0e0,0.0e0,TEMP)
    rct(51) = ARR(2.70e-12,-360.0e0,0.0e0,TEMP)
    rct(52) = ARR(1.90e-13,-1300.0e0,0.0e0,TEMP)
    rct(53) = 2.3e-12
    rct(54) = 2e-13
    rct(55) = 3.5e-14
    rct(56) = ARR(2.70e-12,-360.0e0,0.0e0,TEMP)
    rct(57) = ARR(1.90e-13,-1300.0e0,0.0e0,TEMP)
    rct(58) = 2.3e-12
    rct(59) = 2e-13
    rct(60) = 3.5e-14
    rct(61) = 0.0
    rct(62) = ARR(2.70e-12,-360.0e0,0.0e0,TEMP)
    rct(63) = ARR(1.90e-13,-1300.0e0,0.0e0,TEMP)
    rct(64) = 2e-13
    rct(65) = 2.3e-12
    rct(66) = 3.5e-14
    rct(67) = 3.5e-14
    rct(68) = 3.5e-14
    rct(69) = FALL(2.70e-28,0.0e0,-7.10e0,1.20e-11,0.0e0,-0.90e0,0.30e0,TEMP)
    rct(70) = FALL(4.90e-3,12100.0e0,0.0e0,4.0e+16,13600.0e0,0.e0,0.3e0,TEMP)
    rct(71) = ARR(7.80e-12,-300.0e0,0.0e0,TEMP)
    rct(72) = ARR(4.30e-13,-1040.0e0,0.0e0,TEMP)
    rct(73) = 4e-12
    rct(74) = ARR(1.80e-12,-500.0e0,0.0e0,TEMP)
    rct(75) = 7.5e-12
    rct(76) = 7.5e-12
    rct(77) = 7.5e-12
    rct(78) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(79) = ARR(1.20e-11,0.0e0,-0.90e0,TEMP)
    rct(80) = ARR(2.00e+15,12800.0e0,0.0e0,TEMP)
    rct(81) = ARR(1.25e-11,-240.0e0,0.0e0,TEMP)
    rct(82) = ARR(4.30e-13,-1040.0e0,0.0e0,TEMP)
    rct(83) = 4e-12
    rct(84) = ARR(1.80e-12,-500.0e0,0.0e0,TEMP)
    rct(85) = 7.5e-12
    rct(86) = 7.5e-12
    rct(87) = 7.5e-12
    rct(88) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(89) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(90) = 1.37e-11
    rct(91) = ARR(7.90e+16,14000.0e0,0.0e0,TEMP)
    rct(92) = ARR(1.25e-11,-240.0e0,0.0e0,TEMP)
    rct(93) = ARR(4.30e-13,-1040.0e0,0.0e0,TEMP)
    rct(94) = 4e-12
    rct(95) = ARR(1.80e-12,-500.0e0,0.0e0,TEMP)
    rct(96) = 7.5e-12
    rct(97) = 7.5e-12
    rct(98) = 7.5e-12
    rct(99) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(100) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(101) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(102) = ARR(1.20e-11,0.0e0,-0.90e0,TEMP)
    rct(103) = ARR(1.60e+16,13486.0e0,0.0e0,TEMP)
    rct(104) = ARR(1.25e-11,-240.0e0,0.0e0,TEMP)
    rct(105) = ARR(4.30e-13,-1040.0e0,0.0e0,TEMP)
    rct(106) = 4e-12
    rct(107) = ARR(1.80e-12,-500.0e0,0.0e0,TEMP)
    rct(108) = 7.5e-12
    rct(109) = 7.5e-12
    rct(110) = 7.5e-12
    rct(111) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(112) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(113) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(114) = ARR(2.90e-12,-500.0e0,0.0e0,TEMP)
    rct(115) = 2.4e-11
    rct(116) = ARR(7.50e+14,8152.0e0,0.0e0,TEMP)
    rct(117) = ARR(2.30e-11,-150.0e0,0.0e0,TEMP)
    rct(118) = ARR(1.90e-13,-1300.0e0,0.0e0,TEMP)
    rct(119) = 0.001
    rct(120) = ARR(7.50e+14,8152.0e0,0.0e0,TEMP)
    rct(121) = ARR(2.30e-11,-150.0e0,0.0e0,TEMP)
    rct(122) = ARR(1.90e-13,-1300.0e0,0.0e0,TEMP)
    rct(123) = 2.32e-3*(SUN/60.0e0)
    rct(124) = 3.15e-3*(SUN/60.0e0)
    rct(125) = ARR(8.60e-12,-20.0e0,0.0e0,TEMP)
    rct(126) = ARR(9.70e-15,-625.0e0,0.0e0,TEMP)
    rct(127) = ARR(2.40e+12,7000.0e0,0.0e0,TEMP)
    rct(128) = ARR(2.80e-12,-285.0e0,0.0e0,TEMP)
    rct(129) = ARR(2.00e-12,2431.0e0,0.0e0,TEMP)
    rct(130) = ARR(5.60e-12,-310.0e0,0.0e0,TEMP)
    rct(131) = 4.16e-4*(SUN/60.0e0)
    rct(132) = ARR(1.40e-12,1860.0e0,0.0e0,TEMP)
    rct(133) = 2e-11
    rct(134) = 1.40e-3*(SUN/60.0e0)
    rct(135) = ARR(1.40e-12,1771.0e0,0.0e0,TEMP)
    rct(136) = ARR(1.10e-12,520.0e0,0.0e0,TEMP)
    rct(137) = 4.16e-5*(SUN/60.0e0)
    rct(138) = ARR(1.30e-12,25.0e0,2.0e0,TEMP)
    rct(139) = 9.49e-4*(1.50e-1*SUN/60.0e0)
    rct(140) = ARR(3.10e-12,360.0e0,2.0e0,TEMP)
    rct(141) = ARR(2.90e-12,-190.0e0,0.0e0,TEMP)
    rct(142) = 3.94e-4*(SUN/60.0e0)
    rct(143) = 1.1e-11
    rct(144) = 3.94e-4*(SUN/60.0e0)
    rct(145) = 8.93e-3*(SUN/60.0e0)
    rct(146) = 1.81e-1*(6.00e-3*SUN/60.0e0)
    rct(147) = 1.1e-11
    rct(148) = ARR(2.80e-12,2376.0e0,0.0e0,TEMP)
    rct(149) = 1.10e-2*(SUN/60.0e0)
    rct(150) = 1.5e-11
    rct(151) = ARR(1.40e-12,1895.0e0,0.0e0,TEMP)
    rct(152) = 1.90e-2*(SUN/60.0e0)
    rct(153) = 2.63e-11
    rct(154) = 3.78e-12
    rct(155) = 4.2e-11
    rct(156) = 1.37e-11
    rct(157) = 3.78e-12
    rct(158) = 1.29e-11
    rct(159) = 6.22e-2*(5.00e-2*SUN/60.0e0)
    rct(160) = ARR(1.40e-12,1872.0e0,0.0e0,TEMP)
    rct(161) = ARR(1.86e-11,-176.0e0,0.0e0,TEMP)
    rct(162) = ARR(1.36e-15,2114.0e0,0.0e0,TEMP)
    rct(163) = ARR(1.50e-12,1726.0e0,0.0e0,TEMP)
    rct(164) = 6.34e-12
    rct(165) = 3.32e-2*(4.10e-3*SUN/60.0e0)
    rct(166) = ARR(4.14e-12,-453.0e0,0.0e0,TEMP)
    rct(167) = ARR(7.51e-16,1520.0e0,0.0e0,TEMP)
    rct(168) = 4.32e-12
    rct(169) = 3.32e-2*(2.10e-3*SUN/60.0e0)
    rct(170) = 6.19e-11
    rct(171) = 4.18e-18
    rct(172) = 1e-13
    rct(173) = 3.32e-2*(4.10e-3*SUN/60.0e0)
    rct(174) = 1.5e-11
    rct(175) = 9.49e-4*(2.00e-2*SUN/60.0e0)
    rct(176) = 7.8e-12
    rct(177) = 2.35e-4*(SUN/60.0e0)
    rct(178) = 5e-11
    rct(179) = 2e-18
    rct(180) = 5e-11
    rct(181) = 2.06e-1*(3.65e-1*SUN/60.0e0)
    rct(182) = 5e-11
    rct(183) = 3.32e-2*(7.28e0*SUN/60.0e0)
    rct(184) = ARR(2.15e-12,1735.0e0,0.0e0,TEMP)
    rct(185) = ARR(1.96e-12,-438.0e0,0.0e0,TEMP)
    rct(186) = ARR(9.14e-15,2580.0e0,0.0e0,TEMP)
    rct(187) = ARR(4.39e-13,2282.0e0,2.0e0,TEMP)
    rct(188) = ARR(1.04e-11,792.0e0,0.0e0,TEMP)
    rct(189) = ARR(2.50e-11,-408.0e0,0.0e0,TEMP)
    rct(190) = ARR(7.86e-15,1912.0e0,0.0e0,TEMP)
    rct(191) = ARR(3.03e-12,448.0e0,0.0e0,TEMP)
    rct(192) = 3.6e-11
    rct(193) = ARR(1.83e-11,-449.0e0,0.0e0,TEMP)
    rct(194) = ARR(1.08e-15,821.0e0,0.0e0,TEMP)
    rct(195) = ARR(3.66e-12,-175.e00,0.0e0,TEMP)
    rct(196) = 3.27e-11
    rct(197) = ARR(1.37e-12,498.0e0,2.0e0,TEMP)
    rct(198) = ARR(9.87e-12,671.0e0,0.0e0,TEMP)
    rct(199) = ARR(1.019e-11,434.0e0,0.0e0,TEMP)
    rct(200) = ARR(5.946e-12,91.0e0,0.0e0,TEMP)
    rct(201) = ARR(1.112e-11,52.0e0,0.0e0,TEMP)
    rct(202) = ARR(1.81e-12,-355.0e0,0.0e0,TEMP)
    rct(203) = 2.64e-11
    rct(204) = ARR(7.095e-12,-451.0e0,0.0e0,TEMP)
    rct(205) = ARR(2.617e-15,1640.0e0,0.0e0,TEMP)
    rct(206) = ARR(4.453e-14,376.0e0,0.0e0,TEMP)
    rct(207) = ARR(1.074e-11,234.0e0,0.0e0,TEMP)
    rct(208) = ARR(1.743e-11,-384.0e0,0.0e0,TEMP)
    rct(209) = ARR(5.022e-16,461.0e0,0.0e0,TEMP)
    rct(210) = 7.265e-13
    rct(211) = 2.085e-11
  END SUBROUTINE Rates



END MODULE saprc99_rates
!------------------------- END saprc99_rates.f90 END -------------------------
